package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class PipelineResourceSpecFluentImpl<A extends PipelineResourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PipelineResourceSpecFluent<A>{

    private List<ParamBuilder> params;
    private List<SecretParamBuilder> secrets;
    private String type;

    public PipelineResourceSpecFluentImpl(){
    }
    public PipelineResourceSpecFluentImpl(PipelineResourceSpec instance){
            this.withParams(instance.getParams()); 
            this.withSecrets(instance.getSecrets()); 
            this.withType(instance.getType()); 
    }

    public A addToParams(int index,Param item){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(index >= 0 ? index : _visitables.get("params").size(), builder);this.params.add(index >= 0 ? index : params.size(), builder); return (A)this;
    }

    public A setToParams(int index,Param item){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            ParamBuilder builder = new ParamBuilder(item);
            if (index < 0 || index >= _visitables.get("params").size()) { _visitables.get("params").add(builder); } else { _visitables.get("params").set(index, builder);}
            if (index < 0 || index >= params.size()) { params.add(builder); } else { params.set(index, builder);}
             return (A)this;
    }

    public A addToParams(Param... items){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A addAllToParams(Collection<Param> items){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A removeFromParams(Param... items){
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    public A removeAllFromParams(Collection<Param> items){
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public List<Param> getParams(){
            return build(params);
    }

    public List<Param> buildParams(){
            return build(params);
    }

    public Param buildParam(int index){
            return this.params.get(index).build();
    }

    public Param buildFirstParam(){
            return this.params.get(0).build();
    }

    public Param buildLastParam(){
            return this.params.get(params.size() - 1).build();
    }

    public Param buildMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            for (ParamBuilder item: params) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            for (ParamBuilder item: params) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withParams(List<Param> params){
            if (this.params != null) { _visitables.get("params").removeAll(this.params);}
            if (params != null) {this.params = new ArrayList<ParamBuilder>(); for (Param item : params){this.addToParams(item);}} else { this.params = new ArrayList<ParamBuilder>();} return (A) this;
    }

    public A withParams(Param... params){
            if (this.params != null) {this.params.clear();}
            if (params != null) {for (Param item :params){ this.addToParams(item);}} return (A) this;
    }

    public Boolean hasParams(){
            return params != null && !params.isEmpty();
    }

    public A addNewParam(String name,String value){
            return (A)addToParams(new Param(name, value));
    }

    public PipelineResourceSpecFluent.ParamsNested<A> addNewParam(){
            return new ParamsNestedImpl();
    }

    public PipelineResourceSpecFluent.ParamsNested<A> addNewParamLike(Param item){
            return new ParamsNestedImpl(-1, item);
    }

    public PipelineResourceSpecFluent.ParamsNested<A> setNewParamLike(int index,Param item){
            return new ParamsNestedImpl(index, item);
    }

    public PipelineResourceSpecFluent.ParamsNested<A> editParam(int index){
            if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
            return setNewParamLike(index, buildParam(index));
    }

    public PipelineResourceSpecFluent.ParamsNested<A> editFirstParam(){
            if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
            return setNewParamLike(0, buildParam(0));
    }

    public PipelineResourceSpecFluent.ParamsNested<A> editLastParam(){
            int index = params.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
            return setNewParamLike(index, buildParam(index));
    }

    public PipelineResourceSpecFluent.ParamsNested<A> editMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            int index = -1;
            for (int i=0;i<params.size();i++) { 
            if (predicate.apply(params.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
            return setNewParamLike(index, buildParam(index));
    }

    public A addToSecrets(int index,SecretParam item){
            if (this.secrets == null) {this.secrets = new ArrayList<SecretParamBuilder>();}
            SecretParamBuilder builder = new SecretParamBuilder(item);_visitables.get("secrets").add(index >= 0 ? index : _visitables.get("secrets").size(), builder);this.secrets.add(index >= 0 ? index : secrets.size(), builder); return (A)this;
    }

    public A setToSecrets(int index,SecretParam item){
            if (this.secrets == null) {this.secrets = new ArrayList<SecretParamBuilder>();}
            SecretParamBuilder builder = new SecretParamBuilder(item);
            if (index < 0 || index >= _visitables.get("secrets").size()) { _visitables.get("secrets").add(builder); } else { _visitables.get("secrets").set(index, builder);}
            if (index < 0 || index >= secrets.size()) { secrets.add(builder); } else { secrets.set(index, builder);}
             return (A)this;
    }

    public A addToSecrets(SecretParam... items){
            if (this.secrets == null) {this.secrets = new ArrayList<SecretParamBuilder>();}
            for (SecretParam item : items) {SecretParamBuilder builder = new SecretParamBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
    }

    public A addAllToSecrets(Collection<SecretParam> items){
            if (this.secrets == null) {this.secrets = new ArrayList<SecretParamBuilder>();}
            for (SecretParam item : items) {SecretParamBuilder builder = new SecretParamBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
    }

    public A removeFromSecrets(SecretParam... items){
            for (SecretParam item : items) {SecretParamBuilder builder = new SecretParamBuilder(item);_visitables.get("secrets").remove(builder);if (this.secrets != null) {this.secrets.remove(builder);}} return (A)this;
    }

    public A removeAllFromSecrets(Collection<SecretParam> items){
            for (SecretParam item : items) {SecretParamBuilder builder = new SecretParamBuilder(item);_visitables.get("secrets").remove(builder);if (this.secrets != null) {this.secrets.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<SecretParam> getSecrets(){
            return build(secrets);
    }

    public List<SecretParam> buildSecrets(){
            return build(secrets);
    }

    public SecretParam buildSecret(int index){
            return this.secrets.get(index).build();
    }

    public SecretParam buildFirstSecret(){
            return this.secrets.get(0).build();
    }

    public SecretParam buildLastSecret(){
            return this.secrets.get(secrets.size() - 1).build();
    }

    public SecretParam buildMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<SecretParamBuilder> predicate){
            for (SecretParamBuilder item: secrets) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<SecretParamBuilder> predicate){
            for (SecretParamBuilder item: secrets) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withSecrets(List<SecretParam> secrets){
            if (this.secrets != null) { _visitables.get("secrets").removeAll(this.secrets);}
            if (secrets != null) {this.secrets = new ArrayList<SecretParamBuilder>(); for (SecretParam item : secrets){this.addToSecrets(item);}} else { this.secrets = new ArrayList<SecretParamBuilder>();} return (A) this;
    }

    public A withSecrets(SecretParam... secrets){
            if (this.secrets != null) {this.secrets.clear();}
            if (secrets != null) {for (SecretParam item :secrets){ this.addToSecrets(item);}} return (A) this;
    }

    public Boolean hasSecrets(){
            return secrets != null && !secrets.isEmpty();
    }

    public A addNewSecret(String fieldName,String secretKey,String secretName){
            return (A)addToSecrets(new SecretParam(fieldName, secretKey, secretName));
    }

    public PipelineResourceSpecFluent.SecretsNested<A> addNewSecret(){
            return new SecretsNestedImpl();
    }

    public PipelineResourceSpecFluent.SecretsNested<A> addNewSecretLike(SecretParam item){
            return new SecretsNestedImpl(-1, item);
    }

    public PipelineResourceSpecFluent.SecretsNested<A> setNewSecretLike(int index,SecretParam item){
            return new SecretsNestedImpl(index, item);
    }

    public PipelineResourceSpecFluent.SecretsNested<A> editSecret(int index){
            if (secrets.size() <= index) throw new RuntimeException("Can't edit secrets. Index exceeds size.");
            return setNewSecretLike(index, buildSecret(index));
    }

    public PipelineResourceSpecFluent.SecretsNested<A> editFirstSecret(){
            if (secrets.size() == 0) throw new RuntimeException("Can't edit first secrets. The list is empty.");
            return setNewSecretLike(0, buildSecret(0));
    }

    public PipelineResourceSpecFluent.SecretsNested<A> editLastSecret(){
            int index = secrets.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last secrets. The list is empty.");
            return setNewSecretLike(index, buildSecret(index));
    }

    public PipelineResourceSpecFluent.SecretsNested<A> editMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<SecretParamBuilder> predicate){
            int index = -1;
            for (int i=0;i<secrets.size();i++) { 
            if (predicate.apply(secrets.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching secrets. No match found.");
            return setNewSecretLike(index, buildSecret(index));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineResourceSpecFluentImpl that = (PipelineResourceSpecFluentImpl) o;
            if (params != null ? !params.equals(that.params) :that.params != null) return false;
            if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class ParamsNestedImpl<N> extends ParamFluentImpl<PipelineResourceSpecFluent.ParamsNested<N>> implements PipelineResourceSpecFluent.ParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ParamBuilder builder;
        private final int index;
    
            ParamsNestedImpl(int index,Param item){
                    this.index = index;
                    this.builder = new ParamBuilder(this, item);
            }
            ParamsNestedImpl(){
                    this.index = -1;
                    this.builder = new ParamBuilder(this);
            }
    
    public N and(){
            return (N) PipelineResourceSpecFluentImpl.this.setToParams(index, builder.build());
    }
    public N endParam(){
            return and();
    }

}
    public class SecretsNestedImpl<N> extends SecretParamFluentImpl<PipelineResourceSpecFluent.SecretsNested<N>> implements PipelineResourceSpecFluent.SecretsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecretParamBuilder builder;
        private final int index;
    
            SecretsNestedImpl(int index,SecretParam item){
                    this.index = index;
                    this.builder = new SecretParamBuilder(this, item);
            }
            SecretsNestedImpl(){
                    this.index = -1;
                    this.builder = new SecretParamBuilder(this);
            }
    
    public N and(){
            return (N) PipelineResourceSpecFluentImpl.this.setToSecrets(index, builder.build());
    }
    public N endSecret(){
            return and();
    }

}


}
