package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineResourceStatusBuilder extends PipelineResourceStatusFluentImpl<PipelineResourceStatusBuilder> implements VisitableBuilder<PipelineResourceStatus,PipelineResourceStatusBuilder>{

    PipelineResourceStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineResourceStatusBuilder(){
            this(true);
    }
    public PipelineResourceStatusBuilder(Boolean validationEnabled){
            this(new PipelineResourceStatus(), validationEnabled);
    }
    public PipelineResourceStatusBuilder(PipelineResourceStatusFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineResourceStatusBuilder(PipelineResourceStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineResourceStatus(), validationEnabled);
    }
    public PipelineResourceStatusBuilder(PipelineResourceStatusFluent<?> fluent,PipelineResourceStatus instance){
            this(fluent, instance, true);
    }
    public PipelineResourceStatusBuilder(PipelineResourceStatusFluent<?> fluent,PipelineResourceStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceStatusBuilder(PipelineResourceStatus instance){
            this(instance,true);
    }
    public PipelineResourceStatusBuilder(PipelineResourceStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceStatusBuilder(Validator validator){
            this(new PipelineResourceStatus(), true);
    }
    public PipelineResourceStatusBuilder(PipelineResourceStatusFluent<?> fluent,PipelineResourceStatus instance,Validator validator){
            this.fluent = fluent; 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineResourceStatusBuilder(PipelineResourceStatus instance,Validator validator){
            this.fluent = this; 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineResourceStatus build(){
            PipelineResourceStatus buildable = new PipelineResourceStatus();
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineResourceStatusBuilder that = (PipelineResourceStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
