
package io.fabric8.tekton.pipeline.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Toleration;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "affinity",
    "nodeSelector",
    "params",
    "pipelineRef",
    "resources",
    "results",
    "serviceAccount",
    "serviceAccounts",
    "status",
    "timeout",
    "tolerations"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class PipelineRunSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("affinity")
    @Valid
    private Affinity affinity;
    /**
     * 
     * 
     */
    @JsonProperty("nodeSelector")
    @Valid
    private Map<String, String> nodeSelector;
    /**
     * 
     * 
     */
    @JsonProperty("params")
    @Valid
    private List<Param> params = new ArrayList<Param>();
    /**
     * 
     * 
     */
    @JsonProperty("pipelineRef")
    @Valid
    private PipelineRef pipelineRef;
    /**
     * 
     * 
     */
    @JsonProperty("resources")
    @Valid
    private List<PipelineResourceBinding> resources = new ArrayList<PipelineResourceBinding>();
    /**
     * 
     * 
     */
    @JsonProperty("results")
    @Valid
    private Results results;
    /**
     * 
     * 
     */
    @JsonProperty("serviceAccount")
    private java.lang.String serviceAccount;
    /**
     * 
     * 
     */
    @JsonProperty("serviceAccounts")
    @Valid
    private List<PipelineRunSpecServiceAccount> serviceAccounts = new ArrayList<PipelineRunSpecServiceAccount>();
    /**
     * 
     * 
     */
    @JsonProperty("status")
    private java.lang.String status;
    /**
     * 
     * 
     */
    @JsonProperty("timeout")
    @Valid
    private java.lang.String timeout;
    /**
     * 
     * 
     */
    @JsonProperty("tolerations")
    @Valid
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PipelineRunSpec() {
    }

    /**
     * 
     * @param serviceAccounts
     * @param tolerations
     * @param resources
     * @param serviceAccount
     * @param params
     * @param results
     * @param pipelineRef
     * @param timeout
     * @param affinity
     * @param nodeSelector
     * @param status
     */
    public PipelineRunSpec(Affinity affinity, Map<String, String> nodeSelector, List<Param> params, PipelineRef pipelineRef, List<PipelineResourceBinding> resources, Results results, java.lang.String serviceAccount, List<PipelineRunSpecServiceAccount> serviceAccounts, java.lang.String status, java.lang.String timeout, List<Toleration> tolerations) {
        this.affinity = affinity;
        this.nodeSelector = nodeSelector;
        this.params = params;
        this.pipelineRef = pipelineRef;
        this.resources = resources;
        this.results = results;
        this.serviceAccount = serviceAccount;
        this.serviceAccounts = serviceAccounts;
        this.status = status;
        this.timeout = timeout;
        this.tolerations = tolerations;
    }

    /**
     * 
     * 
     * @return
     *     The affinity
     */
    @JsonProperty("affinity")
    public Affinity getAffinity() {
        return affinity;
    }

    /**
     * 
     * 
     * @param affinity
     *     The affinity
     */
    @JsonProperty("affinity")
    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    /**
     * 
     * 
     * @return
     *     The nodeSelector
     */
    @JsonProperty("nodeSelector")
    public Map<String, String> getNodeSelector() {
        return nodeSelector;
    }

    /**
     * 
     * 
     * @param nodeSelector
     *     The nodeSelector
     */
    @JsonProperty("nodeSelector")
    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    /**
     * 
     * 
     * @return
     *     The params
     */
    @JsonProperty("params")
    public List<Param> getParams() {
        return params;
    }

    /**
     * 
     * 
     * @param params
     *     The params
     */
    @JsonProperty("params")
    public void setParams(List<Param> params) {
        this.params = params;
    }

    /**
     * 
     * 
     * @return
     *     The pipelineRef
     */
    @JsonProperty("pipelineRef")
    public PipelineRef getPipelineRef() {
        return pipelineRef;
    }

    /**
     * 
     * 
     * @param pipelineRef
     *     The pipelineRef
     */
    @JsonProperty("pipelineRef")
    public void setPipelineRef(PipelineRef pipelineRef) {
        this.pipelineRef = pipelineRef;
    }

    /**
     * 
     * 
     * @return
     *     The resources
     */
    @JsonProperty("resources")
    public List<PipelineResourceBinding> getResources() {
        return resources;
    }

    /**
     * 
     * 
     * @param resources
     *     The resources
     */
    @JsonProperty("resources")
    public void setResources(List<PipelineResourceBinding> resources) {
        this.resources = resources;
    }

    /**
     * 
     * 
     * @return
     *     The results
     */
    @JsonProperty("results")
    public Results getResults() {
        return results;
    }

    /**
     * 
     * 
     * @param results
     *     The results
     */
    @JsonProperty("results")
    public void setResults(Results results) {
        this.results = results;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccount
     */
    @JsonProperty("serviceAccount")
    public java.lang.String getServiceAccount() {
        return serviceAccount;
    }

    /**
     * 
     * 
     * @param serviceAccount
     *     The serviceAccount
     */
    @JsonProperty("serviceAccount")
    public void setServiceAccount(java.lang.String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccounts
     */
    @JsonProperty("serviceAccounts")
    public List<PipelineRunSpecServiceAccount> getServiceAccounts() {
        return serviceAccounts;
    }

    /**
     * 
     * 
     * @param serviceAccounts
     *     The serviceAccounts
     */
    @JsonProperty("serviceAccounts")
    public void setServiceAccounts(List<PipelineRunSpecServiceAccount> serviceAccounts) {
        this.serviceAccounts = serviceAccounts;
    }

    /**
     * 
     * 
     * @return
     *     The status
     */
    @JsonProperty("status")
    public java.lang.String getStatus() {
        return status;
    }

    /**
     * 
     * 
     * @param status
     *     The status
     */
    @JsonProperty("status")
    public void setStatus(java.lang.String status) {
        this.status = status;
    }

    /**
     * 
     * 
     * @return
     *     The timeout
     */
    @JsonProperty("timeout")
    public java.lang.String getTimeout() {
        return timeout;
    }

    /**
     * 
     * 
     * @param timeout
     *     The timeout
     */
    @JsonProperty("timeout")
    public void setTimeout(java.lang.String timeout) {
        this.timeout = timeout;
    }

    /**
     * 
     * 
     * @return
     *     The tolerations
     */
    @JsonProperty("tolerations")
    public List<Toleration> getTolerations() {
        return tolerations;
    }

    /**
     * 
     * 
     * @param tolerations
     *     The tolerations
     */
    @JsonProperty("tolerations")
    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
