package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PipelineRunSpecFluent<A extends PipelineRunSpecFluent<A>> extends Fluent<A>{


    public Affinity getAffinity();
    public A withAffinity(Affinity affinity);
    public Boolean hasAffinity();
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(Map<String,String> map);
    public Map<String,String> getNodeSelector();
    public A withNodeSelector(Map<String,String> nodeSelector);
    public Boolean hasNodeSelector();
    public A addToParams(int index,Param item);
    public A setToParams(int index,Param item);
    public A addToParams(Param... items);
    public A addAllToParams(Collection<Param> items);
    public A removeFromParams(Param... items);
    public A removeAllFromParams(Collection<Param> items);
    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public List<Param> getParams();
    public List<Param> buildParams();
    public Param buildParam(int index);
    public Param buildFirstParam();
    public Param buildLastParam();
    public Param buildMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate);
    public Boolean hasMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate);
    public A withParams(List<Param> params);
    public A withParams(Param... params);
    public Boolean hasParams();
    public A addNewParam(String name,String value);
    public PipelineRunSpecFluent.ParamsNested<A> addNewParam();
    public PipelineRunSpecFluent.ParamsNested<A> addNewParamLike(Param item);
    public PipelineRunSpecFluent.ParamsNested<A> setNewParamLike(int index,Param item);
    public PipelineRunSpecFluent.ParamsNested<A> editParam(int index);
    public PipelineRunSpecFluent.ParamsNested<A> editFirstParam();
    public PipelineRunSpecFluent.ParamsNested<A> editLastParam();
    public PipelineRunSpecFluent.ParamsNested<A> editMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPipelineRef instead.
 * @return The buildable object.
 */
@Deprecated public PipelineRef getPipelineRef();
    public PipelineRef buildPipelineRef();
    public A withPipelineRef(PipelineRef pipelineRef);
    public Boolean hasPipelineRef();
    public A withNewPipelineRef(String apiVersion,String name);
    public PipelineRunSpecFluent.PipelineRefNested<A> withNewPipelineRef();
    public PipelineRunSpecFluent.PipelineRefNested<A> withNewPipelineRefLike(PipelineRef item);
    public PipelineRunSpecFluent.PipelineRefNested<A> editPipelineRef();
    public PipelineRunSpecFluent.PipelineRefNested<A> editOrNewPipelineRef();
    public PipelineRunSpecFluent.PipelineRefNested<A> editOrNewPipelineRefLike(PipelineRef item);
    public A addToResources(int index,PipelineResourceBinding item);
    public A setToResources(int index,PipelineResourceBinding item);
    public A addToResources(PipelineResourceBinding... items);
    public A addAllToResources(Collection<PipelineResourceBinding> items);
    public A removeFromResources(PipelineResourceBinding... items);
    public A removeAllFromResources(Collection<PipelineResourceBinding> items);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineResourceBinding> getResources();
    public List<PipelineResourceBinding> buildResources();
    public PipelineResourceBinding buildResource(int index);
    public PipelineResourceBinding buildFirstResource();
    public PipelineResourceBinding buildLastResource();
    public PipelineResourceBinding buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceBindingBuilder> predicate);
    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceBindingBuilder> predicate);
    public A withResources(List<PipelineResourceBinding> resources);
    public A withResources(PipelineResourceBinding... resources);
    public Boolean hasResources();
    public PipelineRunSpecFluent.ResourcesNested<A> addNewResource();
    public PipelineRunSpecFluent.ResourcesNested<A> addNewResourceLike(PipelineResourceBinding item);
    public PipelineRunSpecFluent.ResourcesNested<A> setNewResourceLike(int index,PipelineResourceBinding item);
    public PipelineRunSpecFluent.ResourcesNested<A> editResource(int index);
    public PipelineRunSpecFluent.ResourcesNested<A> editFirstResource();
    public PipelineRunSpecFluent.ResourcesNested<A> editLastResource();
    public PipelineRunSpecFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceBindingBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildResults instead.
 * @return The buildable object.
 */
@Deprecated public Results getResults();
    public Results buildResults();
    public A withResults(Results results);
    public Boolean hasResults();
    public A withNewResults(String type,String url);
    public PipelineRunSpecFluent.ResultsNested<A> withNewResults();
    public PipelineRunSpecFluent.ResultsNested<A> withNewResultsLike(Results item);
    public PipelineRunSpecFluent.ResultsNested<A> editResults();
    public PipelineRunSpecFluent.ResultsNested<A> editOrNewResults();
    public PipelineRunSpecFluent.ResultsNested<A> editOrNewResultsLike(Results item);
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public Boolean hasServiceAccount();
    public A withNewServiceAccount(String arg1);
    public A withNewServiceAccount(StringBuilder arg1);
    public A withNewServiceAccount(StringBuffer arg1);
    public A addToServiceAccounts(int index,PipelineRunSpecServiceAccount item);
    public A setToServiceAccounts(int index,PipelineRunSpecServiceAccount item);
    public A addToServiceAccounts(PipelineRunSpecServiceAccount... items);
    public A addAllToServiceAccounts(Collection<PipelineRunSpecServiceAccount> items);
    public A removeFromServiceAccounts(PipelineRunSpecServiceAccount... items);
    public A removeAllFromServiceAccounts(Collection<PipelineRunSpecServiceAccount> items);
    
/**
 * This method has been deprecated, please use method buildServiceAccounts instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineRunSpecServiceAccount> getServiceAccounts();
    public List<PipelineRunSpecServiceAccount> buildServiceAccounts();
    public PipelineRunSpecServiceAccount buildServiceAccount(int index);
    public PipelineRunSpecServiceAccount buildFirstServiceAccount();
    public PipelineRunSpecServiceAccount buildLastServiceAccount();
    public PipelineRunSpecServiceAccount buildMatchingServiceAccount(io.fabric8.kubernetes.api.builder.Predicate<PipelineRunSpecServiceAccountBuilder> predicate);
    public Boolean hasMatchingServiceAccount(io.fabric8.kubernetes.api.builder.Predicate<PipelineRunSpecServiceAccountBuilder> predicate);
    public A withServiceAccounts(List<PipelineRunSpecServiceAccount> serviceAccounts);
    public A withServiceAccounts(PipelineRunSpecServiceAccount... serviceAccounts);
    public Boolean hasServiceAccounts();
    public A addNewServiceAccount(String serviceAccount,String taskName);
    public PipelineRunSpecFluent.ServiceAccountsNested<A> addNewServiceAccount();
    public PipelineRunSpecFluent.ServiceAccountsNested<A> addNewServiceAccountLike(PipelineRunSpecServiceAccount item);
    public PipelineRunSpecFluent.ServiceAccountsNested<A> setNewServiceAccountLike(int index,PipelineRunSpecServiceAccount item);
    public PipelineRunSpecFluent.ServiceAccountsNested<A> editServiceAccount(int index);
    public PipelineRunSpecFluent.ServiceAccountsNested<A> editFirstServiceAccount();
    public PipelineRunSpecFluent.ServiceAccountsNested<A> editLastServiceAccount();
    public PipelineRunSpecFluent.ServiceAccountsNested<A> editMatchingServiceAccount(io.fabric8.kubernetes.api.builder.Predicate<PipelineRunSpecServiceAccountBuilder> predicate);
    public String getStatus();
    public A withStatus(String status);
    public Boolean hasStatus();
    public A withNewStatus(String arg1);
    public A withNewStatus(StringBuilder arg1);
    public A withNewStatus(StringBuffer arg1);
    public String getTimeout();
    public A withTimeout(String timeout);
    public Boolean hasTimeout();
    public A withNewTimeout(String arg1);
    public A withNewTimeout(StringBuilder arg1);
    public A withNewTimeout(StringBuffer arg1);
    public A addToTolerations(int index,Toleration item);
    public A setToTolerations(int index,Toleration item);
    public A addToTolerations(Toleration... items);
    public A addAllToTolerations(Collection<Toleration> items);
    public A removeFromTolerations(Toleration... items);
    public A removeAllFromTolerations(Collection<Toleration> items);
    public List<Toleration> getTolerations();
    public Toleration getToleration(int index);
    public Toleration getFirstToleration();
    public Toleration getLastToleration();
    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate);
    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate);
    public A withTolerations(List<Toleration> tolerations);
    public A withTolerations(Toleration... tolerations);
    public Boolean hasTolerations();
    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);

    public interface ParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ParamFluent<PipelineRunSpecFluent.ParamsNested<N>>{

        
    public N and();    public N endParam();
}
    public interface PipelineRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineRefFluent<PipelineRunSpecFluent.PipelineRefNested<N>>{

        
    public N and();    public N endPipelineRef();
}
    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineResourceBindingFluent<PipelineRunSpecFluent.ResourcesNested<N>>{

        
    public N and();    public N endResource();
}
    public interface ResultsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResultsFluent<PipelineRunSpecFluent.ResultsNested<N>>{

        
    public N and();    public N endResults();
}
    public interface ServiceAccountsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineRunSpecServiceAccountFluent<PipelineRunSpecFluent.ServiceAccountsNested<N>>{

        
    public N and();    public N endServiceAccount();
}


}
