package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineRunSpecServiceAccountBuilder extends PipelineRunSpecServiceAccountFluentImpl<PipelineRunSpecServiceAccountBuilder> implements VisitableBuilder<PipelineRunSpecServiceAccount,PipelineRunSpecServiceAccountBuilder>{

    PipelineRunSpecServiceAccountFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineRunSpecServiceAccountBuilder(){
            this(true);
    }
    public PipelineRunSpecServiceAccountBuilder(Boolean validationEnabled){
            this(new PipelineRunSpecServiceAccount(), validationEnabled);
    }
    public PipelineRunSpecServiceAccountBuilder(PipelineRunSpecServiceAccountFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineRunSpecServiceAccountBuilder(PipelineRunSpecServiceAccountFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineRunSpecServiceAccount(), validationEnabled);
    }
    public PipelineRunSpecServiceAccountBuilder(PipelineRunSpecServiceAccountFluent<?> fluent,PipelineRunSpecServiceAccount instance){
            this(fluent, instance, true);
    }
    public PipelineRunSpecServiceAccountBuilder(PipelineRunSpecServiceAccountFluent<?> fluent,PipelineRunSpecServiceAccount instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withServiceAccount(instance.getServiceAccount()); 
            fluent.withTaskName(instance.getTaskName()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineRunSpecServiceAccountBuilder(PipelineRunSpecServiceAccount instance){
            this(instance,true);
    }
    public PipelineRunSpecServiceAccountBuilder(PipelineRunSpecServiceAccount instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withTaskName(instance.getTaskName()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineRunSpecServiceAccountBuilder(Validator validator){
            this(new PipelineRunSpecServiceAccount(), true);
    }
    public PipelineRunSpecServiceAccountBuilder(PipelineRunSpecServiceAccountFluent<?> fluent,PipelineRunSpecServiceAccount instance,Validator validator){
            this.fluent = fluent; 
            fluent.withServiceAccount(instance.getServiceAccount()); 
            fluent.withTaskName(instance.getTaskName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineRunSpecServiceAccountBuilder(PipelineRunSpecServiceAccount instance,Validator validator){
            this.fluent = this; 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withTaskName(instance.getTaskName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineRunSpecServiceAccount build(){
            PipelineRunSpecServiceAccount buildable = new PipelineRunSpecServiceAccount(fluent.getServiceAccount(),fluent.getTaskName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineRunSpecServiceAccountBuilder that = (PipelineRunSpecServiceAccountBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
