package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class PipelineRunTaskRunStatusFluentImpl<A extends PipelineRunTaskRunStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PipelineRunTaskRunStatusFluent<A>{

    private String pipelineTaskName;
    private TaskRunStatusBuilder status;

    public PipelineRunTaskRunStatusFluentImpl(){
    }
    public PipelineRunTaskRunStatusFluentImpl(PipelineRunTaskRunStatus instance){
            this.withPipelineTaskName(instance.getPipelineTaskName()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getPipelineTaskName(){
            return this.pipelineTaskName;
    }

    public A withPipelineTaskName(String pipelineTaskName){
            this.pipelineTaskName=pipelineTaskName; return (A) this;
    }

    public Boolean hasPipelineTaskName(){
            return this.pipelineTaskName != null;
    }

    public A withNewPipelineTaskName(String arg1){
            return (A)withPipelineTaskName(new String(arg1));
    }

    public A withNewPipelineTaskName(StringBuilder arg1){
            return (A)withPipelineTaskName(new String(arg1));
    }

    public A withNewPipelineTaskName(StringBuffer arg1){
            return (A)withPipelineTaskName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public TaskRunStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public TaskRunStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(TaskRunStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new TaskRunStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public PipelineRunTaskRunStatusFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public PipelineRunTaskRunStatusFluent.StatusNested<A> withNewStatusLike(TaskRunStatus item){
            return new StatusNestedImpl(item);
    }

    public PipelineRunTaskRunStatusFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public PipelineRunTaskRunStatusFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new TaskRunStatusBuilder().build());
    }

    public PipelineRunTaskRunStatusFluent.StatusNested<A> editOrNewStatusLike(TaskRunStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineRunTaskRunStatusFluentImpl that = (PipelineRunTaskRunStatusFluentImpl) o;
            if (pipelineTaskName != null ? !pipelineTaskName.equals(that.pipelineTaskName) :that.pipelineTaskName != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class StatusNestedImpl<N> extends TaskRunStatusFluentImpl<PipelineRunTaskRunStatusFluent.StatusNested<N>> implements PipelineRunTaskRunStatusFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TaskRunStatusBuilder builder;
    
            StatusNestedImpl(TaskRunStatus item){
                    this.builder = new TaskRunStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new TaskRunStatusBuilder(this);
            }
    
    public N and(){
            return (N) PipelineRunTaskRunStatusFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
