package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineSpecBuilder extends PipelineSpecFluentImpl<PipelineSpecBuilder> implements VisitableBuilder<PipelineSpec,PipelineSpecBuilder>{

    PipelineSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineSpecBuilder(){
            this(true);
    }
    public PipelineSpecBuilder(Boolean validationEnabled){
            this(new PipelineSpec(), validationEnabled);
    }
    public PipelineSpecBuilder(PipelineSpecFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineSpecBuilder(PipelineSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineSpec(), validationEnabled);
    }
    public PipelineSpecBuilder(PipelineSpecFluent<?> fluent,PipelineSpec instance){
            this(fluent, instance, true);
    }
    public PipelineSpecBuilder(PipelineSpecFluent<?> fluent,PipelineSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withParams(instance.getParams()); 
            fluent.withResources(instance.getResources()); 
            fluent.withTasks(instance.getTasks()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineSpecBuilder(PipelineSpec instance){
            this(instance,true);
    }
    public PipelineSpecBuilder(PipelineSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withParams(instance.getParams()); 
            this.withResources(instance.getResources()); 
            this.withTasks(instance.getTasks()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineSpecBuilder(Validator validator){
            this(new PipelineSpec(), true);
    }
    public PipelineSpecBuilder(PipelineSpecFluent<?> fluent,PipelineSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withParams(instance.getParams()); 
            fluent.withResources(instance.getResources()); 
            fluent.withTasks(instance.getTasks()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineSpecBuilder(PipelineSpec instance,Validator validator){
            this.fluent = this; 
            this.withParams(instance.getParams()); 
            this.withResources(instance.getResources()); 
            this.withTasks(instance.getTasks()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineSpec build(){
            PipelineSpec buildable = new PipelineSpec(fluent.getParams(),fluent.getResources(),fluent.getTasks());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineSpecBuilder that = (PipelineSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
