package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PipelineSpecFluent<A extends PipelineSpecFluent<A>> extends Fluent<A>{


    public A addToParams(int index,ParamSpec item);
    public A setToParams(int index,ParamSpec item);
    public A addToParams(ParamSpec... items);
    public A addAllToParams(Collection<ParamSpec> items);
    public A removeFromParams(ParamSpec... items);
    public A removeAllFromParams(Collection<ParamSpec> items);
    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public List<ParamSpec> getParams();
    public List<ParamSpec> buildParams();
    public ParamSpec buildParam(int index);
    public ParamSpec buildFirstParam();
    public ParamSpec buildLastParam();
    public ParamSpec buildMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamSpecBuilder> predicate);
    public Boolean hasMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamSpecBuilder> predicate);
    public A withParams(List<ParamSpec> params);
    public A withParams(ParamSpec... params);
    public Boolean hasParams();
    public A addNewParam(String _default,String description,String name);
    public PipelineSpecFluent.ParamsNested<A> addNewParam();
    public PipelineSpecFluent.ParamsNested<A> addNewParamLike(ParamSpec item);
    public PipelineSpecFluent.ParamsNested<A> setNewParamLike(int index,ParamSpec item);
    public PipelineSpecFluent.ParamsNested<A> editParam(int index);
    public PipelineSpecFluent.ParamsNested<A> editFirstParam();
    public PipelineSpecFluent.ParamsNested<A> editLastParam();
    public PipelineSpecFluent.ParamsNested<A> editMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamSpecBuilder> predicate);
    public A addToResources(int index,PipelineDeclaredResource item);
    public A setToResources(int index,PipelineDeclaredResource item);
    public A addToResources(PipelineDeclaredResource... items);
    public A addAllToResources(Collection<PipelineDeclaredResource> items);
    public A removeFromResources(PipelineDeclaredResource... items);
    public A removeAllFromResources(Collection<PipelineDeclaredResource> items);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineDeclaredResource> getResources();
    public List<PipelineDeclaredResource> buildResources();
    public PipelineDeclaredResource buildResource(int index);
    public PipelineDeclaredResource buildFirstResource();
    public PipelineDeclaredResource buildLastResource();
    public PipelineDeclaredResource buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineDeclaredResourceBuilder> predicate);
    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineDeclaredResourceBuilder> predicate);
    public A withResources(List<PipelineDeclaredResource> resources);
    public A withResources(PipelineDeclaredResource... resources);
    public Boolean hasResources();
    public A addNewResource(String name,String type);
    public PipelineSpecFluent.ResourcesNested<A> addNewResource();
    public PipelineSpecFluent.ResourcesNested<A> addNewResourceLike(PipelineDeclaredResource item);
    public PipelineSpecFluent.ResourcesNested<A> setNewResourceLike(int index,PipelineDeclaredResource item);
    public PipelineSpecFluent.ResourcesNested<A> editResource(int index);
    public PipelineSpecFluent.ResourcesNested<A> editFirstResource();
    public PipelineSpecFluent.ResourcesNested<A> editLastResource();
    public PipelineSpecFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineDeclaredResourceBuilder> predicate);
    public A addToTasks(int index,PipelineTask item);
    public A setToTasks(int index,PipelineTask item);
    public A addToTasks(PipelineTask... items);
    public A addAllToTasks(Collection<PipelineTask> items);
    public A removeFromTasks(PipelineTask... items);
    public A removeAllFromTasks(Collection<PipelineTask> items);
    
/**
 * This method has been deprecated, please use method buildTasks instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineTask> getTasks();
    public List<PipelineTask> buildTasks();
    public PipelineTask buildTask(int index);
    public PipelineTask buildFirstTask();
    public PipelineTask buildLastTask();
    public PipelineTask buildMatchingTask(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskBuilder> predicate);
    public Boolean hasMatchingTask(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskBuilder> predicate);
    public A withTasks(List<PipelineTask> tasks);
    public A withTasks(PipelineTask... tasks);
    public Boolean hasTasks();
    public PipelineSpecFluent.TasksNested<A> addNewTask();
    public PipelineSpecFluent.TasksNested<A> addNewTaskLike(PipelineTask item);
    public PipelineSpecFluent.TasksNested<A> setNewTaskLike(int index,PipelineTask item);
    public PipelineSpecFluent.TasksNested<A> editTask(int index);
    public PipelineSpecFluent.TasksNested<A> editFirstTask();
    public PipelineSpecFluent.TasksNested<A> editLastTask();
    public PipelineSpecFluent.TasksNested<A> editMatchingTask(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskBuilder> predicate);

    public interface ParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ParamSpecFluent<PipelineSpecFluent.ParamsNested<N>>{

        
    public N and();    public N endParam();
}
    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineDeclaredResourceFluent<PipelineSpecFluent.ResourcesNested<N>>{

        
    public N and();    public N endResource();
}
    public interface TasksNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineTaskFluent<PipelineSpecFluent.TasksNested<N>>{

        
    public N and();    public N endTask();
}


}
