package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PipelineTaskInputResourceFluent<A extends PipelineTaskInputResourceFluent<A>> extends Fluent<A>{


    public A addToFrom(int index,String item);
    public A setToFrom(int index,String item);
    public A addToFrom(String... items);
    public A addAllToFrom(Collection<String> items);
    public A removeFromFrom(String... items);
    public A removeAllFromFrom(Collection<String> items);
    public List<String> getFrom();
    public String getFrom(int index);
    public String getFirstFrom();
    public String getLastFrom();
    public String getMatchingFrom(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingFrom(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withFrom(List<String> from);
    public A withFrom(String... from);
    public Boolean hasFrom();
    public A addNewFrom(String arg1);
    public A addNewFrom(StringBuilder arg1);
    public A addNewFrom(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getResource();
    public A withResource(String resource);
    public Boolean hasResource();
    public A withNewResource(String arg1);
    public A withNewResource(StringBuilder arg1);
    public A withNewResource(StringBuffer arg1);



}
