package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PipelineTaskResourcesFluent<A extends PipelineTaskResourcesFluent<A>> extends Fluent<A>{


    public A addToInputs(int index,PipelineTaskInputResource item);
    public A setToInputs(int index,PipelineTaskInputResource item);
    public A addToInputs(PipelineTaskInputResource... items);
    public A addAllToInputs(Collection<PipelineTaskInputResource> items);
    public A removeFromInputs(PipelineTaskInputResource... items);
    public A removeAllFromInputs(Collection<PipelineTaskInputResource> items);
    
/**
 * This method has been deprecated, please use method buildInputs instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineTaskInputResource> getInputs();
    public List<PipelineTaskInputResource> buildInputs();
    public PipelineTaskInputResource buildInput(int index);
    public PipelineTaskInputResource buildFirstInput();
    public PipelineTaskInputResource buildLastInput();
    public PipelineTaskInputResource buildMatchingInput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskInputResourceBuilder> predicate);
    public Boolean hasMatchingInput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskInputResourceBuilder> predicate);
    public A withInputs(List<PipelineTaskInputResource> inputs);
    public A withInputs(PipelineTaskInputResource... inputs);
    public Boolean hasInputs();
    public PipelineTaskResourcesFluent.InputsNested<A> addNewInput();
    public PipelineTaskResourcesFluent.InputsNested<A> addNewInputLike(PipelineTaskInputResource item);
    public PipelineTaskResourcesFluent.InputsNested<A> setNewInputLike(int index,PipelineTaskInputResource item);
    public PipelineTaskResourcesFluent.InputsNested<A> editInput(int index);
    public PipelineTaskResourcesFluent.InputsNested<A> editFirstInput();
    public PipelineTaskResourcesFluent.InputsNested<A> editLastInput();
    public PipelineTaskResourcesFluent.InputsNested<A> editMatchingInput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskInputResourceBuilder> predicate);
    public A addToOutputs(int index,PipelineTaskOutputResource item);
    public A setToOutputs(int index,PipelineTaskOutputResource item);
    public A addToOutputs(PipelineTaskOutputResource... items);
    public A addAllToOutputs(Collection<PipelineTaskOutputResource> items);
    public A removeFromOutputs(PipelineTaskOutputResource... items);
    public A removeAllFromOutputs(Collection<PipelineTaskOutputResource> items);
    
/**
 * This method has been deprecated, please use method buildOutputs instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineTaskOutputResource> getOutputs();
    public List<PipelineTaskOutputResource> buildOutputs();
    public PipelineTaskOutputResource buildOutput(int index);
    public PipelineTaskOutputResource buildFirstOutput();
    public PipelineTaskOutputResource buildLastOutput();
    public PipelineTaskOutputResource buildMatchingOutput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskOutputResourceBuilder> predicate);
    public Boolean hasMatchingOutput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskOutputResourceBuilder> predicate);
    public A withOutputs(List<PipelineTaskOutputResource> outputs);
    public A withOutputs(PipelineTaskOutputResource... outputs);
    public Boolean hasOutputs();
    public A addNewOutput(String name,String resource);
    public PipelineTaskResourcesFluent.OutputsNested<A> addNewOutput();
    public PipelineTaskResourcesFluent.OutputsNested<A> addNewOutputLike(PipelineTaskOutputResource item);
    public PipelineTaskResourcesFluent.OutputsNested<A> setNewOutputLike(int index,PipelineTaskOutputResource item);
    public PipelineTaskResourcesFluent.OutputsNested<A> editOutput(int index);
    public PipelineTaskResourcesFluent.OutputsNested<A> editFirstOutput();
    public PipelineTaskResourcesFluent.OutputsNested<A> editLastOutput();
    public PipelineTaskResourcesFluent.OutputsNested<A> editMatchingOutput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskOutputResourceBuilder> predicate);

    public interface InputsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineTaskInputResourceFluent<PipelineTaskResourcesFluent.InputsNested<N>>{

        
    public N and();    public N endInput();
}
    public interface OutputsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineTaskOutputResourceFluent<PipelineTaskResourcesFluent.OutputsNested<N>>{

        
    public N and();    public N endOutput();
}


}
