package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class StepStateBuilder extends StepStateFluentImpl<StepStateBuilder> implements VisitableBuilder<StepState,StepStateBuilder>{

    StepStateFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StepStateBuilder(){
            this(true);
    }
    public StepStateBuilder(Boolean validationEnabled){
            this(new StepState(), validationEnabled);
    }
    public StepStateBuilder(StepStateFluent<?> fluent){
            this(fluent, true);
    }
    public StepStateBuilder(StepStateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StepState(), validationEnabled);
    }
    public StepStateBuilder(StepStateFluent<?> fluent,StepState instance){
            this(fluent, instance, true);
    }
    public StepStateBuilder(StepStateFluent<?> fluent,StepState instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContainerState(instance.getContainerState()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public StepStateBuilder(StepState instance){
            this(instance,true);
    }
    public StepStateBuilder(StepState instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContainerState(instance.getContainerState()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public StepStateBuilder(Validator validator){
            this(new StepState(), true);
    }
    public StepStateBuilder(StepStateFluent<?> fluent,StepState instance,Validator validator){
            this.fluent = fluent; 
            fluent.withContainerState(instance.getContainerState()); 
            fluent.withName(instance.getName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public StepStateBuilder(StepState instance,Validator validator){
            this.fluent = this; 
            this.withContainerState(instance.getContainerState()); 
            this.withName(instance.getName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public StepState build(){
            StepState buildable = new StepState(fluent.getContainerState(),fluent.getName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StepStateBuilder that = (StepStateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
