package io.fabric8.tekton.pipeline.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ContainerState;

public class StepStateFluentImpl<A extends StepStateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StepStateFluent<A>{

    private ContainerState containerState;
    private String name;

    public StepStateFluentImpl(){
    }
    public StepStateFluentImpl(StepState instance){
            this.withContainerState(instance.getContainerState()); 
            this.withName(instance.getName()); 
    }

    public ContainerState getContainerState(){
            return this.containerState;
    }

    public A withContainerState(ContainerState containerState){
            this.containerState=containerState; return (A) this;
    }

    public Boolean hasContainerState(){
            return this.containerState != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StepStateFluentImpl that = (StepStateFluentImpl) o;
            if (containerState != null ? !containerState.equals(that.containerState) :that.containerState != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            return true;
    }




}
