package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskBuilder extends TaskFluentImpl<TaskBuilder> implements VisitableBuilder<Task,TaskBuilder>{

    TaskFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskBuilder(){
            this(true);
    }
    public TaskBuilder(Boolean validationEnabled){
            this(new Task(), validationEnabled);
    }
    public TaskBuilder(TaskFluent<?> fluent){
            this(fluent, true);
    }
    public TaskBuilder(TaskFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Task(), validationEnabled);
    }
    public TaskBuilder(TaskFluent<?> fluent,Task instance){
            this(fluent, instance, true);
    }
    public TaskBuilder(TaskFluent<?> fluent,Task instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskBuilder(Task instance){
            this(instance,true);
    }
    public TaskBuilder(Task instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskBuilder(Validator validator){
            this(new Task(), true);
    }
    public TaskBuilder(TaskFluent<?> fluent,Task instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskBuilder(Task instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Task build(){
            Task buildable = new Task(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskBuilder that = (TaskBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
