
package io.fabric8.tekton.pipeline.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "name",
    "paths",
    "resourceRef",
    "resourceSpec"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TaskResourceBinding implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("name")
    private String name;
    /**
     * 
     * 
     */
    @JsonProperty("paths")
    @Valid
    private List<String> paths = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("resourceRef")
    @Valid
    private PipelineResourceRef resourceRef;
    /**
     * 
     * 
     */
    @JsonProperty("resourceSpec")
    @Valid
    private PipelineResourceSpec resourceSpec;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TaskResourceBinding() {
    }

    /**
     * 
     * @param resourceRef
     * @param paths
     * @param name
     * @param resourceSpec
     */
    public TaskResourceBinding(String name, List<String> paths, PipelineResourceRef resourceRef, PipelineResourceSpec resourceSpec) {
        this.name = name;
        this.paths = paths;
        this.resourceRef = resourceRef;
        this.resourceSpec = resourceSpec;
    }

    /**
     * 
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * 
     * @return
     *     The paths
     */
    @JsonProperty("paths")
    public List<String> getPaths() {
        return paths;
    }

    /**
     * 
     * 
     * @param paths
     *     The paths
     */
    @JsonProperty("paths")
    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    /**
     * 
     * 
     * @return
     *     The resourceRef
     */
    @JsonProperty("resourceRef")
    public PipelineResourceRef getResourceRef() {
        return resourceRef;
    }

    /**
     * 
     * 
     * @param resourceRef
     *     The resourceRef
     */
    @JsonProperty("resourceRef")
    public void setResourceRef(PipelineResourceRef resourceRef) {
        this.resourceRef = resourceRef;
    }

    /**
     * 
     * 
     * @return
     *     The resourceSpec
     */
    @JsonProperty("resourceSpec")
    public PipelineResourceSpec getResourceSpec() {
        return resourceSpec;
    }

    /**
     * 
     * 
     * @param resourceSpec
     *     The resourceSpec
     */
    @JsonProperty("resourceSpec")
    public void setResourceSpec(PipelineResourceSpec resourceSpec) {
        this.resourceSpec = resourceSpec;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
