package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskResourceBindingBuilder extends TaskResourceBindingFluentImpl<TaskResourceBindingBuilder> implements VisitableBuilder<TaskResourceBinding,TaskResourceBindingBuilder>{

    TaskResourceBindingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskResourceBindingBuilder(){
            this(true);
    }
    public TaskResourceBindingBuilder(Boolean validationEnabled){
            this(new TaskResourceBinding(), validationEnabled);
    }
    public TaskResourceBindingBuilder(TaskResourceBindingFluent<?> fluent){
            this(fluent, true);
    }
    public TaskResourceBindingBuilder(TaskResourceBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TaskResourceBinding(), validationEnabled);
    }
    public TaskResourceBindingBuilder(TaskResourceBindingFluent<?> fluent,TaskResourceBinding instance){
            this(fluent, instance, true);
    }
    public TaskResourceBindingBuilder(TaskResourceBindingFluent<?> fluent,TaskResourceBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withPaths(instance.getPaths()); 
            fluent.withResourceRef(instance.getResourceRef()); 
            fluent.withResourceSpec(instance.getResourceSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskResourceBindingBuilder(TaskResourceBinding instance){
            this(instance,true);
    }
    public TaskResourceBindingBuilder(TaskResourceBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withPaths(instance.getPaths()); 
            this.withResourceRef(instance.getResourceRef()); 
            this.withResourceSpec(instance.getResourceSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskResourceBindingBuilder(Validator validator){
            this(new TaskResourceBinding(), true);
    }
    public TaskResourceBindingBuilder(TaskResourceBindingFluent<?> fluent,TaskResourceBinding instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withPaths(instance.getPaths()); 
            fluent.withResourceRef(instance.getResourceRef()); 
            fluent.withResourceSpec(instance.getResourceSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskResourceBindingBuilder(TaskResourceBinding instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withPaths(instance.getPaths()); 
            this.withResourceRef(instance.getResourceRef()); 
            this.withResourceSpec(instance.getResourceSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TaskResourceBinding build(){
            TaskResourceBinding buildable = new TaskResourceBinding(fluent.getName(),fluent.getPaths(),fluent.getResourceRef(),fluent.getResourceSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskResourceBindingBuilder that = (TaskResourceBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
