package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class TaskResourceBindingFluentImpl<A extends TaskResourceBindingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TaskResourceBindingFluent<A>{

    private String name;
    private List<String> paths;
    private PipelineResourceRefBuilder resourceRef;
    private PipelineResourceSpecBuilder resourceSpec;

    public TaskResourceBindingFluentImpl(){
    }
    public TaskResourceBindingFluentImpl(TaskResourceBinding instance){
            this.withName(instance.getName()); 
            this.withPaths(instance.getPaths()); 
            this.withResourceRef(instance.getResourceRef()); 
            this.withResourceSpec(instance.getResourceSpec()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public A addToPaths(int index,String item){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            this.paths.add(index, item);
            return (A)this;
    }

    public A setToPaths(int index,String item){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            this.paths.set(index, item); return (A)this;
    }

    public A addToPaths(String... items){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            for (String item : items) {this.paths.add(item);} return (A)this;
    }

    public A addAllToPaths(Collection<String> items){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            for (String item : items) {this.paths.add(item);} return (A)this;
    }

    public A removeFromPaths(String... items){
            for (String item : items) {if (this.paths!= null){ this.paths.remove(item);}} return (A)this;
    }

    public A removeAllFromPaths(Collection<String> items){
            for (String item : items) {if (this.paths!= null){ this.paths.remove(item);}} return (A)this;
    }

    public List<String> getPaths(){
            return this.paths;
    }

    public String getPath(int index){
            return this.paths.get(index);
    }

    public String getFirstPath(){
            return this.paths.get(0);
    }

    public String getLastPath(){
            return this.paths.get(paths.size() - 1);
    }

    public String getMatchingPath(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: paths) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingPath(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: paths) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withPaths(List<String> paths){
            if (this.paths != null) { _visitables.get("paths").removeAll(this.paths);}
            if (paths != null) {this.paths = new ArrayList<String>(); for (String item : paths){this.addToPaths(item);}} else { this.paths = new ArrayList<String>();} return (A) this;
    }

    public A withPaths(String... paths){
            if (this.paths != null) {this.paths.clear();}
            if (paths != null) {for (String item :paths){ this.addToPaths(item);}} return (A) this;
    }

    public Boolean hasPaths(){
            return paths != null && !paths.isEmpty();
    }

    public A addNewPath(String arg1){
            return (A)addToPaths(new String(arg1));
    }

    public A addNewPath(StringBuilder arg1){
            return (A)addToPaths(new String(arg1));
    }

    public A addNewPath(StringBuffer arg1){
            return (A)addToPaths(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildResourceRef instead.
 * @return The buildable object.
 */
@Deprecated public PipelineResourceRef getResourceRef(){
            return this.resourceRef!=null?this.resourceRef.build():null;
    }

    public PipelineResourceRef buildResourceRef(){
            return this.resourceRef!=null?this.resourceRef.build():null;
    }

    public A withResourceRef(PipelineResourceRef resourceRef){
            _visitables.get("resourceRef").remove(this.resourceRef);
            if (resourceRef!=null){ this.resourceRef= new PipelineResourceRefBuilder(resourceRef); _visitables.get("resourceRef").add(this.resourceRef);} return (A) this;
    }

    public Boolean hasResourceRef(){
            return this.resourceRef != null;
    }

    public A withNewResourceRef(String apiVersion,String name){
            return (A)withResourceRef(new PipelineResourceRef(apiVersion, name));
    }

    public TaskResourceBindingFluent.ResourceRefNested<A> withNewResourceRef(){
            return new ResourceRefNestedImpl();
    }

    public TaskResourceBindingFluent.ResourceRefNested<A> withNewResourceRefLike(PipelineResourceRef item){
            return new ResourceRefNestedImpl(item);
    }

    public TaskResourceBindingFluent.ResourceRefNested<A> editResourceRef(){
            return withNewResourceRefLike(getResourceRef());
    }

    public TaskResourceBindingFluent.ResourceRefNested<A> editOrNewResourceRef(){
            return withNewResourceRefLike(getResourceRef() != null ? getResourceRef(): new PipelineResourceRefBuilder().build());
    }

    public TaskResourceBindingFluent.ResourceRefNested<A> editOrNewResourceRefLike(PipelineResourceRef item){
            return withNewResourceRefLike(getResourceRef() != null ? getResourceRef(): item);
    }

    
/**
 * This method has been deprecated, please use method buildResourceSpec instead.
 * @return The buildable object.
 */
@Deprecated public PipelineResourceSpec getResourceSpec(){
            return this.resourceSpec!=null?this.resourceSpec.build():null;
    }

    public PipelineResourceSpec buildResourceSpec(){
            return this.resourceSpec!=null?this.resourceSpec.build():null;
    }

    public A withResourceSpec(PipelineResourceSpec resourceSpec){
            _visitables.get("resourceSpec").remove(this.resourceSpec);
            if (resourceSpec!=null){ this.resourceSpec= new PipelineResourceSpecBuilder(resourceSpec); _visitables.get("resourceSpec").add(this.resourceSpec);} return (A) this;
    }

    public Boolean hasResourceSpec(){
            return this.resourceSpec != null;
    }

    public TaskResourceBindingFluent.ResourceSpecNested<A> withNewResourceSpec(){
            return new ResourceSpecNestedImpl();
    }

    public TaskResourceBindingFluent.ResourceSpecNested<A> withNewResourceSpecLike(PipelineResourceSpec item){
            return new ResourceSpecNestedImpl(item);
    }

    public TaskResourceBindingFluent.ResourceSpecNested<A> editResourceSpec(){
            return withNewResourceSpecLike(getResourceSpec());
    }

    public TaskResourceBindingFluent.ResourceSpecNested<A> editOrNewResourceSpec(){
            return withNewResourceSpecLike(getResourceSpec() != null ? getResourceSpec(): new PipelineResourceSpecBuilder().build());
    }

    public TaskResourceBindingFluent.ResourceSpecNested<A> editOrNewResourceSpecLike(PipelineResourceSpec item){
            return withNewResourceSpecLike(getResourceSpec() != null ? getResourceSpec(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskResourceBindingFluentImpl that = (TaskResourceBindingFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
            if (resourceRef != null ? !resourceRef.equals(that.resourceRef) :that.resourceRef != null) return false;
            if (resourceSpec != null ? !resourceSpec.equals(that.resourceSpec) :that.resourceSpec != null) return false;
            return true;
    }


    public class ResourceRefNestedImpl<N> extends PipelineResourceRefFluentImpl<TaskResourceBindingFluent.ResourceRefNested<N>> implements TaskResourceBindingFluent.ResourceRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineResourceRefBuilder builder;
    
            ResourceRefNestedImpl(PipelineResourceRef item){
                    this.builder = new PipelineResourceRefBuilder(this, item);
            }
            ResourceRefNestedImpl(){
                    this.builder = new PipelineResourceRefBuilder(this);
            }
    
    public N and(){
            return (N) TaskResourceBindingFluentImpl.this.withResourceRef(builder.build());
    }
    public N endResourceRef(){
            return and();
    }

}
    public class ResourceSpecNestedImpl<N> extends PipelineResourceSpecFluentImpl<TaskResourceBindingFluent.ResourceSpecNested<N>> implements TaskResourceBindingFluent.ResourceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineResourceSpecBuilder builder;
    
            ResourceSpecNestedImpl(PipelineResourceSpec item){
                    this.builder = new PipelineResourceSpecBuilder(this, item);
            }
            ResourceSpecNestedImpl(){
                    this.builder = new PipelineResourceSpecBuilder(this);
            }
    
    public N and(){
            return (N) TaskResourceBindingFluentImpl.this.withResourceSpec(builder.build());
    }
    public N endResourceSpec(){
            return and();
    }

}


}
