package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskRunBuilder extends TaskRunFluentImpl<TaskRunBuilder> implements VisitableBuilder<TaskRun,TaskRunBuilder>{

    TaskRunFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskRunBuilder(){
            this(true);
    }
    public TaskRunBuilder(Boolean validationEnabled){
            this(new TaskRun(), validationEnabled);
    }
    public TaskRunBuilder(TaskRunFluent<?> fluent){
            this(fluent, true);
    }
    public TaskRunBuilder(TaskRunFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TaskRun(), validationEnabled);
    }
    public TaskRunBuilder(TaskRunFluent<?> fluent,TaskRun instance){
            this(fluent, instance, true);
    }
    public TaskRunBuilder(TaskRunFluent<?> fluent,TaskRun instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunBuilder(TaskRun instance){
            this(instance,true);
    }
    public TaskRunBuilder(TaskRun instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunBuilder(Validator validator){
            this(new TaskRun(), true);
    }
    public TaskRunBuilder(TaskRunFluent<?> fluent,TaskRun instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskRunBuilder(TaskRun instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TaskRun build(){
            TaskRun buildable = new TaskRun(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskRunBuilder that = (TaskRunBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
