package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskRunInputsBuilder extends TaskRunInputsFluentImpl<TaskRunInputsBuilder> implements VisitableBuilder<TaskRunInputs,TaskRunInputsBuilder>{

    TaskRunInputsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskRunInputsBuilder(){
            this(true);
    }
    public TaskRunInputsBuilder(Boolean validationEnabled){
            this(new TaskRunInputs(), validationEnabled);
    }
    public TaskRunInputsBuilder(TaskRunInputsFluent<?> fluent){
            this(fluent, true);
    }
    public TaskRunInputsBuilder(TaskRunInputsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TaskRunInputs(), validationEnabled);
    }
    public TaskRunInputsBuilder(TaskRunInputsFluent<?> fluent,TaskRunInputs instance){
            this(fluent, instance, true);
    }
    public TaskRunInputsBuilder(TaskRunInputsFluent<?> fluent,TaskRunInputs instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withParams(instance.getParams()); 
            fluent.withResources(instance.getResources()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunInputsBuilder(TaskRunInputs instance){
            this(instance,true);
    }
    public TaskRunInputsBuilder(TaskRunInputs instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withParams(instance.getParams()); 
            this.withResources(instance.getResources()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunInputsBuilder(Validator validator){
            this(new TaskRunInputs(), true);
    }
    public TaskRunInputsBuilder(TaskRunInputsFluent<?> fluent,TaskRunInputs instance,Validator validator){
            this.fluent = fluent; 
            fluent.withParams(instance.getParams()); 
            fluent.withResources(instance.getResources()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskRunInputsBuilder(TaskRunInputs instance,Validator validator){
            this.fluent = this; 
            this.withParams(instance.getParams()); 
            this.withResources(instance.getResources()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TaskRunInputs build(){
            TaskRunInputs buildable = new TaskRunInputs(fluent.getParams(),fluent.getResources());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskRunInputsBuilder that = (TaskRunInputsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
