package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskRunListBuilder extends TaskRunListFluentImpl<TaskRunListBuilder> implements VisitableBuilder<TaskRunList,TaskRunListBuilder>{

    TaskRunListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskRunListBuilder(){
            this(true);
    }
    public TaskRunListBuilder(Boolean validationEnabled){
            this(new TaskRunList(), validationEnabled);
    }
    public TaskRunListBuilder(TaskRunListFluent<?> fluent){
            this(fluent, true);
    }
    public TaskRunListBuilder(TaskRunListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TaskRunList(), validationEnabled);
    }
    public TaskRunListBuilder(TaskRunListFluent<?> fluent,TaskRunList instance){
            this(fluent, instance, true);
    }
    public TaskRunListBuilder(TaskRunListFluent<?> fluent,TaskRunList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunListBuilder(TaskRunList instance){
            this(instance,true);
    }
    public TaskRunListBuilder(TaskRunList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunListBuilder(Validator validator){
            this(new TaskRunList(), true);
    }
    public TaskRunListBuilder(TaskRunListFluent<?> fluent,TaskRunList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskRunListBuilder(TaskRunList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TaskRunList build(){
            TaskRunList buildable = new TaskRunList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskRunListBuilder that = (TaskRunListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
