package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskRunOutputsBuilder extends TaskRunOutputsFluentImpl<TaskRunOutputsBuilder> implements VisitableBuilder<TaskRunOutputs,TaskRunOutputsBuilder>{

    TaskRunOutputsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskRunOutputsBuilder(){
            this(true);
    }
    public TaskRunOutputsBuilder(Boolean validationEnabled){
            this(new TaskRunOutputs(), validationEnabled);
    }
    public TaskRunOutputsBuilder(TaskRunOutputsFluent<?> fluent){
            this(fluent, true);
    }
    public TaskRunOutputsBuilder(TaskRunOutputsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TaskRunOutputs(), validationEnabled);
    }
    public TaskRunOutputsBuilder(TaskRunOutputsFluent<?> fluent,TaskRunOutputs instance){
            this(fluent, instance, true);
    }
    public TaskRunOutputsBuilder(TaskRunOutputsFluent<?> fluent,TaskRunOutputs instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withResources(instance.getResources()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunOutputsBuilder(TaskRunOutputs instance){
            this(instance,true);
    }
    public TaskRunOutputsBuilder(TaskRunOutputs instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withResources(instance.getResources()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunOutputsBuilder(Validator validator){
            this(new TaskRunOutputs(), true);
    }
    public TaskRunOutputsBuilder(TaskRunOutputsFluent<?> fluent,TaskRunOutputs instance,Validator validator){
            this.fluent = fluent; 
            fluent.withResources(instance.getResources()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskRunOutputsBuilder(TaskRunOutputs instance,Validator validator){
            this.fluent = this; 
            this.withResources(instance.getResources()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TaskRunOutputs build(){
            TaskRunOutputs buildable = new TaskRunOutputs(fluent.getResources());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskRunOutputsBuilder that = (TaskRunOutputsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
