package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface TaskRunSpecFluent<A extends TaskRunSpecFluent<A>> extends Fluent<A>{


    public Affinity getAffinity();
    public A withAffinity(Affinity affinity);
    public Boolean hasAffinity();
    
/**
 * This method has been deprecated, please use method buildInputs instead.
 * @return The buildable object.
 */
@Deprecated public TaskRunInputs getInputs();
    public TaskRunInputs buildInputs();
    public A withInputs(TaskRunInputs inputs);
    public Boolean hasInputs();
    public TaskRunSpecFluent.InputsNested<A> withNewInputs();
    public TaskRunSpecFluent.InputsNested<A> withNewInputsLike(TaskRunInputs item);
    public TaskRunSpecFluent.InputsNested<A> editInputs();
    public TaskRunSpecFluent.InputsNested<A> editOrNewInputs();
    public TaskRunSpecFluent.InputsNested<A> editOrNewInputsLike(TaskRunInputs item);
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(Map<String,String> map);
    public Map<String,String> getNodeSelector();
    public A withNodeSelector(Map<String,String> nodeSelector);
    public Boolean hasNodeSelector();
    
/**
 * This method has been deprecated, please use method buildOutputs instead.
 * @return The buildable object.
 */
@Deprecated public TaskRunOutputs getOutputs();
    public TaskRunOutputs buildOutputs();
    public A withOutputs(TaskRunOutputs outputs);
    public Boolean hasOutputs();
    public TaskRunSpecFluent.OutputsNested<A> withNewOutputs();
    public TaskRunSpecFluent.OutputsNested<A> withNewOutputsLike(TaskRunOutputs item);
    public TaskRunSpecFluent.OutputsNested<A> editOutputs();
    public TaskRunSpecFluent.OutputsNested<A> editOrNewOutputs();
    public TaskRunSpecFluent.OutputsNested<A> editOrNewOutputsLike(TaskRunOutputs item);
    
/**
 * This method has been deprecated, please use method buildResults instead.
 * @return The buildable object.
 */
@Deprecated public Results getResults();
    public Results buildResults();
    public A withResults(Results results);
    public Boolean hasResults();
    public A withNewResults(String type,String url);
    public TaskRunSpecFluent.ResultsNested<A> withNewResults();
    public TaskRunSpecFluent.ResultsNested<A> withNewResultsLike(Results item);
    public TaskRunSpecFluent.ResultsNested<A> editResults();
    public TaskRunSpecFluent.ResultsNested<A> editOrNewResults();
    public TaskRunSpecFluent.ResultsNested<A> editOrNewResultsLike(Results item);
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public Boolean hasServiceAccount();
    public A withNewServiceAccount(String arg1);
    public A withNewServiceAccount(StringBuilder arg1);
    public A withNewServiceAccount(StringBuffer arg1);
    public String getStatus();
    public A withStatus(String status);
    public Boolean hasStatus();
    public A withNewStatus(String arg1);
    public A withNewStatus(StringBuilder arg1);
    public A withNewStatus(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTaskRef instead.
 * @return The buildable object.
 */
@Deprecated public TaskRef getTaskRef();
    public TaskRef buildTaskRef();
    public A withTaskRef(TaskRef taskRef);
    public Boolean hasTaskRef();
    public A withNewTaskRef(String apiVersion,String kind,String name);
    public TaskRunSpecFluent.TaskRefNested<A> withNewTaskRef();
    public TaskRunSpecFluent.TaskRefNested<A> withNewTaskRefLike(TaskRef item);
    public TaskRunSpecFluent.TaskRefNested<A> editTaskRef();
    public TaskRunSpecFluent.TaskRefNested<A> editOrNewTaskRef();
    public TaskRunSpecFluent.TaskRefNested<A> editOrNewTaskRefLike(TaskRef item);
    
/**
 * This method has been deprecated, please use method buildTaskSpec instead.
 * @return The buildable object.
 */
@Deprecated public TaskSpec getTaskSpec();
    public TaskSpec buildTaskSpec();
    public A withTaskSpec(TaskSpec taskSpec);
    public Boolean hasTaskSpec();
    public TaskRunSpecFluent.TaskSpecNested<A> withNewTaskSpec();
    public TaskRunSpecFluent.TaskSpecNested<A> withNewTaskSpecLike(TaskSpec item);
    public TaskRunSpecFluent.TaskSpecNested<A> editTaskSpec();
    public TaskRunSpecFluent.TaskSpecNested<A> editOrNewTaskSpec();
    public TaskRunSpecFluent.TaskSpecNested<A> editOrNewTaskSpecLike(TaskSpec item);
    public String getTimeout();
    public A withTimeout(String timeout);
    public Boolean hasTimeout();
    public A withNewTimeout(String arg1);
    public A withNewTimeout(StringBuilder arg1);
    public A withNewTimeout(StringBuffer arg1);
    public A addToTolerations(int index,Toleration item);
    public A setToTolerations(int index,Toleration item);
    public A addToTolerations(Toleration... items);
    public A addAllToTolerations(Collection<Toleration> items);
    public A removeFromTolerations(Toleration... items);
    public A removeAllFromTolerations(Collection<Toleration> items);
    public List<Toleration> getTolerations();
    public Toleration getToleration(int index);
    public Toleration getFirstToleration();
    public Toleration getLastToleration();
    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate);
    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate);
    public A withTolerations(List<Toleration> tolerations);
    public A withTolerations(Toleration... tolerations);
    public Boolean hasTolerations();
    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);

    public interface InputsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskRunInputsFluent<TaskRunSpecFluent.InputsNested<N>>{

        
    public N and();    public N endInputs();
}
    public interface OutputsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskRunOutputsFluent<TaskRunSpecFluent.OutputsNested<N>>{

        
    public N and();    public N endOutputs();
}
    public interface ResultsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResultsFluent<TaskRunSpecFluent.ResultsNested<N>>{

        
    public N and();    public N endResults();
}
    public interface TaskRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskRefFluent<TaskRunSpecFluent.TaskRefNested<N>>{

        
    public N and();    public N endTaskRef();
}
    public interface TaskSpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskSpecFluent<TaskRunSpecFluent.TaskSpecNested<N>>{

        
    public N and();    public N endTaskSpec();
}


}
