package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class TaskRunSpecFluentImpl<A extends TaskRunSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TaskRunSpecFluent<A>{

    private Affinity affinity;
    private TaskRunInputsBuilder inputs;
    private Map<String,String> nodeSelector;
    private TaskRunOutputsBuilder outputs;
    private ResultsBuilder results;
    private String serviceAccount;
    private String status;
    private TaskRefBuilder taskRef;
    private TaskSpecBuilder taskSpec;
    private String timeout;
    private List<Toleration> tolerations;

    public TaskRunSpecFluentImpl(){
    }
    public TaskRunSpecFluentImpl(TaskRunSpec instance){
            this.withAffinity(instance.getAffinity()); 
            this.withInputs(instance.getInputs()); 
            this.withNodeSelector(instance.getNodeSelector()); 
            this.withOutputs(instance.getOutputs()); 
            this.withResults(instance.getResults()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withStatus(instance.getStatus()); 
            this.withTaskRef(instance.getTaskRef()); 
            this.withTaskSpec(instance.getTaskSpec()); 
            this.withTimeout(instance.getTimeout()); 
            this.withTolerations(instance.getTolerations()); 
    }

    public Affinity getAffinity(){
            return this.affinity;
    }

    public A withAffinity(Affinity affinity){
            this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity(){
            return this.affinity != null;
    }

    
/**
 * This method has been deprecated, please use method buildInputs instead.
 * @return The buildable object.
 */
@Deprecated public TaskRunInputs getInputs(){
            return this.inputs!=null?this.inputs.build():null;
    }

    public TaskRunInputs buildInputs(){
            return this.inputs!=null?this.inputs.build():null;
    }

    public A withInputs(TaskRunInputs inputs){
            _visitables.get("inputs").remove(this.inputs);
            if (inputs!=null){ this.inputs= new TaskRunInputsBuilder(inputs); _visitables.get("inputs").add(this.inputs);} return (A) this;
    }

    public Boolean hasInputs(){
            return this.inputs != null;
    }

    public TaskRunSpecFluent.InputsNested<A> withNewInputs(){
            return new InputsNestedImpl();
    }

    public TaskRunSpecFluent.InputsNested<A> withNewInputsLike(TaskRunInputs item){
            return new InputsNestedImpl(item);
    }

    public TaskRunSpecFluent.InputsNested<A> editInputs(){
            return withNewInputsLike(getInputs());
    }

    public TaskRunSpecFluent.InputsNested<A> editOrNewInputs(){
            return withNewInputsLike(getInputs() != null ? getInputs(): new TaskRunInputsBuilder().build());
    }

    public TaskRunSpecFluent.InputsNested<A> editOrNewInputsLike(TaskRunInputs item){
            return withNewInputsLike(getInputs() != null ? getInputs(): item);
    }

    public A addToNodeSelector(String key,String value){
            if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }

    public A addToNodeSelector(Map<String,String> map){
            if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
            if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelector(String key){
            if(this.nodeSelector == null) { return (A) this; }
            if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
    }

    public A removeFromNodeSelector(Map<String,String> map){
            if(this.nodeSelector == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
    }

    public Map<String,String> getNodeSelector(){
            return this.nodeSelector;
    }

    public A withNodeSelector(Map<String,String> nodeSelector){
            if (nodeSelector == null) { this.nodeSelector =  new LinkedHashMap<String,String>();} else {this.nodeSelector = new LinkedHashMap<String,String>(nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector(){
            return this.nodeSelector != null;
    }

    
/**
 * This method has been deprecated, please use method buildOutputs instead.
 * @return The buildable object.
 */
@Deprecated public TaskRunOutputs getOutputs(){
            return this.outputs!=null?this.outputs.build():null;
    }

    public TaskRunOutputs buildOutputs(){
            return this.outputs!=null?this.outputs.build():null;
    }

    public A withOutputs(TaskRunOutputs outputs){
            _visitables.get("outputs").remove(this.outputs);
            if (outputs!=null){ this.outputs= new TaskRunOutputsBuilder(outputs); _visitables.get("outputs").add(this.outputs);} return (A) this;
    }

    public Boolean hasOutputs(){
            return this.outputs != null;
    }

    public TaskRunSpecFluent.OutputsNested<A> withNewOutputs(){
            return new OutputsNestedImpl();
    }

    public TaskRunSpecFluent.OutputsNested<A> withNewOutputsLike(TaskRunOutputs item){
            return new OutputsNestedImpl(item);
    }

    public TaskRunSpecFluent.OutputsNested<A> editOutputs(){
            return withNewOutputsLike(getOutputs());
    }

    public TaskRunSpecFluent.OutputsNested<A> editOrNewOutputs(){
            return withNewOutputsLike(getOutputs() != null ? getOutputs(): new TaskRunOutputsBuilder().build());
    }

    public TaskRunSpecFluent.OutputsNested<A> editOrNewOutputsLike(TaskRunOutputs item){
            return withNewOutputsLike(getOutputs() != null ? getOutputs(): item);
    }

    
/**
 * This method has been deprecated, please use method buildResults instead.
 * @return The buildable object.
 */
@Deprecated public Results getResults(){
            return this.results!=null?this.results.build():null;
    }

    public Results buildResults(){
            return this.results!=null?this.results.build():null;
    }

    public A withResults(Results results){
            _visitables.get("results").remove(this.results);
            if (results!=null){ this.results= new ResultsBuilder(results); _visitables.get("results").add(this.results);} return (A) this;
    }

    public Boolean hasResults(){
            return this.results != null;
    }

    public A withNewResults(String type,String url){
            return (A)withResults(new Results(type, url));
    }

    public TaskRunSpecFluent.ResultsNested<A> withNewResults(){
            return new ResultsNestedImpl();
    }

    public TaskRunSpecFluent.ResultsNested<A> withNewResultsLike(Results item){
            return new ResultsNestedImpl(item);
    }

    public TaskRunSpecFluent.ResultsNested<A> editResults(){
            return withNewResultsLike(getResults());
    }

    public TaskRunSpecFluent.ResultsNested<A> editOrNewResults(){
            return withNewResultsLike(getResults() != null ? getResults(): new ResultsBuilder().build());
    }

    public TaskRunSpecFluent.ResultsNested<A> editOrNewResultsLike(Results item){
            return withNewResultsLike(getResults() != null ? getResults(): item);
    }

    public String getServiceAccount(){
            return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount){
            this.serviceAccount=serviceAccount; return (A) this;
    }

    public Boolean hasServiceAccount(){
            return this.serviceAccount != null;
    }

    public A withNewServiceAccount(String arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuilder arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuffer arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public A withNewStatus(String arg1){
            return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuilder arg1){
            return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuffer arg1){
            return (A)withStatus(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTaskRef instead.
 * @return The buildable object.
 */
@Deprecated public TaskRef getTaskRef(){
            return this.taskRef!=null?this.taskRef.build():null;
    }

    public TaskRef buildTaskRef(){
            return this.taskRef!=null?this.taskRef.build():null;
    }

    public A withTaskRef(TaskRef taskRef){
            _visitables.get("taskRef").remove(this.taskRef);
            if (taskRef!=null){ this.taskRef= new TaskRefBuilder(taskRef); _visitables.get("taskRef").add(this.taskRef);} return (A) this;
    }

    public Boolean hasTaskRef(){
            return this.taskRef != null;
    }

    public A withNewTaskRef(String apiVersion,String kind,String name){
            return (A)withTaskRef(new TaskRef(apiVersion, kind, name));
    }

    public TaskRunSpecFluent.TaskRefNested<A> withNewTaskRef(){
            return new TaskRefNestedImpl();
    }

    public TaskRunSpecFluent.TaskRefNested<A> withNewTaskRefLike(TaskRef item){
            return new TaskRefNestedImpl(item);
    }

    public TaskRunSpecFluent.TaskRefNested<A> editTaskRef(){
            return withNewTaskRefLike(getTaskRef());
    }

    public TaskRunSpecFluent.TaskRefNested<A> editOrNewTaskRef(){
            return withNewTaskRefLike(getTaskRef() != null ? getTaskRef(): new TaskRefBuilder().build());
    }

    public TaskRunSpecFluent.TaskRefNested<A> editOrNewTaskRefLike(TaskRef item){
            return withNewTaskRefLike(getTaskRef() != null ? getTaskRef(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTaskSpec instead.
 * @return The buildable object.
 */
@Deprecated public TaskSpec getTaskSpec(){
            return this.taskSpec!=null?this.taskSpec.build():null;
    }

    public TaskSpec buildTaskSpec(){
            return this.taskSpec!=null?this.taskSpec.build():null;
    }

    public A withTaskSpec(TaskSpec taskSpec){
            _visitables.get("taskSpec").remove(this.taskSpec);
            if (taskSpec!=null){ this.taskSpec= new TaskSpecBuilder(taskSpec); _visitables.get("taskSpec").add(this.taskSpec);} return (A) this;
    }

    public Boolean hasTaskSpec(){
            return this.taskSpec != null;
    }

    public TaskRunSpecFluent.TaskSpecNested<A> withNewTaskSpec(){
            return new TaskSpecNestedImpl();
    }

    public TaskRunSpecFluent.TaskSpecNested<A> withNewTaskSpecLike(TaskSpec item){
            return new TaskSpecNestedImpl(item);
    }

    public TaskRunSpecFluent.TaskSpecNested<A> editTaskSpec(){
            return withNewTaskSpecLike(getTaskSpec());
    }

    public TaskRunSpecFluent.TaskSpecNested<A> editOrNewTaskSpec(){
            return withNewTaskSpecLike(getTaskSpec() != null ? getTaskSpec(): new TaskSpecBuilder().build());
    }

    public TaskRunSpecFluent.TaskSpecNested<A> editOrNewTaskSpecLike(TaskSpec item){
            return withNewTaskSpecLike(getTaskSpec() != null ? getTaskSpec(): item);
    }

    public String getTimeout(){
            return this.timeout;
    }

    public A withTimeout(String timeout){
            this.timeout=timeout; return (A) this;
    }

    public Boolean hasTimeout(){
            return this.timeout != null;
    }

    public A withNewTimeout(String arg1){
            return (A)withTimeout(new String(arg1));
    }

    public A withNewTimeout(StringBuilder arg1){
            return (A)withTimeout(new String(arg1));
    }

    public A withNewTimeout(StringBuffer arg1){
            return (A)withTimeout(new String(arg1));
    }

    public A addToTolerations(int index,Toleration item){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            this.tolerations.add(index, item);
            return (A)this;
    }

    public A setToTolerations(int index,Toleration item){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items){
            for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items){
            for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public List<Toleration> getTolerations(){
            return this.tolerations;
    }

    public Toleration getToleration(int index){
            return this.tolerations.get(index);
    }

    public Toleration getFirstToleration(){
            return this.tolerations.get(0);
    }

    public Toleration getLastToleration(){
            return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate){
            for (Toleration item: tolerations) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate){
            for (Toleration item: tolerations) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTolerations(List<Toleration> tolerations){
            if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
            if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = new ArrayList<Toleration>();} return (A) this;
    }

    public A withTolerations(Toleration... tolerations){
            if (this.tolerations != null) {this.tolerations.clear();}
            if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations(){
            return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value){
            return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskRunSpecFluentImpl that = (TaskRunSpecFluentImpl) o;
            if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
            if (inputs != null ? !inputs.equals(that.inputs) :that.inputs != null) return false;
            if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
            if (outputs != null ? !outputs.equals(that.outputs) :that.outputs != null) return false;
            if (results != null ? !results.equals(that.results) :that.results != null) return false;
            if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (taskRef != null ? !taskRef.equals(that.taskRef) :that.taskRef != null) return false;
            if (taskSpec != null ? !taskSpec.equals(that.taskSpec) :that.taskSpec != null) return false;
            if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
            if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
            return true;
    }


    public class InputsNestedImpl<N> extends TaskRunInputsFluentImpl<TaskRunSpecFluent.InputsNested<N>> implements TaskRunSpecFluent.InputsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TaskRunInputsBuilder builder;
    
            InputsNestedImpl(TaskRunInputs item){
                    this.builder = new TaskRunInputsBuilder(this, item);
            }
            InputsNestedImpl(){
                    this.builder = new TaskRunInputsBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunSpecFluentImpl.this.withInputs(builder.build());
    }
    public N endInputs(){
            return and();
    }

}
    public class OutputsNestedImpl<N> extends TaskRunOutputsFluentImpl<TaskRunSpecFluent.OutputsNested<N>> implements TaskRunSpecFluent.OutputsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TaskRunOutputsBuilder builder;
    
            OutputsNestedImpl(TaskRunOutputs item){
                    this.builder = new TaskRunOutputsBuilder(this, item);
            }
            OutputsNestedImpl(){
                    this.builder = new TaskRunOutputsBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunSpecFluentImpl.this.withOutputs(builder.build());
    }
    public N endOutputs(){
            return and();
    }

}
    public class ResultsNestedImpl<N> extends ResultsFluentImpl<TaskRunSpecFluent.ResultsNested<N>> implements TaskRunSpecFluent.ResultsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResultsBuilder builder;
    
            ResultsNestedImpl(Results item){
                    this.builder = new ResultsBuilder(this, item);
            }
            ResultsNestedImpl(){
                    this.builder = new ResultsBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunSpecFluentImpl.this.withResults(builder.build());
    }
    public N endResults(){
            return and();
    }

}
    public class TaskRefNestedImpl<N> extends TaskRefFluentImpl<TaskRunSpecFluent.TaskRefNested<N>> implements TaskRunSpecFluent.TaskRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TaskRefBuilder builder;
    
            TaskRefNestedImpl(TaskRef item){
                    this.builder = new TaskRefBuilder(this, item);
            }
            TaskRefNestedImpl(){
                    this.builder = new TaskRefBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunSpecFluentImpl.this.withTaskRef(builder.build());
    }
    public N endTaskRef(){
            return and();
    }

}
    public class TaskSpecNestedImpl<N> extends TaskSpecFluentImpl<TaskRunSpecFluent.TaskSpecNested<N>> implements TaskRunSpecFluent.TaskSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TaskSpecBuilder builder;
    
            TaskSpecNestedImpl(TaskSpec item){
                    this.builder = new TaskSpecBuilder(this, item);
            }
            TaskSpecNestedImpl(){
                    this.builder = new TaskSpecBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunSpecFluentImpl.this.withTaskSpec(builder.build());
    }
    public N endTaskSpec(){
            return and();
    }

}


}
