
package io.fabric8.tekton.pipeline.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.knative.v1.Condition;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "completionTime",
    "conditions",
    "observedGeneration",
    "podName",
    "resourcesResult",
    "results",
    "retriesStatus",
    "startTime",
    "steps"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TaskRunStatus implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("completionTime")
    @Valid
    private String completionTime;
    /**
     * 
     * 
     */
    @JsonProperty("conditions")
    @Valid
    private List<Condition> conditions = new ArrayList<Condition>();
    /**
     * 
     * 
     */
    @JsonProperty("observedGeneration")
    private Long observedGeneration;
    /**
     * 
     * 
     */
    @JsonProperty("podName")
    private String podName;
    /**
     * 
     * 
     */
    @JsonProperty("resourcesResult")
    @Valid
    private List<PipelineResourceResult> resourcesResult = new ArrayList<PipelineResourceResult>();
    /**
     * 
     * 
     */
    @JsonProperty("results")
    @Valid
    private Results results;
    /**
     * 
     * 
     */
    @JsonProperty("retriesStatus")
    @Valid
    private List<TaskRunStatus> retriesStatus = new ArrayList<TaskRunStatus>();
    /**
     * 
     * 
     */
    @JsonProperty("startTime")
    @Valid
    private String startTime;
    /**
     * 
     * 
     */
    @JsonProperty("steps")
    @Valid
    private List<StepState> steps = new ArrayList<StepState>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TaskRunStatus() {
    }

    /**
     * 
     * @param completionTime
     * @param retriesStatus
     * @param podName
     * @param startTime
     * @param conditions
     * @param resourcesResult
     * @param results
     * @param steps
     * @param observedGeneration
     */
    public TaskRunStatus(String completionTime, List<Condition> conditions, Long observedGeneration, String podName, List<PipelineResourceResult> resourcesResult, Results results, List<TaskRunStatus> retriesStatus, String startTime, List<StepState> steps) {
        this.completionTime = completionTime;
        this.conditions = conditions;
        this.observedGeneration = observedGeneration;
        this.podName = podName;
        this.resourcesResult = resourcesResult;
        this.results = results;
        this.retriesStatus = retriesStatus;
        this.startTime = startTime;
        this.steps = steps;
    }

    /**
     * 
     * 
     * @return
     *     The completionTime
     */
    @JsonProperty("completionTime")
    public String getCompletionTime() {
        return completionTime;
    }

    /**
     * 
     * 
     * @param completionTime
     *     The completionTime
     */
    @JsonProperty("completionTime")
    public void setCompletionTime(String completionTime) {
        this.completionTime = completionTime;
    }

    /**
     * 
     * 
     * @return
     *     The conditions
     */
    @JsonProperty("conditions")
    public List<Condition> getConditions() {
        return conditions;
    }

    /**
     * 
     * 
     * @param conditions
     *     The conditions
     */
    @JsonProperty("conditions")
    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    /**
     * 
     * 
     * @return
     *     The observedGeneration
     */
    @JsonProperty("observedGeneration")
    public Long getObservedGeneration() {
        return observedGeneration;
    }

    /**
     * 
     * 
     * @param observedGeneration
     *     The observedGeneration
     */
    @JsonProperty("observedGeneration")
    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    /**
     * 
     * 
     * @return
     *     The podName
     */
    @JsonProperty("podName")
    public String getPodName() {
        return podName;
    }

    /**
     * 
     * 
     * @param podName
     *     The podName
     */
    @JsonProperty("podName")
    public void setPodName(String podName) {
        this.podName = podName;
    }

    /**
     * 
     * 
     * @return
     *     The resourcesResult
     */
    @JsonProperty("resourcesResult")
    public List<PipelineResourceResult> getResourcesResult() {
        return resourcesResult;
    }

    /**
     * 
     * 
     * @param resourcesResult
     *     The resourcesResult
     */
    @JsonProperty("resourcesResult")
    public void setResourcesResult(List<PipelineResourceResult> resourcesResult) {
        this.resourcesResult = resourcesResult;
    }

    /**
     * 
     * 
     * @return
     *     The results
     */
    @JsonProperty("results")
    public Results getResults() {
        return results;
    }

    /**
     * 
     * 
     * @param results
     *     The results
     */
    @JsonProperty("results")
    public void setResults(Results results) {
        this.results = results;
    }

    /**
     * 
     * 
     * @return
     *     The retriesStatus
     */
    @JsonProperty("retriesStatus")
    public List<TaskRunStatus> getRetriesStatus() {
        return retriesStatus;
    }

    /**
     * 
     * 
     * @param retriesStatus
     *     The retriesStatus
     */
    @JsonProperty("retriesStatus")
    public void setRetriesStatus(List<TaskRunStatus> retriesStatus) {
        this.retriesStatus = retriesStatus;
    }

    /**
     * 
     * 
     * @return
     *     The startTime
     */
    @JsonProperty("startTime")
    public String getStartTime() {
        return startTime;
    }

    /**
     * 
     * 
     * @param startTime
     *     The startTime
     */
    @JsonProperty("startTime")
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    /**
     * 
     * 
     * @return
     *     The steps
     */
    @JsonProperty("steps")
    public List<StepState> getSteps() {
        return steps;
    }

    /**
     * 
     * 
     * @param steps
     *     The steps
     */
    @JsonProperty("steps")
    public void setSteps(List<StepState> steps) {
        this.steps = steps;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
