package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskRunStatusBuilder extends TaskRunStatusFluentImpl<TaskRunStatusBuilder> implements VisitableBuilder<TaskRunStatus,TaskRunStatusBuilder>{

    TaskRunStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskRunStatusBuilder(){
            this(true);
    }
    public TaskRunStatusBuilder(Boolean validationEnabled){
            this(new TaskRunStatus(), validationEnabled);
    }
    public TaskRunStatusBuilder(TaskRunStatusFluent<?> fluent){
            this(fluent, true);
    }
    public TaskRunStatusBuilder(TaskRunStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TaskRunStatus(), validationEnabled);
    }
    public TaskRunStatusBuilder(TaskRunStatusFluent<?> fluent,TaskRunStatus instance){
            this(fluent, instance, true);
    }
    public TaskRunStatusBuilder(TaskRunStatusFluent<?> fluent,TaskRunStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCompletionTime(instance.getCompletionTime()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withPodName(instance.getPodName()); 
            fluent.withResourcesResult(instance.getResourcesResult()); 
            fluent.withResults(instance.getResults()); 
            fluent.withRetriesStatus(instance.getRetriesStatus()); 
            fluent.withStartTime(instance.getStartTime()); 
            fluent.withSteps(instance.getSteps()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunStatusBuilder(TaskRunStatus instance){
            this(instance,true);
    }
    public TaskRunStatusBuilder(TaskRunStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCompletionTime(instance.getCompletionTime()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withPodName(instance.getPodName()); 
            this.withResourcesResult(instance.getResourcesResult()); 
            this.withResults(instance.getResults()); 
            this.withRetriesStatus(instance.getRetriesStatus()); 
            this.withStartTime(instance.getStartTime()); 
            this.withSteps(instance.getSteps()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunStatusBuilder(Validator validator){
            this(new TaskRunStatus(), true);
    }
    public TaskRunStatusBuilder(TaskRunStatusFluent<?> fluent,TaskRunStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withCompletionTime(instance.getCompletionTime()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withPodName(instance.getPodName()); 
            fluent.withResourcesResult(instance.getResourcesResult()); 
            fluent.withResults(instance.getResults()); 
            fluent.withRetriesStatus(instance.getRetriesStatus()); 
            fluent.withStartTime(instance.getStartTime()); 
            fluent.withSteps(instance.getSteps()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskRunStatusBuilder(TaskRunStatus instance,Validator validator){
            this.fluent = this; 
            this.withCompletionTime(instance.getCompletionTime()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withPodName(instance.getPodName()); 
            this.withResourcesResult(instance.getResourcesResult()); 
            this.withResults(instance.getResults()); 
            this.withRetriesStatus(instance.getRetriesStatus()); 
            this.withStartTime(instance.getStartTime()); 
            this.withSteps(instance.getSteps()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TaskRunStatus build(){
            TaskRunStatus buildable = new TaskRunStatus(fluent.getCompletionTime(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getPodName(),fluent.getResourcesResult(),fluent.getResults(),fluent.getRetriesStatus(),fluent.getStartTime(),fluent.getSteps());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskRunStatusBuilder that = (TaskRunStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
