package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.v1.Condition;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface TaskRunStatusFluent<A extends TaskRunStatusFluent<A>> extends Fluent<A>{


    public String getCompletionTime();
    public A withCompletionTime(String completionTime);
    public Boolean hasCompletionTime();
    public A withNewCompletionTime(String arg1);
    public A withNewCompletionTime(StringBuilder arg1);
    public A withNewCompletionTime(StringBuffer arg1);
    public A addToConditions(int index,Condition item);
    public A setToConditions(int index,Condition item);
    public A addToConditions(Condition... items);
    public A addAllToConditions(Collection<Condition> items);
    public A removeFromConditions(Condition... items);
    public A removeAllFromConditions(Collection<Condition> items);
    public List<Condition> getConditions();
    public Condition getCondition(int index);
    public Condition getFirstCondition();
    public Condition getLastCondition();
    public Condition getMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<Condition> predicate);
    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<Condition> predicate);
    public A withConditions(List<Condition> conditions);
    public A withConditions(Condition... conditions);
    public Boolean hasConditions();
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public String getPodName();
    public A withPodName(String podName);
    public Boolean hasPodName();
    public A withNewPodName(String arg1);
    public A withNewPodName(StringBuilder arg1);
    public A withNewPodName(StringBuffer arg1);
    public A addToResourcesResult(int index,PipelineResourceResult item);
    public A setToResourcesResult(int index,PipelineResourceResult item);
    public A addToResourcesResult(PipelineResourceResult... items);
    public A addAllToResourcesResult(Collection<PipelineResourceResult> items);
    public A removeFromResourcesResult(PipelineResourceResult... items);
    public A removeAllFromResourcesResult(Collection<PipelineResourceResult> items);
    
/**
 * This method has been deprecated, please use method buildResourcesResult instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineResourceResult> getResourcesResult();
    public List<PipelineResourceResult> buildResourcesResult();
    public PipelineResourceResult buildResourcesResult(int index);
    public PipelineResourceResult buildFirstResourcesResult();
    public PipelineResourceResult buildLastResourcesResult();
    public PipelineResourceResult buildMatchingResourcesResult(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceResultBuilder> predicate);
    public Boolean hasMatchingResourcesResult(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceResultBuilder> predicate);
    public A withResourcesResult(List<PipelineResourceResult> resourcesResult);
    public A withResourcesResult(PipelineResourceResult... resourcesResult);
    public Boolean hasResourcesResult();
    public A addNewResourcesResult(String digest,String name);
    public TaskRunStatusFluent.ResourcesResultNested<A> addNewResourcesResult();
    public TaskRunStatusFluent.ResourcesResultNested<A> addNewResourcesResultLike(PipelineResourceResult item);
    public TaskRunStatusFluent.ResourcesResultNested<A> setNewResourcesResultLike(int index,PipelineResourceResult item);
    public TaskRunStatusFluent.ResourcesResultNested<A> editResourcesResult(int index);
    public TaskRunStatusFluent.ResourcesResultNested<A> editFirstResourcesResult();
    public TaskRunStatusFluent.ResourcesResultNested<A> editLastResourcesResult();
    public TaskRunStatusFluent.ResourcesResultNested<A> editMatchingResourcesResult(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceResultBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildResults instead.
 * @return The buildable object.
 */
@Deprecated public Results getResults();
    public Results buildResults();
    public A withResults(Results results);
    public Boolean hasResults();
    public A withNewResults(String type,String url);
    public TaskRunStatusFluent.ResultsNested<A> withNewResults();
    public TaskRunStatusFluent.ResultsNested<A> withNewResultsLike(Results item);
    public TaskRunStatusFluent.ResultsNested<A> editResults();
    public TaskRunStatusFluent.ResultsNested<A> editOrNewResults();
    public TaskRunStatusFluent.ResultsNested<A> editOrNewResultsLike(Results item);
    public A addToRetriesStatus(int index,TaskRunStatus item);
    public A setToRetriesStatus(int index,TaskRunStatus item);
    public A addToRetriesStatus(TaskRunStatus... items);
    public A addAllToRetriesStatus(Collection<TaskRunStatus> items);
    public A removeFromRetriesStatus(TaskRunStatus... items);
    public A removeAllFromRetriesStatus(Collection<TaskRunStatus> items);
    
/**
 * This method has been deprecated, please use method buildRetriesStatus instead.
 * @return The buildable object.
 */
@Deprecated public List<TaskRunStatus> getRetriesStatus();
    public List<TaskRunStatus> buildRetriesStatus();
    public TaskRunStatus buildRetriesStatus(int index);
    public TaskRunStatus buildFirstRetriesStatus();
    public TaskRunStatus buildLastRetriesStatus();
    public TaskRunStatus buildMatchingRetriesStatus(io.fabric8.kubernetes.api.builder.Predicate<TaskRunStatusBuilder> predicate);
    public Boolean hasMatchingRetriesStatus(io.fabric8.kubernetes.api.builder.Predicate<TaskRunStatusBuilder> predicate);
    public A withRetriesStatus(List<TaskRunStatus> retriesStatus);
    public A withRetriesStatus(TaskRunStatus... retriesStatus);
    public Boolean hasRetriesStatus();
    public TaskRunStatusFluent.RetriesStatusNested<A> addNewRetriesStatus();
    public TaskRunStatusFluent.RetriesStatusNested<A> addNewRetriesStatusLike(TaskRunStatus item);
    public TaskRunStatusFluent.RetriesStatusNested<A> setNewRetriesStatusLike(int index,TaskRunStatus item);
    public TaskRunStatusFluent.RetriesStatusNested<A> editRetriesStatus(int index);
    public TaskRunStatusFluent.RetriesStatusNested<A> editFirstRetriesStatus();
    public TaskRunStatusFluent.RetriesStatusNested<A> editLastRetriesStatus();
    public TaskRunStatusFluent.RetriesStatusNested<A> editMatchingRetriesStatus(io.fabric8.kubernetes.api.builder.Predicate<TaskRunStatusBuilder> predicate);
    public String getStartTime();
    public A withStartTime(String startTime);
    public Boolean hasStartTime();
    public A withNewStartTime(String arg1);
    public A withNewStartTime(StringBuilder arg1);
    public A withNewStartTime(StringBuffer arg1);
    public A addToSteps(int index,StepState item);
    public A setToSteps(int index,StepState item);
    public A addToSteps(StepState... items);
    public A addAllToSteps(Collection<StepState> items);
    public A removeFromSteps(StepState... items);
    public A removeAllFromSteps(Collection<StepState> items);
    
/**
 * This method has been deprecated, please use method buildSteps instead.
 * @return The buildable object.
 */
@Deprecated public List<StepState> getSteps();
    public List<StepState> buildSteps();
    public StepState buildStep(int index);
    public StepState buildFirstStep();
    public StepState buildLastStep();
    public StepState buildMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<StepStateBuilder> predicate);
    public Boolean hasMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<StepStateBuilder> predicate);
    public A withSteps(List<StepState> steps);
    public A withSteps(StepState... steps);
    public Boolean hasSteps();
    public TaskRunStatusFluent.StepsNested<A> addNewStep();
    public TaskRunStatusFluent.StepsNested<A> addNewStepLike(StepState item);
    public TaskRunStatusFluent.StepsNested<A> setNewStepLike(int index,StepState item);
    public TaskRunStatusFluent.StepsNested<A> editStep(int index);
    public TaskRunStatusFluent.StepsNested<A> editFirstStep();
    public TaskRunStatusFluent.StepsNested<A> editLastStep();
    public TaskRunStatusFluent.StepsNested<A> editMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<StepStateBuilder> predicate);

    public interface ResourcesResultNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineResourceResultFluent<TaskRunStatusFluent.ResourcesResultNested<N>>{

        
    public N and();    public N endResourcesResult();
}
    public interface ResultsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResultsFluent<TaskRunStatusFluent.ResultsNested<N>>{

        
    public N and();    public N endResults();
}
    public interface RetriesStatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskRunStatusFluent<TaskRunStatusFluent.RetriesStatusNested<N>>{

        
    public N and();    public N endRetriesStatus();
}
    public interface StepsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StepStateFluent<TaskRunStatusFluent.StepsNested<N>>{

        
    public N and();    public N endStep();
}


}
