
package io.fabric8.tekton.pipeline.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Volume;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "containerTemplate",
    "inputs",
    "outputs",
    "stepTemplate",
    "steps",
    "volumes"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TaskSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("containerTemplate")
    @Valid
    private Container containerTemplate;
    /**
     * 
     * 
     */
    @JsonProperty("inputs")
    @Valid
    private Inputs inputs;
    /**
     * 
     * 
     */
    @JsonProperty("outputs")
    @Valid
    private Outputs outputs;
    /**
     * 
     * 
     */
    @JsonProperty("stepTemplate")
    @Valid
    private Container stepTemplate;
    /**
     * 
     * 
     */
    @JsonProperty("steps")
    @Valid
    private List<Container> steps = new ArrayList<Container>();
    /**
     * 
     * 
     */
    @JsonProperty("volumes")
    @Valid
    private List<Volume> volumes = new ArrayList<Volume>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TaskSpec() {
    }

    /**
     * 
     * @param outputs
     * @param inputs
     * @param volumes
     * @param stepTemplate
     * @param containerTemplate
     * @param steps
     */
    public TaskSpec(Container containerTemplate, Inputs inputs, Outputs outputs, Container stepTemplate, List<Container> steps, List<Volume> volumes) {
        this.containerTemplate = containerTemplate;
        this.inputs = inputs;
        this.outputs = outputs;
        this.stepTemplate = stepTemplate;
        this.steps = steps;
        this.volumes = volumes;
    }

    /**
     * 
     * 
     * @return
     *     The containerTemplate
     */
    @JsonProperty("containerTemplate")
    public Container getContainerTemplate() {
        return containerTemplate;
    }

    /**
     * 
     * 
     * @param containerTemplate
     *     The containerTemplate
     */
    @JsonProperty("containerTemplate")
    public void setContainerTemplate(Container containerTemplate) {
        this.containerTemplate = containerTemplate;
    }

    /**
     * 
     * 
     * @return
     *     The inputs
     */
    @JsonProperty("inputs")
    public Inputs getInputs() {
        return inputs;
    }

    /**
     * 
     * 
     * @param inputs
     *     The inputs
     */
    @JsonProperty("inputs")
    public void setInputs(Inputs inputs) {
        this.inputs = inputs;
    }

    /**
     * 
     * 
     * @return
     *     The outputs
     */
    @JsonProperty("outputs")
    public Outputs getOutputs() {
        return outputs;
    }

    /**
     * 
     * 
     * @param outputs
     *     The outputs
     */
    @JsonProperty("outputs")
    public void setOutputs(Outputs outputs) {
        this.outputs = outputs;
    }

    /**
     * 
     * 
     * @return
     *     The stepTemplate
     */
    @JsonProperty("stepTemplate")
    public Container getStepTemplate() {
        return stepTemplate;
    }

    /**
     * 
     * 
     * @param stepTemplate
     *     The stepTemplate
     */
    @JsonProperty("stepTemplate")
    public void setStepTemplate(Container stepTemplate) {
        this.stepTemplate = stepTemplate;
    }

    /**
     * 
     * 
     * @return
     *     The steps
     */
    @JsonProperty("steps")
    public List<Container> getSteps() {
        return steps;
    }

    /**
     * 
     * 
     * @param steps
     *     The steps
     */
    @JsonProperty("steps")
    public void setSteps(List<Container> steps) {
        this.steps = steps;
    }

    /**
     * 
     * 
     * @return
     *     The volumes
     */
    @JsonProperty("volumes")
    public List<Volume> getVolumes() {
        return volumes;
    }

    /**
     * 
     * 
     * @param volumes
     *     The volumes
     */
    @JsonProperty("volumes")
    public void setVolumes(List<Volume> volumes) {
        this.volumes = volumes;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
