/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1beta1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.tekton.v1beta1.ParamValueBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"ArrayVal", "ObjectVal", "StringVal", "Type"})
public class ParamValue
implements Editable<ParamValueBuilder>,
KubernetesResource {
    private static final String TYPE_STRING = "string";
    private static final String TYPE_ARRAY = "array";
    private static final String TYPE_OBJECT = "object";
    @JsonProperty(value="ArrayVal")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> arrayVal = new ArrayList<String>();
    @JsonProperty(value="ObjectVal")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> objectVal = new LinkedHashMap<String, String>();
    @JsonProperty(value="StringVal")
    private String stringVal;
    @JsonProperty(value="Type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public ParamValue() {
    }

    public ParamValue(List<String> arrayVal, Map<String, String> objectVal, String stringVal, String type) {
        this.arrayVal = arrayVal;
        this.objectVal = objectVal;
        this.stringVal = stringVal;
        this.type = type;
    }

    public ParamValue(String stringVal) {
        this(null, null, stringVal, TYPE_STRING);
    }

    public ParamValue(List<String> arrayVal) {
        this(arrayVal, null, null, TYPE_ARRAY);
    }

    public ParamValue(Map<String, String> objectVal) {
        this(null, objectVal, null, TYPE_OBJECT);
    }

    @JsonProperty(value="ArrayVal")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getArrayVal() {
        return this.arrayVal;
    }

    @JsonProperty(value="ArrayVal")
    public void setArrayVal(List<String> arrayVal) {
        this.arrayVal = arrayVal;
    }

    @JsonProperty(value="ObjectVal")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getObjectVal() {
        return this.objectVal;
    }

    @JsonProperty(value="ObjectVal")
    public void setObjectVal(Map<String, String> objectVal) {
        this.objectVal = objectVal;
    }

    @JsonProperty(value="StringVal")
    public String getStringVal() {
        return this.stringVal;
    }

    @JsonProperty(value="StringVal")
    public void setStringVal(String stringVal) {
        this.stringVal = stringVal;
    }

    @JsonProperty(value="Type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="Type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public ParamValueBuilder edit() {
        return new ParamValueBuilder(this);
    }

    @JsonIgnore
    public ParamValueBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Generated
    public String toString() {
        return "ParamValue(arrayVal=" + this.getArrayVal() + ", objectVal=" + this.getObjectVal() + ", stringVal=" + this.getStringVal() + ", type=" + this.getType() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParamValue)) {
            return false;
        }
        ParamValue other = (ParamValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$arrayVal = this.getArrayVal();
        List<String> other$arrayVal = other.getArrayVal();
        if (this$arrayVal == null ? other$arrayVal != null : !((Object)this$arrayVal).equals(other$arrayVal)) {
            return false;
        }
        Map<String, String> this$objectVal = this.getObjectVal();
        Map<String, String> other$objectVal = other.getObjectVal();
        if (this$objectVal == null ? other$objectVal != null : !((Object)this$objectVal).equals(other$objectVal)) {
            return false;
        }
        String this$stringVal = this.getStringVal();
        String other$stringVal = other.getStringVal();
        if (this$stringVal == null ? other$stringVal != null : !this$stringVal.equals(other$stringVal)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParamValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $arrayVal = this.getArrayVal();
        result = result * 59 + ($arrayVal == null ? 43 : ((Object)$arrayVal).hashCode());
        Map<String, String> $objectVal = this.getObjectVal();
        result = result * 59 + ($objectVal == null ? 43 : ((Object)$objectVal).hashCode());
        String $stringVal = this.getStringVal();
        result = result * 59 + ($stringVal == null ? 43 : $stringVal.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public static class Deserializer
    extends JsonDeserializer<ParamValue> {
        public ParamValue deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            ParamValue arrayOrString;
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            if (node.isArray()) {
                ArrayList<String> elements = new ArrayList<String>();
                node.elements().forEachRemaining(n -> elements.add(n.asText()));
                arrayOrString = new ParamValue(elements);
            } else {
                arrayOrString = new ParamValue(node.asText());
            }
            return arrayOrString;
        }
    }

    public static class Serializer
    extends JsonSerializer<ParamValue> {
        public void serialize(ParamValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                if (value.getType() == null) {
                    String stringVal = value.getStringVal();
                    if (stringVal != null) {
                        jgen.writeString(stringVal);
                    } else {
                        List<String> arrayVal = value.getArrayVal();
                        if (arrayVal != null) {
                            this.writeArray(value, jgen);
                        } else {
                            jgen.writeNull();
                        }
                    }
                } else if (Objects.equals(value.getType(), ParamValue.TYPE_STRING)) {
                    jgen.writeString(value.stringVal);
                } else if (Objects.equals(value.getType(), ParamValue.TYPE_ARRAY)) {
                    this.writeArray(value, jgen);
                } else {
                    jgen.writeNull();
                }
            } else {
                jgen.writeNull();
            }
        }

        private void writeArray(ParamValue value, JsonGenerator jgen) throws IOException {
            jgen.writeStartArray(value.getArrayVal().size());
            for (String n : value.getArrayVal()) {
                jgen.writeString(n);
            }
            jgen.writeEndArray();
        }
    }
}

