/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.tekton.pod.Template;
import io.fabric8.tekton.pod.TemplateBuilder;
import io.fabric8.tekton.pod.TemplateFluent;
import io.fabric8.tekton.v1.Param;
import io.fabric8.tekton.v1.ParamBuilder;
import io.fabric8.tekton.v1.ParamFluent;
import io.fabric8.tekton.v1.TaskRef;
import io.fabric8.tekton.v1.TaskRefBuilder;
import io.fabric8.tekton.v1.TaskRefFluent;
import io.fabric8.tekton.v1.TaskRunDebug;
import io.fabric8.tekton.v1.TaskRunDebugBuilder;
import io.fabric8.tekton.v1.TaskRunDebugFluent;
import io.fabric8.tekton.v1.TaskRunSidecarSpec;
import io.fabric8.tekton.v1.TaskRunSidecarSpecBuilder;
import io.fabric8.tekton.v1.TaskRunSidecarSpecFluent;
import io.fabric8.tekton.v1.TaskRunSpec;
import io.fabric8.tekton.v1.TaskRunStepSpec;
import io.fabric8.tekton.v1.TaskRunStepSpecBuilder;
import io.fabric8.tekton.v1.TaskRunStepSpecFluent;
import io.fabric8.tekton.v1.TaskSpec;
import io.fabric8.tekton.v1.TaskSpecBuilder;
import io.fabric8.tekton.v1.TaskSpecFluent;
import io.fabric8.tekton.v1.WorkspaceBinding;
import io.fabric8.tekton.v1.WorkspaceBindingBuilder;
import io.fabric8.tekton.v1.WorkspaceBindingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TaskRunSpecFluent<A extends TaskRunSpecFluent<A>>
extends BaseFluent<A> {
    private ResourceRequirementsBuilder computeResources;
    private TaskRunDebugBuilder debug;
    private ArrayList<ParamBuilder> params = new ArrayList();
    private TemplateBuilder podTemplate;
    private Integer retries;
    private String serviceAccountName;
    private ArrayList<TaskRunSidecarSpecBuilder> sidecarSpecs = new ArrayList();
    private String status;
    private String statusMessage;
    private ArrayList<TaskRunStepSpecBuilder> stepSpecs = new ArrayList();
    private TaskRefBuilder taskRef;
    private TaskSpecBuilder taskSpec;
    private Duration timeout;
    private ArrayList<WorkspaceBindingBuilder> workspaces = new ArrayList();
    private Map<String, Object> additionalProperties;

    public TaskRunSpecFluent() {
    }

    public TaskRunSpecFluent(TaskRunSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TaskRunSpec instance) {
        TaskRunSpec taskRunSpec = instance = instance != null ? instance : new TaskRunSpec();
        if (instance != null) {
            this.withComputeResources(instance.getComputeResources());
            this.withDebug(instance.getDebug());
            this.withParams(instance.getParams());
            this.withPodTemplate(instance.getPodTemplate());
            this.withRetries(instance.getRetries());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSidecarSpecs(instance.getSidecarSpecs());
            this.withStatus(instance.getStatus());
            this.withStatusMessage(instance.getStatusMessage());
            this.withStepSpecs(instance.getStepSpecs());
            this.withTaskRef(instance.getTaskRef());
            this.withTaskSpec(instance.getTaskSpec());
            this.withTimeout(instance.getTimeout());
            this.withWorkspaces(instance.getWorkspaces());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ResourceRequirements buildComputeResources() {
        return this.computeResources != null ? this.computeResources.build() : null;
    }

    public A withComputeResources(ResourceRequirements computeResources) {
        this._visitables.remove((Object)"computeResources");
        if (computeResources != null) {
            this.computeResources = new ResourceRequirementsBuilder(computeResources);
            this._visitables.get((Object)"computeResources").add(this.computeResources);
        } else {
            this.computeResources = null;
            this._visitables.get((Object)"computeResources").remove(this.computeResources);
        }
        return (A)((Object)this);
    }

    public boolean hasComputeResources() {
        return this.computeResources != null;
    }

    public ComputeResourcesNested<A> withNewComputeResources() {
        return new ComputeResourcesNested(null);
    }

    public ComputeResourcesNested<A> withNewComputeResourcesLike(ResourceRequirements item) {
        return new ComputeResourcesNested(item);
    }

    public ComputeResourcesNested<A> editComputeResources() {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(null));
    }

    public ComputeResourcesNested<A> editOrNewComputeResources() {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ComputeResourcesNested<A> editOrNewComputeResourcesLike(ResourceRequirements item) {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(item));
    }

    public TaskRunDebug buildDebug() {
        return this.debug != null ? this.debug.build() : null;
    }

    public A withDebug(TaskRunDebug debug) {
        this._visitables.remove((Object)"debug");
        if (debug != null) {
            this.debug = new TaskRunDebugBuilder(debug);
            this._visitables.get((Object)"debug").add(this.debug);
        } else {
            this.debug = null;
            this._visitables.get((Object)"debug").remove((Object)this.debug);
        }
        return (A)((Object)this);
    }

    public boolean hasDebug() {
        return this.debug != null;
    }

    public DebugNested<A> withNewDebug() {
        return new DebugNested(null);
    }

    public DebugNested<A> withNewDebugLike(TaskRunDebug item) {
        return new DebugNested(item);
    }

    public DebugNested<A> editDebug() {
        return this.withNewDebugLike(Optional.ofNullable(this.buildDebug()).orElse(null));
    }

    public DebugNested<A> editOrNewDebug() {
        return this.withNewDebugLike(Optional.ofNullable(this.buildDebug()).orElse(new TaskRunDebugBuilder().build()));
    }

    public DebugNested<A> editOrNewDebugLike(TaskRunDebug item) {
        return this.withNewDebugLike(Optional.ofNullable(this.buildDebug()).orElse(item));
    }

    public A addToParams(int index, Param item) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        ParamBuilder builder = new ParamBuilder(item);
        if (index < 0 || index >= this.params.size()) {
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        } else {
            this._visitables.get((Object)"params").add(builder);
            this.params.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToParams(int index, Param item) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        ParamBuilder builder = new ParamBuilder(item);
        if (index < 0 || index >= this.params.size()) {
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        } else {
            this._visitables.get((Object)"params").add(builder);
            this.params.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToParams(Param ... items) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToParams(Collection<Param> items) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromParams(Param ... items) {
        if (this.params == null) {
            return (A)((Object)this);
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").remove((Object)builder);
            this.params.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromParams(Collection<Param> items) {
        if (this.params == null) {
            return (A)((Object)this);
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").remove((Object)builder);
            this.params.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromParams(Predicate<ParamBuilder> predicate) {
        if (this.params == null) {
            return (A)((Object)this);
        }
        Iterator<ParamBuilder> each = this.params.iterator();
        List visitables = this._visitables.get((Object)"params");
        while (each.hasNext()) {
            ParamBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Param> buildParams() {
        return this.params != null ? TaskRunSpecFluent.build(this.params) : null;
    }

    public Param buildParam(int index) {
        return this.params.get(index).build();
    }

    public Param buildFirstParam() {
        return this.params.get(0).build();
    }

    public Param buildLastParam() {
        return this.params.get(this.params.size() - 1).build();
    }

    public Param buildMatchingParam(Predicate<ParamBuilder> predicate) {
        for (ParamBuilder item : this.params) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingParam(Predicate<ParamBuilder> predicate) {
        for (ParamBuilder item : this.params) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withParams(List<Param> params) {
        if (this.params != null) {
            this._visitables.get((Object)"params").clear();
        }
        if (params != null) {
            this.params = new ArrayList();
            for (Param item : params) {
                this.addToParams(item);
            }
        } else {
            this.params = null;
        }
        return (A)((Object)this);
    }

    public A withParams(Param ... params) {
        if (this.params != null) {
            this.params.clear();
            this._visitables.remove((Object)"params");
        }
        if (params != null) {
            for (Param item : params) {
                this.addToParams(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasParams() {
        return this.params != null && !this.params.isEmpty();
    }

    public ParamsNested<A> addNewParam() {
        return new ParamsNested(-1, null);
    }

    public ParamsNested<A> addNewParamLike(Param item) {
        return new ParamsNested(-1, item);
    }

    public ParamsNested<A> setNewParamLike(int index, Param item) {
        return new ParamsNested(index, item);
    }

    public ParamsNested<A> editParam(int index) {
        if (this.params.size() <= index) {
            throw new RuntimeException("Can't edit params. Index exceeds size.");
        }
        return this.setNewParamLike(index, this.buildParam(index));
    }

    public ParamsNested<A> editFirstParam() {
        if (this.params.size() == 0) {
            throw new RuntimeException("Can't edit first params. The list is empty.");
        }
        return this.setNewParamLike(0, this.buildParam(0));
    }

    public ParamsNested<A> editLastParam() {
        int index = this.params.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last params. The list is empty.");
        }
        return this.setNewParamLike(index, this.buildParam(index));
    }

    public ParamsNested<A> editMatchingParam(Predicate<ParamBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.params.size(); ++i) {
            if (!predicate.test(this.params.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching params. No match found.");
        }
        return this.setNewParamLike(index, this.buildParam(index));
    }

    public Template buildPodTemplate() {
        return this.podTemplate != null ? this.podTemplate.build() : null;
    }

    public A withPodTemplate(Template podTemplate) {
        this._visitables.remove((Object)"podTemplate");
        if (podTemplate != null) {
            this.podTemplate = new TemplateBuilder(podTemplate);
            this._visitables.get((Object)"podTemplate").add(this.podTemplate);
        } else {
            this.podTemplate = null;
            this._visitables.get((Object)"podTemplate").remove((Object)this.podTemplate);
        }
        return (A)((Object)this);
    }

    public boolean hasPodTemplate() {
        return this.podTemplate != null;
    }

    public PodTemplateNested<A> withNewPodTemplate() {
        return new PodTemplateNested(null);
    }

    public PodTemplateNested<A> withNewPodTemplateLike(Template item) {
        return new PodTemplateNested(item);
    }

    public PodTemplateNested<A> editPodTemplate() {
        return this.withNewPodTemplateLike(Optional.ofNullable(this.buildPodTemplate()).orElse(null));
    }

    public PodTemplateNested<A> editOrNewPodTemplate() {
        return this.withNewPodTemplateLike(Optional.ofNullable(this.buildPodTemplate()).orElse(new TemplateBuilder().build()));
    }

    public PodTemplateNested<A> editOrNewPodTemplateLike(Template item) {
        return this.withNewPodTemplateLike(Optional.ofNullable(this.buildPodTemplate()).orElse(item));
    }

    public Integer getRetries() {
        return this.retries;
    }

    public A withRetries(Integer retries) {
        this.retries = retries;
        return (A)((Object)this);
    }

    public boolean hasRetries() {
        return this.retries != null;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)((Object)this);
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A addToSidecarSpecs(int index, TaskRunSidecarSpec item) {
        if (this.sidecarSpecs == null) {
            this.sidecarSpecs = new ArrayList();
        }
        TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
        if (index < 0 || index >= this.sidecarSpecs.size()) {
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.add(builder);
        } else {
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSidecarSpecs(int index, TaskRunSidecarSpec item) {
        if (this.sidecarSpecs == null) {
            this.sidecarSpecs = new ArrayList();
        }
        TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
        if (index < 0 || index >= this.sidecarSpecs.size()) {
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.add(builder);
        } else {
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSidecarSpecs(TaskRunSidecarSpec ... items) {
        if (this.sidecarSpecs == null) {
            this.sidecarSpecs = new ArrayList();
        }
        for (TaskRunSidecarSpec item : items) {
            TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSidecarSpecs(Collection<TaskRunSidecarSpec> items) {
        if (this.sidecarSpecs == null) {
            this.sidecarSpecs = new ArrayList();
        }
        for (TaskRunSidecarSpec item : items) {
            TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSidecarSpecs(TaskRunSidecarSpec ... items) {
        if (this.sidecarSpecs == null) {
            return (A)((Object)this);
        }
        for (TaskRunSidecarSpec item : items) {
            TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
            this._visitables.get((Object)"sidecarSpecs").remove((Object)builder);
            this.sidecarSpecs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSidecarSpecs(Collection<TaskRunSidecarSpec> items) {
        if (this.sidecarSpecs == null) {
            return (A)((Object)this);
        }
        for (TaskRunSidecarSpec item : items) {
            TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
            this._visitables.get((Object)"sidecarSpecs").remove((Object)builder);
            this.sidecarSpecs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSidecarSpecs(Predicate<TaskRunSidecarSpecBuilder> predicate) {
        if (this.sidecarSpecs == null) {
            return (A)((Object)this);
        }
        Iterator<TaskRunSidecarSpecBuilder> each = this.sidecarSpecs.iterator();
        List visitables = this._visitables.get((Object)"sidecarSpecs");
        while (each.hasNext()) {
            TaskRunSidecarSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TaskRunSidecarSpec> buildSidecarSpecs() {
        return this.sidecarSpecs != null ? TaskRunSpecFluent.build(this.sidecarSpecs) : null;
    }

    public TaskRunSidecarSpec buildSidecarSpec(int index) {
        return this.sidecarSpecs.get(index).build();
    }

    public TaskRunSidecarSpec buildFirstSidecarSpec() {
        return this.sidecarSpecs.get(0).build();
    }

    public TaskRunSidecarSpec buildLastSidecarSpec() {
        return this.sidecarSpecs.get(this.sidecarSpecs.size() - 1).build();
    }

    public TaskRunSidecarSpec buildMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
        for (TaskRunSidecarSpecBuilder item : this.sidecarSpecs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
        for (TaskRunSidecarSpecBuilder item : this.sidecarSpecs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSidecarSpecs(List<TaskRunSidecarSpec> sidecarSpecs) {
        if (this.sidecarSpecs != null) {
            this._visitables.get((Object)"sidecarSpecs").clear();
        }
        if (sidecarSpecs != null) {
            this.sidecarSpecs = new ArrayList();
            for (TaskRunSidecarSpec item : sidecarSpecs) {
                this.addToSidecarSpecs(item);
            }
        } else {
            this.sidecarSpecs = null;
        }
        return (A)((Object)this);
    }

    public A withSidecarSpecs(TaskRunSidecarSpec ... sidecarSpecs) {
        if (this.sidecarSpecs != null) {
            this.sidecarSpecs.clear();
            this._visitables.remove((Object)"sidecarSpecs");
        }
        if (sidecarSpecs != null) {
            for (TaskRunSidecarSpec item : sidecarSpecs) {
                this.addToSidecarSpecs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSidecarSpecs() {
        return this.sidecarSpecs != null && !this.sidecarSpecs.isEmpty();
    }

    public SidecarSpecsNested<A> addNewSidecarSpec() {
        return new SidecarSpecsNested(-1, null);
    }

    public SidecarSpecsNested<A> addNewSidecarSpecLike(TaskRunSidecarSpec item) {
        return new SidecarSpecsNested(-1, item);
    }

    public SidecarSpecsNested<A> setNewSidecarSpecLike(int index, TaskRunSidecarSpec item) {
        return new SidecarSpecsNested(index, item);
    }

    public SidecarSpecsNested<A> editSidecarSpec(int index) {
        if (this.sidecarSpecs.size() <= index) {
            throw new RuntimeException("Can't edit sidecarSpecs. Index exceeds size.");
        }
        return this.setNewSidecarSpecLike(index, this.buildSidecarSpec(index));
    }

    public SidecarSpecsNested<A> editFirstSidecarSpec() {
        if (this.sidecarSpecs.size() == 0) {
            throw new RuntimeException("Can't edit first sidecarSpecs. The list is empty.");
        }
        return this.setNewSidecarSpecLike(0, this.buildSidecarSpec(0));
    }

    public SidecarSpecsNested<A> editLastSidecarSpec() {
        int index = this.sidecarSpecs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sidecarSpecs. The list is empty.");
        }
        return this.setNewSidecarSpecLike(index, this.buildSidecarSpec(index));
    }

    public SidecarSpecsNested<A> editMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sidecarSpecs.size(); ++i) {
            if (!predicate.test(this.sidecarSpecs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sidecarSpecs. No match found.");
        }
        return this.setNewSidecarSpecLike(index, this.buildSidecarSpec(index));
    }

    public String getStatus() {
        return this.status;
    }

    public A withStatus(String status) {
        this.status = status;
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public A withStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return (A)((Object)this);
    }

    public boolean hasStatusMessage() {
        return this.statusMessage != null;
    }

    public A addToStepSpecs(int index, TaskRunStepSpec item) {
        if (this.stepSpecs == null) {
            this.stepSpecs = new ArrayList();
        }
        TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
        if (index < 0 || index >= this.stepSpecs.size()) {
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.add(builder);
        } else {
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToStepSpecs(int index, TaskRunStepSpec item) {
        if (this.stepSpecs == null) {
            this.stepSpecs = new ArrayList();
        }
        TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
        if (index < 0 || index >= this.stepSpecs.size()) {
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.add(builder);
        } else {
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToStepSpecs(TaskRunStepSpec ... items) {
        if (this.stepSpecs == null) {
            this.stepSpecs = new ArrayList();
        }
        for (TaskRunStepSpec item : items) {
            TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToStepSpecs(Collection<TaskRunStepSpec> items) {
        if (this.stepSpecs == null) {
            this.stepSpecs = new ArrayList();
        }
        for (TaskRunStepSpec item : items) {
            TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromStepSpecs(TaskRunStepSpec ... items) {
        if (this.stepSpecs == null) {
            return (A)((Object)this);
        }
        for (TaskRunStepSpec item : items) {
            TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
            this._visitables.get((Object)"stepSpecs").remove((Object)builder);
            this.stepSpecs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromStepSpecs(Collection<TaskRunStepSpec> items) {
        if (this.stepSpecs == null) {
            return (A)((Object)this);
        }
        for (TaskRunStepSpec item : items) {
            TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
            this._visitables.get((Object)"stepSpecs").remove((Object)builder);
            this.stepSpecs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromStepSpecs(Predicate<TaskRunStepSpecBuilder> predicate) {
        if (this.stepSpecs == null) {
            return (A)((Object)this);
        }
        Iterator<TaskRunStepSpecBuilder> each = this.stepSpecs.iterator();
        List visitables = this._visitables.get((Object)"stepSpecs");
        while (each.hasNext()) {
            TaskRunStepSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TaskRunStepSpec> buildStepSpecs() {
        return this.stepSpecs != null ? TaskRunSpecFluent.build(this.stepSpecs) : null;
    }

    public TaskRunStepSpec buildStepSpec(int index) {
        return this.stepSpecs.get(index).build();
    }

    public TaskRunStepSpec buildFirstStepSpec() {
        return this.stepSpecs.get(0).build();
    }

    public TaskRunStepSpec buildLastStepSpec() {
        return this.stepSpecs.get(this.stepSpecs.size() - 1).build();
    }

    public TaskRunStepSpec buildMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
        for (TaskRunStepSpecBuilder item : this.stepSpecs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
        for (TaskRunStepSpecBuilder item : this.stepSpecs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withStepSpecs(List<TaskRunStepSpec> stepSpecs) {
        if (this.stepSpecs != null) {
            this._visitables.get((Object)"stepSpecs").clear();
        }
        if (stepSpecs != null) {
            this.stepSpecs = new ArrayList();
            for (TaskRunStepSpec item : stepSpecs) {
                this.addToStepSpecs(item);
            }
        } else {
            this.stepSpecs = null;
        }
        return (A)((Object)this);
    }

    public A withStepSpecs(TaskRunStepSpec ... stepSpecs) {
        if (this.stepSpecs != null) {
            this.stepSpecs.clear();
            this._visitables.remove((Object)"stepSpecs");
        }
        if (stepSpecs != null) {
            for (TaskRunStepSpec item : stepSpecs) {
                this.addToStepSpecs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasStepSpecs() {
        return this.stepSpecs != null && !this.stepSpecs.isEmpty();
    }

    public StepSpecsNested<A> addNewStepSpec() {
        return new StepSpecsNested(-1, null);
    }

    public StepSpecsNested<A> addNewStepSpecLike(TaskRunStepSpec item) {
        return new StepSpecsNested(-1, item);
    }

    public StepSpecsNested<A> setNewStepSpecLike(int index, TaskRunStepSpec item) {
        return new StepSpecsNested(index, item);
    }

    public StepSpecsNested<A> editStepSpec(int index) {
        if (this.stepSpecs.size() <= index) {
            throw new RuntimeException("Can't edit stepSpecs. Index exceeds size.");
        }
        return this.setNewStepSpecLike(index, this.buildStepSpec(index));
    }

    public StepSpecsNested<A> editFirstStepSpec() {
        if (this.stepSpecs.size() == 0) {
            throw new RuntimeException("Can't edit first stepSpecs. The list is empty.");
        }
        return this.setNewStepSpecLike(0, this.buildStepSpec(0));
    }

    public StepSpecsNested<A> editLastStepSpec() {
        int index = this.stepSpecs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last stepSpecs. The list is empty.");
        }
        return this.setNewStepSpecLike(index, this.buildStepSpec(index));
    }

    public StepSpecsNested<A> editMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.stepSpecs.size(); ++i) {
            if (!predicate.test(this.stepSpecs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching stepSpecs. No match found.");
        }
        return this.setNewStepSpecLike(index, this.buildStepSpec(index));
    }

    public TaskRef buildTaskRef() {
        return this.taskRef != null ? this.taskRef.build() : null;
    }

    public A withTaskRef(TaskRef taskRef) {
        this._visitables.remove((Object)"taskRef");
        if (taskRef != null) {
            this.taskRef = new TaskRefBuilder(taskRef);
            this._visitables.get((Object)"taskRef").add(this.taskRef);
        } else {
            this.taskRef = null;
            this._visitables.get((Object)"taskRef").remove((Object)this.taskRef);
        }
        return (A)((Object)this);
    }

    public boolean hasTaskRef() {
        return this.taskRef != null;
    }

    public A withNewTaskRef(String apiVersion, String kind, String name) {
        return this.withTaskRef(new TaskRef(apiVersion, kind, name));
    }

    public TaskRefNested<A> withNewTaskRef() {
        return new TaskRefNested(null);
    }

    public TaskRefNested<A> withNewTaskRefLike(TaskRef item) {
        return new TaskRefNested(item);
    }

    public TaskRefNested<A> editTaskRef() {
        return this.withNewTaskRefLike(Optional.ofNullable(this.buildTaskRef()).orElse(null));
    }

    public TaskRefNested<A> editOrNewTaskRef() {
        return this.withNewTaskRefLike(Optional.ofNullable(this.buildTaskRef()).orElse(new TaskRefBuilder().build()));
    }

    public TaskRefNested<A> editOrNewTaskRefLike(TaskRef item) {
        return this.withNewTaskRefLike(Optional.ofNullable(this.buildTaskRef()).orElse(item));
    }

    public TaskSpec buildTaskSpec() {
        return this.taskSpec != null ? this.taskSpec.build() : null;
    }

    public A withTaskSpec(TaskSpec taskSpec) {
        this._visitables.remove((Object)"taskSpec");
        if (taskSpec != null) {
            this.taskSpec = new TaskSpecBuilder(taskSpec);
            this._visitables.get((Object)"taskSpec").add(this.taskSpec);
        } else {
            this.taskSpec = null;
            this._visitables.get((Object)"taskSpec").remove((Object)this.taskSpec);
        }
        return (A)((Object)this);
    }

    public boolean hasTaskSpec() {
        return this.taskSpec != null;
    }

    public TaskSpecNested<A> withNewTaskSpec() {
        return new TaskSpecNested(null);
    }

    public TaskSpecNested<A> withNewTaskSpecLike(TaskSpec item) {
        return new TaskSpecNested(item);
    }

    public TaskSpecNested<A> editTaskSpec() {
        return this.withNewTaskSpecLike(Optional.ofNullable(this.buildTaskSpec()).orElse(null));
    }

    public TaskSpecNested<A> editOrNewTaskSpec() {
        return this.withNewTaskSpecLike(Optional.ofNullable(this.buildTaskSpec()).orElse(new TaskSpecBuilder().build()));
    }

    public TaskSpecNested<A> editOrNewTaskSpecLike(TaskSpec item) {
        return this.withNewTaskSpecLike(Optional.ofNullable(this.buildTaskSpec()).orElse(item));
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public A withTimeout(Duration timeout) {
        this.timeout = timeout;
        return (A)((Object)this);
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public A addToWorkspaces(int index, WorkspaceBinding item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
        if (index < 0 || index >= this.workspaces.size()) {
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        } else {
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToWorkspaces(int index, WorkspaceBinding item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
        if (index < 0 || index >= this.workspaces.size()) {
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        } else {
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToWorkspaces(WorkspaceBinding ... items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToWorkspaces(Collection<WorkspaceBinding> items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromWorkspaces(WorkspaceBinding ... items) {
        if (this.workspaces == null) {
            return (A)((Object)this);
        }
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").remove((Object)builder);
            this.workspaces.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromWorkspaces(Collection<WorkspaceBinding> items) {
        if (this.workspaces == null) {
            return (A)((Object)this);
        }
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").remove((Object)builder);
            this.workspaces.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromWorkspaces(Predicate<WorkspaceBindingBuilder> predicate) {
        if (this.workspaces == null) {
            return (A)((Object)this);
        }
        Iterator<WorkspaceBindingBuilder> each = this.workspaces.iterator();
        List visitables = this._visitables.get((Object)"workspaces");
        while (each.hasNext()) {
            WorkspaceBindingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<WorkspaceBinding> buildWorkspaces() {
        return this.workspaces != null ? TaskRunSpecFluent.build(this.workspaces) : null;
    }

    public WorkspaceBinding buildWorkspace(int index) {
        return this.workspaces.get(index).build();
    }

    public WorkspaceBinding buildFirstWorkspace() {
        return this.workspaces.get(0).build();
    }

    public WorkspaceBinding buildLastWorkspace() {
        return this.workspaces.get(this.workspaces.size() - 1).build();
    }

    public WorkspaceBinding buildMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
        for (WorkspaceBindingBuilder item : this.workspaces) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
        for (WorkspaceBindingBuilder item : this.workspaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withWorkspaces(List<WorkspaceBinding> workspaces) {
        if (this.workspaces != null) {
            this._visitables.get((Object)"workspaces").clear();
        }
        if (workspaces != null) {
            this.workspaces = new ArrayList();
            for (WorkspaceBinding item : workspaces) {
                this.addToWorkspaces(item);
            }
        } else {
            this.workspaces = null;
        }
        return (A)((Object)this);
    }

    public A withWorkspaces(WorkspaceBinding ... workspaces) {
        if (this.workspaces != null) {
            this.workspaces.clear();
            this._visitables.remove((Object)"workspaces");
        }
        if (workspaces != null) {
            for (WorkspaceBinding item : workspaces) {
                this.addToWorkspaces(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasWorkspaces() {
        return this.workspaces != null && !this.workspaces.isEmpty();
    }

    public WorkspacesNested<A> addNewWorkspace() {
        return new WorkspacesNested(-1, null);
    }

    public WorkspacesNested<A> addNewWorkspaceLike(WorkspaceBinding item) {
        return new WorkspacesNested(-1, item);
    }

    public WorkspacesNested<A> setNewWorkspaceLike(int index, WorkspaceBinding item) {
        return new WorkspacesNested(index, item);
    }

    public WorkspacesNested<A> editWorkspace(int index) {
        if (this.workspaces.size() <= index) {
            throw new RuntimeException("Can't edit workspaces. Index exceeds size.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public WorkspacesNested<A> editFirstWorkspace() {
        if (this.workspaces.size() == 0) {
            throw new RuntimeException("Can't edit first workspaces. The list is empty.");
        }
        return this.setNewWorkspaceLike(0, this.buildWorkspace(0));
    }

    public WorkspacesNested<A> editLastWorkspace() {
        int index = this.workspaces.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last workspaces. The list is empty.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public WorkspacesNested<A> editMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.workspaces.size(); ++i) {
            if (!predicate.test(this.workspaces.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching workspaces. No match found.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskRunSpecFluent that = (TaskRunSpecFluent)((Object)o);
        if (!Objects.equals(this.computeResources, that.computeResources)) {
            return false;
        }
        if (!Objects.equals((Object)this.debug, (Object)that.debug)) {
            return false;
        }
        if (!Objects.equals(this.params, that.params)) {
            return false;
        }
        if (!Objects.equals((Object)this.podTemplate, (Object)that.podTemplate)) {
            return false;
        }
        if (!Objects.equals(this.retries, that.retries)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.sidecarSpecs, that.sidecarSpecs)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        if (!Objects.equals(this.statusMessage, that.statusMessage)) {
            return false;
        }
        if (!Objects.equals(this.stepSpecs, that.stepSpecs)) {
            return false;
        }
        if (!Objects.equals((Object)this.taskRef, (Object)that.taskRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.taskSpec, (Object)that.taskSpec)) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        if (!Objects.equals(this.workspaces, that.workspaces)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.computeResources, this.debug, this.params, this.podTemplate, this.retries, this.serviceAccountName, this.sidecarSpecs, this.status, this.statusMessage, this.stepSpecs, this.taskRef, this.taskSpec, this.timeout, this.workspaces, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeResources != null) {
            sb.append("computeResources:");
            sb.append(String.valueOf(this.computeResources) + ",");
        }
        if (this.debug != null) {
            sb.append("debug:");
            sb.append(String.valueOf((Object)this.debug) + ",");
        }
        if (this.params != null && !this.params.isEmpty()) {
            sb.append("params:");
            sb.append(String.valueOf(this.params) + ",");
        }
        if (this.podTemplate != null) {
            sb.append("podTemplate:");
            sb.append(String.valueOf((Object)this.podTemplate) + ",");
        }
        if (this.retries != null) {
            sb.append("retries:");
            sb.append(this.retries + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.sidecarSpecs != null && !this.sidecarSpecs.isEmpty()) {
            sb.append("sidecarSpecs:");
            sb.append(String.valueOf(this.sidecarSpecs) + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.statusMessage != null) {
            sb.append("statusMessage:");
            sb.append(this.statusMessage + ",");
        }
        if (this.stepSpecs != null && !this.stepSpecs.isEmpty()) {
            sb.append("stepSpecs:");
            sb.append(String.valueOf(this.stepSpecs) + ",");
        }
        if (this.taskRef != null) {
            sb.append("taskRef:");
            sb.append(String.valueOf((Object)this.taskRef) + ",");
        }
        if (this.taskSpec != null) {
            sb.append("taskSpec:");
            sb.append(String.valueOf((Object)this.taskSpec) + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(String.valueOf(this.timeout) + ",");
        }
        if (this.workspaces != null && !this.workspaces.isEmpty()) {
            sb.append("workspaces:");
            sb.append(String.valueOf(this.workspaces) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WorkspacesNested<N>
    extends WorkspaceBindingFluent<WorkspacesNested<N>>
    implements Nested<N> {
        WorkspaceBindingBuilder builder;
        int index;

        WorkspacesNested(int index, WorkspaceBinding item) {
            this.index = index;
            this.builder = new WorkspaceBindingBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunSpecFluent.this.setToWorkspaces(this.index, this.builder.build());
        }

        public N endWorkspace() {
            return this.and();
        }
    }

    public class TaskSpecNested<N>
    extends TaskSpecFluent<TaskSpecNested<N>>
    implements Nested<N> {
        TaskSpecBuilder builder;

        TaskSpecNested(TaskSpec item) {
            this.builder = new TaskSpecBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunSpecFluent.this.withTaskSpec(this.builder.build());
        }

        public N endTaskSpec() {
            return this.and();
        }
    }

    public class TaskRefNested<N>
    extends TaskRefFluent<TaskRefNested<N>>
    implements Nested<N> {
        TaskRefBuilder builder;

        TaskRefNested(TaskRef item) {
            this.builder = new TaskRefBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunSpecFluent.this.withTaskRef(this.builder.build());
        }

        public N endTaskRef() {
            return this.and();
        }
    }

    public class StepSpecsNested<N>
    extends TaskRunStepSpecFluent<StepSpecsNested<N>>
    implements Nested<N> {
        TaskRunStepSpecBuilder builder;
        int index;

        StepSpecsNested(int index, TaskRunStepSpec item) {
            this.index = index;
            this.builder = new TaskRunStepSpecBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunSpecFluent.this.setToStepSpecs(this.index, this.builder.build());
        }

        public N endStepSpec() {
            return this.and();
        }
    }

    public class SidecarSpecsNested<N>
    extends TaskRunSidecarSpecFluent<SidecarSpecsNested<N>>
    implements Nested<N> {
        TaskRunSidecarSpecBuilder builder;
        int index;

        SidecarSpecsNested(int index, TaskRunSidecarSpec item) {
            this.index = index;
            this.builder = new TaskRunSidecarSpecBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunSpecFluent.this.setToSidecarSpecs(this.index, this.builder.build());
        }

        public N endSidecarSpec() {
            return this.and();
        }
    }

    public class PodTemplateNested<N>
    extends TemplateFluent<PodTemplateNested<N>>
    implements Nested<N> {
        TemplateBuilder builder;

        PodTemplateNested(Template item) {
            this.builder = new TemplateBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunSpecFluent.this.withPodTemplate(this.builder.build());
        }

        public N endPodTemplate() {
            return this.and();
        }
    }

    public class ParamsNested<N>
    extends ParamFluent<ParamsNested<N>>
    implements Nested<N> {
        ParamBuilder builder;
        int index;

        ParamsNested(int index, Param item) {
            this.index = index;
            this.builder = new ParamBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunSpecFluent.this.setToParams(this.index, this.builder.build());
        }

        public N endParam() {
            return this.and();
        }
    }

    public class DebugNested<N>
    extends TaskRunDebugFluent<DebugNested<N>>
    implements Nested<N> {
        TaskRunDebugBuilder builder;

        DebugNested(TaskRunDebug item) {
            this.builder = new TaskRunDebugBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunSpecFluent.this.withDebug(this.builder.build());
        }

        public N endDebug() {
            return this.and();
        }
    }

    public class ComputeResourcesNested<N>
    extends ResourceRequirementsFluent<ComputeResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ComputeResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this, item);
        }

        public N and() {
            return (N)TaskRunSpecFluent.this.withComputeResources(this.builder.build());
        }

        public N endComputeResources() {
            return this.and();
        }
    }
}

