package io.fabric8.verticalpodautoscaler.api.model.v1;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class ContainerResourcePolicyFluentImpl<A extends io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicyFluent<A>{
  public ContainerResourcePolicyFluentImpl() {
  }
  public ContainerResourcePolicyFluentImpl(io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicy instance) {
    this.withContainerName(instance.getContainerName()); 
    this.withControlledResources(instance.getControlledResources()); 
    this.withControlledValues(instance.getControlledValues()); 
    this.withMaxAllowed(instance.getMaxAllowed()); 
    this.withMinAllowed(instance.getMinAllowed()); 
    this.withMode(instance.getMode()); 
  }
  private java.lang.String containerName;
  private java.util.List<java.lang.String> controlledResources;
  private java.lang.String controlledValues;
  private java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> maxAllowed;
  private java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> minAllowed;
  private java.lang.String mode;
  public java.lang.String getContainerName() {
    return this.containerName;
  }
  public A withContainerName(java.lang.String containerName) {
    this.containerName=containerName; return (A) this;
  }
  public java.lang.Boolean hasContainerName() {
    return this.containerName != null;
  }
  
  /**
   * Method is deprecated. use withContainerName instead.
   */
  @java.lang.Deprecated
  public A withNewContainerName(java.lang.String arg0) {
    return (A)withContainerName(new String(arg0));
  }
  public A addToControlledResources(java.lang.Integer index,java.lang.String item) {
    if (this.controlledResources == null) {this.controlledResources = new java.util.ArrayList<java.lang.String>();}
    this.controlledResources.add(index, item);
    return (A)this;
  }
  public A setToControlledResources(java.lang.Integer index,java.lang.String item) {
    if (this.controlledResources == null) {this.controlledResources = new java.util.ArrayList<java.lang.String>();}
    this.controlledResources.set(index, item); return (A)this;
  }
  public A addToControlledResources(java.lang.String... items) {
    if (this.controlledResources == null) {this.controlledResources = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.controlledResources.add(item);} return (A)this;
  }
  public A addAllToControlledResources(java.util.Collection<java.lang.String> items) {
    if (this.controlledResources == null) {this.controlledResources = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.controlledResources.add(item);} return (A)this;
  }
  public A removeFromControlledResources(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.controlledResources!= null){ this.controlledResources.remove(item);}} return (A)this;
  }
  public A removeAllFromControlledResources(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.controlledResources!= null){ this.controlledResources.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getControlledResources() {
    return this.controlledResources;
  }
  public java.lang.String getControlledResource(java.lang.Integer index) {
    return this.controlledResources.get(index);
  }
  public java.lang.String getFirstControlledResource() {
    return this.controlledResources.get(0);
  }
  public java.lang.String getLastControlledResource() {
    return this.controlledResources.get(controlledResources.size() - 1);
  }
  public java.lang.String getMatchingControlledResource(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: controlledResources) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingControlledResource(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: controlledResources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withControlledResources(java.util.List<java.lang.String> controlledResources) {
    if (controlledResources != null) {this.controlledResources = new java.util.ArrayList(); for (java.lang.String item : controlledResources){this.addToControlledResources(item);}} else { this.controlledResources = null;} return (A) this;
  }
  public A withControlledResources(java.lang.String... controlledResources) {
    if (this.controlledResources != null) {this.controlledResources.clear();}
    if (controlledResources != null) {for (java.lang.String item :controlledResources){ this.addToControlledResources(item);}} return (A) this;
  }
  public java.lang.Boolean hasControlledResources() {
    return controlledResources != null && !controlledResources.isEmpty();
  }
  public A addNewControlledResource(java.lang.String arg0) {
    return (A)addToControlledResources(new String(arg0));
  }
  public java.lang.String getControlledValues() {
    return this.controlledValues;
  }
  public A withControlledValues(java.lang.String controlledValues) {
    this.controlledValues=controlledValues; return (A) this;
  }
  public java.lang.Boolean hasControlledValues() {
    return this.controlledValues != null;
  }
  
  /**
   * Method is deprecated. use withControlledValues instead.
   */
  @java.lang.Deprecated
  public A withNewControlledValues(java.lang.String arg0) {
    return (A)withControlledValues(new String(arg0));
  }
  public A addToMaxAllowed(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.maxAllowed == null && key != null && value != null) { this.maxAllowed = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.maxAllowed.put(key, value);} return (A)this;
  }
  public A addToMaxAllowed(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.maxAllowed == null && map != null) { this.maxAllowed = new java.util.LinkedHashMap(); }
    if(map != null) { this.maxAllowed.putAll(map);} return (A)this;
  }
  public A removeFromMaxAllowed(java.lang.String key) {
    if(this.maxAllowed == null) { return (A) this; }
    if(key != null && this.maxAllowed != null) {this.maxAllowed.remove(key);} return (A)this;
  }
  public A removeFromMaxAllowed(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.maxAllowed == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.maxAllowed != null){this.maxAllowed.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getMaxAllowed() {
    return this.maxAllowed;
  }
  public <K,V>A withMaxAllowed(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> maxAllowed) {
    if (maxAllowed == null) { this.maxAllowed =  null;} else {this.maxAllowed = new java.util.LinkedHashMap(maxAllowed);} return (A) this;
  }
  public java.lang.Boolean hasMaxAllowed() {
    return this.maxAllowed != null;
  }
  public A addToMinAllowed(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.minAllowed == null && key != null && value != null) { this.minAllowed = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.minAllowed.put(key, value);} return (A)this;
  }
  public A addToMinAllowed(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.minAllowed == null && map != null) { this.minAllowed = new java.util.LinkedHashMap(); }
    if(map != null) { this.minAllowed.putAll(map);} return (A)this;
  }
  public A removeFromMinAllowed(java.lang.String key) {
    if(this.minAllowed == null) { return (A) this; }
    if(key != null && this.minAllowed != null) {this.minAllowed.remove(key);} return (A)this;
  }
  public A removeFromMinAllowed(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.minAllowed == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.minAllowed != null){this.minAllowed.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getMinAllowed() {
    return this.minAllowed;
  }
  public <K,V>A withMinAllowed(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> minAllowed) {
    if (minAllowed == null) { this.minAllowed =  null;} else {this.minAllowed = new java.util.LinkedHashMap(minAllowed);} return (A) this;
  }
  public java.lang.Boolean hasMinAllowed() {
    return this.minAllowed != null;
  }
  public java.lang.String getMode() {
    return this.mode;
  }
  public A withMode(java.lang.String mode) {
    this.mode=mode; return (A) this;
  }
  public java.lang.Boolean hasMode() {
    return this.mode != null;
  }
  
  /**
   * Method is deprecated. use withMode instead.
   */
  @java.lang.Deprecated
  public A withNewMode(java.lang.String arg0) {
    return (A)withMode(new String(arg0));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ContainerResourcePolicyFluentImpl that = (ContainerResourcePolicyFluentImpl) o;
    if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
    if (controlledResources != null ? !controlledResources.equals(that.controlledResources) :that.controlledResources != null) return false;
    if (controlledValues != null ? !controlledValues.equals(that.controlledValues) :that.controlledValues != null) return false;
    if (maxAllowed != null ? !maxAllowed.equals(that.maxAllowed) :that.maxAllowed != null) return false;
    if (minAllowed != null ? !minAllowed.equals(that.minAllowed) :that.minAllowed != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(containerName,  controlledResources,  controlledValues,  maxAllowed,  minAllowed,  mode,  super.hashCode());
  }
  
}