package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RecommendedPodResourcesFluent<A extends RecommendedPodResourcesFluent<A>> extends BaseFluent<A>{
  public RecommendedPodResourcesFluent() {
  }
  
  public RecommendedPodResourcesFluent(RecommendedPodResources instance) {
    this.copyInstance(instance);
  }
  private ArrayList<RecommendedContainerResourcesBuilder> containerRecommendations = new ArrayList<RecommendedContainerResourcesBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RecommendedPodResources instance) {
    instance = (instance != null ? instance : new RecommendedPodResources());
    if (instance != null) {
          this.withContainerRecommendations(instance.getContainerRecommendations());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToContainerRecommendations(int index,RecommendedContainerResources item) {
    if (this.containerRecommendations == null) {this.containerRecommendations = new ArrayList<RecommendedContainerResourcesBuilder>();}
    RecommendedContainerResourcesBuilder builder = new RecommendedContainerResourcesBuilder(item);
    if (index < 0 || index >= containerRecommendations.size()) { _visitables.get("containerRecommendations").add(builder); containerRecommendations.add(builder); } else { _visitables.get("containerRecommendations").add(index, builder); containerRecommendations.add(index, builder);}
    return (A)this;
  }
  
  public A setToContainerRecommendations(int index,RecommendedContainerResources item) {
    if (this.containerRecommendations == null) {this.containerRecommendations = new ArrayList<RecommendedContainerResourcesBuilder>();}
    RecommendedContainerResourcesBuilder builder = new RecommendedContainerResourcesBuilder(item);
    if (index < 0 || index >= containerRecommendations.size()) { _visitables.get("containerRecommendations").add(builder); containerRecommendations.add(builder); } else { _visitables.get("containerRecommendations").set(index, builder); containerRecommendations.set(index, builder);}
    return (A)this;
  }
  
  public A addToContainerRecommendations(io.fabric8.verticalpodautoscaler.api.model.v1.RecommendedContainerResources... items) {
    if (this.containerRecommendations == null) {this.containerRecommendations = new ArrayList<RecommendedContainerResourcesBuilder>();}
    for (RecommendedContainerResources item : items) {RecommendedContainerResourcesBuilder builder = new RecommendedContainerResourcesBuilder(item);_visitables.get("containerRecommendations").add(builder);this.containerRecommendations.add(builder);} return (A)this;
  }
  
  public A addAllToContainerRecommendations(Collection<RecommendedContainerResources> items) {
    if (this.containerRecommendations == null) {this.containerRecommendations = new ArrayList<RecommendedContainerResourcesBuilder>();}
    for (RecommendedContainerResources item : items) {RecommendedContainerResourcesBuilder builder = new RecommendedContainerResourcesBuilder(item);_visitables.get("containerRecommendations").add(builder);this.containerRecommendations.add(builder);} return (A)this;
  }
  
  public A removeFromContainerRecommendations(io.fabric8.verticalpodautoscaler.api.model.v1.RecommendedContainerResources... items) {
    if (this.containerRecommendations == null) return (A)this;
    for (RecommendedContainerResources item : items) {RecommendedContainerResourcesBuilder builder = new RecommendedContainerResourcesBuilder(item);_visitables.get("containerRecommendations").remove(builder); this.containerRecommendations.remove(builder);} return (A)this;
  }
  
  public A removeAllFromContainerRecommendations(Collection<RecommendedContainerResources> items) {
    if (this.containerRecommendations == null) return (A)this;
    for (RecommendedContainerResources item : items) {RecommendedContainerResourcesBuilder builder = new RecommendedContainerResourcesBuilder(item);_visitables.get("containerRecommendations").remove(builder); this.containerRecommendations.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromContainerRecommendations(Predicate<RecommendedContainerResourcesBuilder> predicate) {
    if (containerRecommendations == null) return (A) this;
    final Iterator<RecommendedContainerResourcesBuilder> each = containerRecommendations.iterator();
    final List visitables = _visitables.get("containerRecommendations");
    while (each.hasNext()) {
      RecommendedContainerResourcesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RecommendedContainerResources> buildContainerRecommendations() {
    return this.containerRecommendations != null ? build(containerRecommendations) : null;
  }
  
  public RecommendedContainerResources buildContainerRecommendation(int index) {
    return this.containerRecommendations.get(index).build();
  }
  
  public RecommendedContainerResources buildFirstContainerRecommendation() {
    return this.containerRecommendations.get(0).build();
  }
  
  public RecommendedContainerResources buildLastContainerRecommendation() {
    return this.containerRecommendations.get(containerRecommendations.size() - 1).build();
  }
  
  public RecommendedContainerResources buildMatchingContainerRecommendation(Predicate<RecommendedContainerResourcesBuilder> predicate) {
      for (RecommendedContainerResourcesBuilder item : containerRecommendations) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingContainerRecommendation(Predicate<RecommendedContainerResourcesBuilder> predicate) {
      for (RecommendedContainerResourcesBuilder item : containerRecommendations) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withContainerRecommendations(List<RecommendedContainerResources> containerRecommendations) {
    if (this.containerRecommendations != null) {
      this._visitables.get("containerRecommendations").clear();
    }
    if (containerRecommendations != null) {
        this.containerRecommendations = new ArrayList();
        for (RecommendedContainerResources item : containerRecommendations) {
          this.addToContainerRecommendations(item);
        }
    } else {
      this.containerRecommendations = null;
    }
    return (A) this;
  }
  
  public A withContainerRecommendations(io.fabric8.verticalpodautoscaler.api.model.v1.RecommendedContainerResources... containerRecommendations) {
    if (this.containerRecommendations != null) {
        this.containerRecommendations.clear();
        _visitables.remove("containerRecommendations");
    }
    if (containerRecommendations != null) {
      for (RecommendedContainerResources item : containerRecommendations) {
        this.addToContainerRecommendations(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasContainerRecommendations() {
    return this.containerRecommendations != null && !this.containerRecommendations.isEmpty();
  }
  
  public ContainerRecommendationsNested<A> addNewContainerRecommendation() {
    return new ContainerRecommendationsNested(-1, null);
  }
  
  public ContainerRecommendationsNested<A> addNewContainerRecommendationLike(RecommendedContainerResources item) {
    return new ContainerRecommendationsNested(-1, item);
  }
  
  public ContainerRecommendationsNested<A> setNewContainerRecommendationLike(int index,RecommendedContainerResources item) {
    return new ContainerRecommendationsNested(index, item);
  }
  
  public ContainerRecommendationsNested<A> editContainerRecommendation(int index) {
    if (containerRecommendations.size() <= index) throw new RuntimeException("Can't edit containerRecommendations. Index exceeds size.");
    return setNewContainerRecommendationLike(index, buildContainerRecommendation(index));
  }
  
  public ContainerRecommendationsNested<A> editFirstContainerRecommendation() {
    if (containerRecommendations.size() == 0) throw new RuntimeException("Can't edit first containerRecommendations. The list is empty.");
    return setNewContainerRecommendationLike(0, buildContainerRecommendation(0));
  }
  
  public ContainerRecommendationsNested<A> editLastContainerRecommendation() {
    int index = containerRecommendations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containerRecommendations. The list is empty.");
    return setNewContainerRecommendationLike(index, buildContainerRecommendation(index));
  }
  
  public ContainerRecommendationsNested<A> editMatchingContainerRecommendation(Predicate<RecommendedContainerResourcesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containerRecommendations.size();i++) { 
    if (predicate.test(containerRecommendations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containerRecommendations. No match found.");
    return setNewContainerRecommendationLike(index, buildContainerRecommendation(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RecommendedPodResourcesFluent that = (RecommendedPodResourcesFluent) o;
    if (!java.util.Objects.equals(containerRecommendations, that.containerRecommendations)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(containerRecommendations,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerRecommendations != null && !containerRecommendations.isEmpty()) { sb.append("containerRecommendations:"); sb.append(containerRecommendations + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ContainerRecommendationsNested<N> extends RecommendedContainerResourcesFluent<ContainerRecommendationsNested<N>> implements Nested<N>{
    ContainerRecommendationsNested(int index,RecommendedContainerResources item) {
      this.index = index;
      this.builder = new RecommendedContainerResourcesBuilder(this, item);
    }
    RecommendedContainerResourcesBuilder builder;
    int index;
    
    public N and() {
      return (N) RecommendedPodResourcesFluent.this.setToContainerRecommendations(index,builder.build());
    }
    
    public N endContainerRecommendation() {
      return and();
    }
    
  
  }

}