/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicy;
import io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicyBuilder;
import io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicyFluent;
import io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodResourcePolicyFluent<A extends PodResourcePolicyFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ContainerResourcePolicyBuilder> containerPolicies = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PodResourcePolicyFluent() {
    }

    public PodResourcePolicyFluent(PodResourcePolicy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodResourcePolicy instance) {
        PodResourcePolicy podResourcePolicy = instance = instance != null ? instance : new PodResourcePolicy();
        if (instance != null) {
            this.withContainerPolicies(instance.getContainerPolicies());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToContainerPolicies(int index, ContainerResourcePolicy item) {
        if (this.containerPolicies == null) {
            this.containerPolicies = new ArrayList();
        }
        ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
        if (index < 0 || index >= this.containerPolicies.size()) {
            this._visitables.get((Object)"containerPolicies").add(builder);
            this.containerPolicies.add(builder);
        } else {
            this._visitables.get((Object)"containerPolicies").add(index, builder);
            this.containerPolicies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToContainerPolicies(int index, ContainerResourcePolicy item) {
        if (this.containerPolicies == null) {
            this.containerPolicies = new ArrayList();
        }
        ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
        if (index < 0 || index >= this.containerPolicies.size()) {
            this._visitables.get((Object)"containerPolicies").add(builder);
            this.containerPolicies.add(builder);
        } else {
            this._visitables.get((Object)"containerPolicies").set(index, builder);
            this.containerPolicies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToContainerPolicies(ContainerResourcePolicy ... items) {
        if (this.containerPolicies == null) {
            this.containerPolicies = new ArrayList();
        }
        for (ContainerResourcePolicy item : items) {
            ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
            this._visitables.get((Object)"containerPolicies").add(builder);
            this.containerPolicies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToContainerPolicies(Collection<ContainerResourcePolicy> items) {
        if (this.containerPolicies == null) {
            this.containerPolicies = new ArrayList();
        }
        for (ContainerResourcePolicy item : items) {
            ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
            this._visitables.get((Object)"containerPolicies").add(builder);
            this.containerPolicies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromContainerPolicies(ContainerResourcePolicy ... items) {
        if (this.containerPolicies == null) {
            return (A)((Object)this);
        }
        for (ContainerResourcePolicy item : items) {
            ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
            this._visitables.get((Object)"containerPolicies").remove((Object)builder);
            this.containerPolicies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromContainerPolicies(Collection<ContainerResourcePolicy> items) {
        if (this.containerPolicies == null) {
            return (A)((Object)this);
        }
        for (ContainerResourcePolicy item : items) {
            ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
            this._visitables.get((Object)"containerPolicies").remove((Object)builder);
            this.containerPolicies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromContainerPolicies(Predicate<ContainerResourcePolicyBuilder> predicate) {
        if (this.containerPolicies == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerResourcePolicyBuilder> each = this.containerPolicies.iterator();
        List visitables = this._visitables.get((Object)"containerPolicies");
        while (each.hasNext()) {
            ContainerResourcePolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ContainerResourcePolicy> buildContainerPolicies() {
        return this.containerPolicies != null ? PodResourcePolicyFluent.build(this.containerPolicies) : null;
    }

    public ContainerResourcePolicy buildContainerPolicy(int index) {
        return this.containerPolicies.get(index).build();
    }

    public ContainerResourcePolicy buildFirstContainerPolicy() {
        return this.containerPolicies.get(0).build();
    }

    public ContainerResourcePolicy buildLastContainerPolicy() {
        return this.containerPolicies.get(this.containerPolicies.size() - 1).build();
    }

    public ContainerResourcePolicy buildMatchingContainerPolicy(Predicate<ContainerResourcePolicyBuilder> predicate) {
        for (ContainerResourcePolicyBuilder item : this.containerPolicies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainerPolicy(Predicate<ContainerResourcePolicyBuilder> predicate) {
        for (ContainerResourcePolicyBuilder item : this.containerPolicies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainerPolicies(List<ContainerResourcePolicy> containerPolicies) {
        if (this.containerPolicies != null) {
            this._visitables.get((Object)"containerPolicies").clear();
        }
        if (containerPolicies != null) {
            this.containerPolicies = new ArrayList();
            for (ContainerResourcePolicy item : containerPolicies) {
                this.addToContainerPolicies(item);
            }
        } else {
            this.containerPolicies = null;
        }
        return (A)((Object)this);
    }

    public A withContainerPolicies(ContainerResourcePolicy ... containerPolicies) {
        if (this.containerPolicies != null) {
            this.containerPolicies.clear();
            this._visitables.remove((Object)"containerPolicies");
        }
        if (containerPolicies != null) {
            for (ContainerResourcePolicy item : containerPolicies) {
                this.addToContainerPolicies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasContainerPolicies() {
        return this.containerPolicies != null && !this.containerPolicies.isEmpty();
    }

    public ContainerPoliciesNested<A> addNewContainerPolicy() {
        return new ContainerPoliciesNested(-1, null);
    }

    public ContainerPoliciesNested<A> addNewContainerPolicyLike(ContainerResourcePolicy item) {
        return new ContainerPoliciesNested(-1, item);
    }

    public ContainerPoliciesNested<A> setNewContainerPolicyLike(int index, ContainerResourcePolicy item) {
        return new ContainerPoliciesNested(index, item);
    }

    public ContainerPoliciesNested<A> editContainerPolicy(int index) {
        if (this.containerPolicies.size() <= index) {
            throw new RuntimeException("Can't edit containerPolicies. Index exceeds size.");
        }
        return this.setNewContainerPolicyLike(index, this.buildContainerPolicy(index));
    }

    public ContainerPoliciesNested<A> editFirstContainerPolicy() {
        if (this.containerPolicies.size() == 0) {
            throw new RuntimeException("Can't edit first containerPolicies. The list is empty.");
        }
        return this.setNewContainerPolicyLike(0, this.buildContainerPolicy(0));
    }

    public ContainerPoliciesNested<A> editLastContainerPolicy() {
        int index = this.containerPolicies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerPolicies. The list is empty.");
        }
        return this.setNewContainerPolicyLike(index, this.buildContainerPolicy(index));
    }

    public ContainerPoliciesNested<A> editMatchingContainerPolicy(Predicate<ContainerResourcePolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerPolicies.size(); ++i) {
            if (!predicate.test(this.containerPolicies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerPolicies. No match found.");
        }
        return this.setNewContainerPolicyLike(index, this.buildContainerPolicy(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodResourcePolicyFluent that = (PodResourcePolicyFluent)((Object)o);
        if (!Objects.equals(this.containerPolicies, that.containerPolicies)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.containerPolicies, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerPolicies != null && !this.containerPolicies.isEmpty()) {
            sb.append("containerPolicies:");
            sb.append(this.containerPolicies + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ContainerPoliciesNested<N>
    extends ContainerResourcePolicyFluent<ContainerPoliciesNested<N>>
    implements Nested<N> {
        ContainerResourcePolicyBuilder builder;
        int index;

        ContainerPoliciesNested(int index, ContainerResourcePolicy item) {
            this.index = index;
            this.builder = new ContainerResourcePolicyBuilder(this, item);
        }

        public N and() {
            return (N)PodResourcePolicyFluent.this.setToContainerPolicies(this.index, this.builder.build());
        }

        public N endContainerPolicy() {
            return this.and();
        }
    }
}

