/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.verticalpodautoscaler.api.model.v1.HistogramCheckpoint;
import io.fabric8.verticalpodautoscaler.api.model.v1.HistogramCheckpointBuilder;
import io.fabric8.verticalpodautoscaler.api.model.v1.HistogramCheckpointFluent;
import io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class VerticalPodAutoscalerCheckpointStatusFluent<A extends VerticalPodAutoscalerCheckpointStatusFluent<A>>
extends BaseFluent<A> {
    private HistogramCheckpointBuilder cpuHistogram;
    private String firstSampleStart;
    private String lastSampleStart;
    private String lastUpdateTime;
    private HistogramCheckpointBuilder memoryHistogram;
    private Integer totalSamplesCount;
    private String version;
    private Map<String, Object> additionalProperties;

    public VerticalPodAutoscalerCheckpointStatusFluent() {
    }

    public VerticalPodAutoscalerCheckpointStatusFluent(VerticalPodAutoscalerCheckpointStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VerticalPodAutoscalerCheckpointStatus instance) {
        VerticalPodAutoscalerCheckpointStatus verticalPodAutoscalerCheckpointStatus = instance = instance != null ? instance : new VerticalPodAutoscalerCheckpointStatus();
        if (instance != null) {
            this.withCpuHistogram(instance.getCpuHistogram());
            this.withFirstSampleStart(instance.getFirstSampleStart());
            this.withLastSampleStart(instance.getLastSampleStart());
            this.withLastUpdateTime(instance.getLastUpdateTime());
            this.withMemoryHistogram(instance.getMemoryHistogram());
            this.withTotalSamplesCount(instance.getTotalSamplesCount());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public HistogramCheckpoint buildCpuHistogram() {
        return this.cpuHistogram != null ? this.cpuHistogram.build() : null;
    }

    public A withCpuHistogram(HistogramCheckpoint cpuHistogram) {
        this._visitables.remove((Object)"cpuHistogram");
        if (cpuHistogram != null) {
            this.cpuHistogram = new HistogramCheckpointBuilder(cpuHistogram);
            this._visitables.get((Object)"cpuHistogram").add(this.cpuHistogram);
        } else {
            this.cpuHistogram = null;
            this._visitables.get((Object)"cpuHistogram").remove((Object)this.cpuHistogram);
        }
        return (A)((Object)this);
    }

    public boolean hasCpuHistogram() {
        return this.cpuHistogram != null;
    }

    public CpuHistogramNested<A> withNewCpuHistogram() {
        return new CpuHistogramNested(null);
    }

    public CpuHistogramNested<A> withNewCpuHistogramLike(HistogramCheckpoint item) {
        return new CpuHistogramNested(item);
    }

    public CpuHistogramNested<A> editCpuHistogram() {
        return this.withNewCpuHistogramLike(Optional.ofNullable(this.buildCpuHistogram()).orElse(null));
    }

    public CpuHistogramNested<A> editOrNewCpuHistogram() {
        return this.withNewCpuHistogramLike(Optional.ofNullable(this.buildCpuHistogram()).orElse(new HistogramCheckpointBuilder().build()));
    }

    public CpuHistogramNested<A> editOrNewCpuHistogramLike(HistogramCheckpoint item) {
        return this.withNewCpuHistogramLike(Optional.ofNullable(this.buildCpuHistogram()).orElse(item));
    }

    public String getFirstSampleStart() {
        return this.firstSampleStart;
    }

    public A withFirstSampleStart(String firstSampleStart) {
        this.firstSampleStart = firstSampleStart;
        return (A)((Object)this);
    }

    public boolean hasFirstSampleStart() {
        return this.firstSampleStart != null;
    }

    public String getLastSampleStart() {
        return this.lastSampleStart;
    }

    public A withLastSampleStart(String lastSampleStart) {
        this.lastSampleStart = lastSampleStart;
        return (A)((Object)this);
    }

    public boolean hasLastSampleStart() {
        return this.lastSampleStart != null;
    }

    public String getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public A withLastUpdateTime(String lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return (A)((Object)this);
    }

    public boolean hasLastUpdateTime() {
        return this.lastUpdateTime != null;
    }

    public HistogramCheckpoint buildMemoryHistogram() {
        return this.memoryHistogram != null ? this.memoryHistogram.build() : null;
    }

    public A withMemoryHistogram(HistogramCheckpoint memoryHistogram) {
        this._visitables.remove((Object)"memoryHistogram");
        if (memoryHistogram != null) {
            this.memoryHistogram = new HistogramCheckpointBuilder(memoryHistogram);
            this._visitables.get((Object)"memoryHistogram").add(this.memoryHistogram);
        } else {
            this.memoryHistogram = null;
            this._visitables.get((Object)"memoryHistogram").remove((Object)this.memoryHistogram);
        }
        return (A)((Object)this);
    }

    public boolean hasMemoryHistogram() {
        return this.memoryHistogram != null;
    }

    public MemoryHistogramNested<A> withNewMemoryHistogram() {
        return new MemoryHistogramNested(null);
    }

    public MemoryHistogramNested<A> withNewMemoryHistogramLike(HistogramCheckpoint item) {
        return new MemoryHistogramNested(item);
    }

    public MemoryHistogramNested<A> editMemoryHistogram() {
        return this.withNewMemoryHistogramLike(Optional.ofNullable(this.buildMemoryHistogram()).orElse(null));
    }

    public MemoryHistogramNested<A> editOrNewMemoryHistogram() {
        return this.withNewMemoryHistogramLike(Optional.ofNullable(this.buildMemoryHistogram()).orElse(new HistogramCheckpointBuilder().build()));
    }

    public MemoryHistogramNested<A> editOrNewMemoryHistogramLike(HistogramCheckpoint item) {
        return this.withNewMemoryHistogramLike(Optional.ofNullable(this.buildMemoryHistogram()).orElse(item));
    }

    public Integer getTotalSamplesCount() {
        return this.totalSamplesCount;
    }

    public A withTotalSamplesCount(Integer totalSamplesCount) {
        this.totalSamplesCount = totalSamplesCount;
        return (A)((Object)this);
    }

    public boolean hasTotalSamplesCount() {
        return this.totalSamplesCount != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VerticalPodAutoscalerCheckpointStatusFluent that = (VerticalPodAutoscalerCheckpointStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.cpuHistogram, (Object)that.cpuHistogram)) {
            return false;
        }
        if (!Objects.equals(this.firstSampleStart, that.firstSampleStart)) {
            return false;
        }
        if (!Objects.equals(this.lastSampleStart, that.lastSampleStart)) {
            return false;
        }
        if (!Objects.equals(this.lastUpdateTime, that.lastUpdateTime)) {
            return false;
        }
        if (!Objects.equals((Object)this.memoryHistogram, (Object)that.memoryHistogram)) {
            return false;
        }
        if (!Objects.equals(this.totalSamplesCount, that.totalSamplesCount)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cpuHistogram, this.firstSampleStart, this.lastSampleStart, this.lastUpdateTime, this.memoryHistogram, this.totalSamplesCount, this.version, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cpuHistogram != null) {
            sb.append("cpuHistogram:");
            sb.append((Object)((Object)this.cpuHistogram) + ",");
        }
        if (this.firstSampleStart != null) {
            sb.append("firstSampleStart:");
            sb.append(this.firstSampleStart + ",");
        }
        if (this.lastSampleStart != null) {
            sb.append("lastSampleStart:");
            sb.append(this.lastSampleStart + ",");
        }
        if (this.lastUpdateTime != null) {
            sb.append("lastUpdateTime:");
            sb.append(this.lastUpdateTime + ",");
        }
        if (this.memoryHistogram != null) {
            sb.append("memoryHistogram:");
            sb.append((Object)((Object)this.memoryHistogram) + ",");
        }
        if (this.totalSamplesCount != null) {
            sb.append("totalSamplesCount:");
            sb.append(this.totalSamplesCount + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MemoryHistogramNested<N>
    extends HistogramCheckpointFluent<MemoryHistogramNested<N>>
    implements Nested<N> {
        HistogramCheckpointBuilder builder;

        MemoryHistogramNested(HistogramCheckpoint item) {
            this.builder = new HistogramCheckpointBuilder(this, item);
        }

        public N and() {
            return (N)VerticalPodAutoscalerCheckpointStatusFluent.this.withMemoryHistogram(this.builder.build());
        }

        public N endMemoryHistogram() {
            return this.and();
        }
    }

    public class CpuHistogramNested<N>
    extends HistogramCheckpointFluent<CpuHistogramNested<N>>
    implements Nested<N> {
        HistogramCheckpointBuilder builder;

        CpuHistogramNested(HistogramCheckpoint item) {
            this.builder = new HistogramCheckpointBuilder(this, item);
        }

        public N and() {
            return (N)VerticalPodAutoscalerCheckpointStatusFluent.this.withCpuHistogram(this.builder.build());
        }

        public N endCpuHistogram() {
            return this.and();
        }
    }
}

