package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodResourcePolicyFluentImpl<A extends PodResourcePolicyFluent<A>> extends BaseFluent<A> implements PodResourcePolicyFluent<A>{
  public PodResourcePolicyFluentImpl() {
  }
  public PodResourcePolicyFluentImpl(PodResourcePolicy instance) {
    this.withContainerPolicies(instance.getContainerPolicies()); 
  }
  private ArrayList<ContainerResourcePolicyBuilder> containerPolicies = new ArrayList<ContainerResourcePolicyBuilder>();
  public A addToContainerPolicies(Integer index,ContainerResourcePolicy item) {
    if (this.containerPolicies == null) {this.containerPolicies = new ArrayList<ContainerResourcePolicyBuilder>();}
    ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);_visitables.get("containerPolicies").add(index >= 0 ? index : _visitables.get("containerPolicies").size(), builder);this.containerPolicies.add(index >= 0 ? index : containerPolicies.size(), builder); return (A)this;
  }
  public A setToContainerPolicies(Integer index,ContainerResourcePolicy item) {
    if (this.containerPolicies == null) {this.containerPolicies = new ArrayList<ContainerResourcePolicyBuilder>();}
    ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);
    if (index < 0 || index >= _visitables.get("containerPolicies").size()) { _visitables.get("containerPolicies").add(builder); } else { _visitables.get("containerPolicies").set(index, builder);}
    if (index < 0 || index >= containerPolicies.size()) { containerPolicies.add(builder); } else { containerPolicies.set(index, builder);}
     return (A)this;
  }
  public A addToContainerPolicies(io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicy... items) {
    if (this.containerPolicies == null) {this.containerPolicies = new ArrayList<ContainerResourcePolicyBuilder>();}
    for (ContainerResourcePolicy item : items) {ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);_visitables.get("containerPolicies").add(builder);this.containerPolicies.add(builder);} return (A)this;
  }
  public A addAllToContainerPolicies(Collection<ContainerResourcePolicy> items) {
    if (this.containerPolicies == null) {this.containerPolicies = new ArrayList<ContainerResourcePolicyBuilder>();}
    for (ContainerResourcePolicy item : items) {ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);_visitables.get("containerPolicies").add(builder);this.containerPolicies.add(builder);} return (A)this;
  }
  public A removeFromContainerPolicies(io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicy... items) {
    for (ContainerResourcePolicy item : items) {ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);_visitables.get("containerPolicies").remove(builder);if (this.containerPolicies != null) {this.containerPolicies.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainerPolicies(Collection<ContainerResourcePolicy> items) {
    for (ContainerResourcePolicy item : items) {ContainerResourcePolicyBuilder builder = new ContainerResourcePolicyBuilder(item);_visitables.get("containerPolicies").remove(builder);if (this.containerPolicies != null) {this.containerPolicies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainerPolicies(Predicate<ContainerResourcePolicyBuilder> predicate) {
    if (containerPolicies == null) return (A) this;
    final Iterator<ContainerResourcePolicyBuilder> each = containerPolicies.iterator();
    final List visitables = _visitables.get("containerPolicies");
    while (each.hasNext()) {
      ContainerResourcePolicyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainerPolicies instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerResourcePolicy> getContainerPolicies() {
    return containerPolicies != null ? build(containerPolicies) : null;
  }
  public List<ContainerResourcePolicy> buildContainerPolicies() {
    return containerPolicies != null ? build(containerPolicies) : null;
  }
  public ContainerResourcePolicy buildContainerPolicy(Integer index) {
    return this.containerPolicies.get(index).build();
  }
  public ContainerResourcePolicy buildFirstContainerPolicy() {
    return this.containerPolicies.get(0).build();
  }
  public ContainerResourcePolicy buildLastContainerPolicy() {
    return this.containerPolicies.get(containerPolicies.size() - 1).build();
  }
  public ContainerResourcePolicy buildMatchingContainerPolicy(Predicate<ContainerResourcePolicyBuilder> predicate) {
    for (ContainerResourcePolicyBuilder item: containerPolicies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingContainerPolicy(Predicate<ContainerResourcePolicyBuilder> predicate) {
    for (ContainerResourcePolicyBuilder item: containerPolicies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerPolicies(List<ContainerResourcePolicy> containerPolicies) {
    if (this.containerPolicies != null) { _visitables.get("containerPolicies").removeAll(this.containerPolicies);}
    if (containerPolicies != null) {this.containerPolicies = new ArrayList(); for (ContainerResourcePolicy item : containerPolicies){this.addToContainerPolicies(item);}} else { this.containerPolicies = null;} return (A) this;
  }
  public A withContainerPolicies(io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicy... containerPolicies) {
    if (this.containerPolicies != null) {this.containerPolicies.clear();}
    if (containerPolicies != null) {for (ContainerResourcePolicy item :containerPolicies){ this.addToContainerPolicies(item);}} return (A) this;
  }
  public Boolean hasContainerPolicies() {
    return containerPolicies != null && !containerPolicies.isEmpty();
  }
  public PodResourcePolicyFluent.ContainerPoliciesNested<A> addNewContainerPolicy() {
    return new PodResourcePolicyFluentImpl.ContainerPoliciesNestedImpl();
  }
  public PodResourcePolicyFluent.ContainerPoliciesNested<A> addNewContainerPolicyLike(ContainerResourcePolicy item) {
    return new PodResourcePolicyFluentImpl.ContainerPoliciesNestedImpl(-1, item);
  }
  public PodResourcePolicyFluent.ContainerPoliciesNested<A> setNewContainerPolicyLike(Integer index,ContainerResourcePolicy item) {
    return new PodResourcePolicyFluentImpl.ContainerPoliciesNestedImpl(index, item);
  }
  public PodResourcePolicyFluent.ContainerPoliciesNested<A> editContainerPolicy(Integer index) {
    if (containerPolicies.size() <= index) throw new RuntimeException("Can't edit containerPolicies. Index exceeds size.");
    return setNewContainerPolicyLike(index, buildContainerPolicy(index));
  }
  public PodResourcePolicyFluent.ContainerPoliciesNested<A> editFirstContainerPolicy() {
    if (containerPolicies.size() == 0) throw new RuntimeException("Can't edit first containerPolicies. The list is empty.");
    return setNewContainerPolicyLike(0, buildContainerPolicy(0));
  }
  public PodResourcePolicyFluent.ContainerPoliciesNested<A> editLastContainerPolicy() {
    int index = containerPolicies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containerPolicies. The list is empty.");
    return setNewContainerPolicyLike(index, buildContainerPolicy(index));
  }
  public PodResourcePolicyFluent.ContainerPoliciesNested<A> editMatchingContainerPolicy(Predicate<ContainerResourcePolicyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containerPolicies.size();i++) { 
    if (predicate.test(containerPolicies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containerPolicies. No match found.");
    return setNewContainerPolicyLike(index, buildContainerPolicy(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodResourcePolicyFluentImpl that = (PodResourcePolicyFluentImpl) o;
    if (containerPolicies != null ? !containerPolicies.equals(that.containerPolicies) :that.containerPolicies != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(containerPolicies,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerPolicies != null && !containerPolicies.isEmpty()) { sb.append("containerPolicies:"); sb.append(containerPolicies); }
    sb.append("}");
    return sb.toString();
  }
  class ContainerPoliciesNestedImpl<N> extends ContainerResourcePolicyFluentImpl<PodResourcePolicyFluent.ContainerPoliciesNested<N>> implements PodResourcePolicyFluent.ContainerPoliciesNested<N>,Nested<N>{
    ContainerPoliciesNestedImpl(Integer index,ContainerResourcePolicy item) {
      this.index = index;
      this.builder = new ContainerResourcePolicyBuilder(this, item);
    }
    ContainerPoliciesNestedImpl() {
      this.index = -1;
      this.builder = new ContainerResourcePolicyBuilder(this);
    }
    ContainerResourcePolicyBuilder builder;
    Integer index;
    public N and() {
      return (N) PodResourcePolicyFluentImpl.this.setToContainerPolicies(index,builder.build());
    }
    public N endContainerPolicy() {
      return and();
    }
    
  }
  
}