package io.fabric8.verticalpodautoscaler.api.model.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VerticalPodAutoscalerCheckpointFluentImpl<A extends VerticalPodAutoscalerCheckpointFluent<A>> extends BaseFluent<A> implements VerticalPodAutoscalerCheckpointFluent<A>{
  public VerticalPodAutoscalerCheckpointFluentImpl() {
  }
  public VerticalPodAutoscalerCheckpointFluentImpl(VerticalPodAutoscalerCheckpoint instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private VerticalPodAutoscalerCheckpointSpecBuilder spec;
  private VerticalPodAutoscalerCheckpointStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public VerticalPodAutoscalerCheckpointFluent.MetadataNested<A> withNewMetadata() {
    return new VerticalPodAutoscalerCheckpointFluentImpl.MetadataNestedImpl();
  }
  public VerticalPodAutoscalerCheckpointFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new VerticalPodAutoscalerCheckpointFluentImpl.MetadataNestedImpl(item);
  }
  public VerticalPodAutoscalerCheckpointFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public VerticalPodAutoscalerCheckpointFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public VerticalPodAutoscalerCheckpointFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public VerticalPodAutoscalerCheckpointSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public VerticalPodAutoscalerCheckpointSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(VerticalPodAutoscalerCheckpointSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new VerticalPodAutoscalerCheckpointSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public A withNewSpec(String containerName,String vpaObjectName) {
    return (A)withSpec(new VerticalPodAutoscalerCheckpointSpec(containerName, vpaObjectName));
  }
  public VerticalPodAutoscalerCheckpointFluent.SpecNested<A> withNewSpec() {
    return new VerticalPodAutoscalerCheckpointFluentImpl.SpecNestedImpl();
  }
  public VerticalPodAutoscalerCheckpointFluent.SpecNested<A> withNewSpecLike(VerticalPodAutoscalerCheckpointSpec item) {
    return new VerticalPodAutoscalerCheckpointFluentImpl.SpecNestedImpl(item);
  }
  public VerticalPodAutoscalerCheckpointFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public VerticalPodAutoscalerCheckpointFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new VerticalPodAutoscalerCheckpointSpecBuilder().build());
  }
  public VerticalPodAutoscalerCheckpointFluent.SpecNested<A> editOrNewSpecLike(VerticalPodAutoscalerCheckpointSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public VerticalPodAutoscalerCheckpointStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public VerticalPodAutoscalerCheckpointStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(VerticalPodAutoscalerCheckpointStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new VerticalPodAutoscalerCheckpointStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public VerticalPodAutoscalerCheckpointFluent.StatusNested<A> withNewStatus() {
    return new VerticalPodAutoscalerCheckpointFluentImpl.StatusNestedImpl();
  }
  public VerticalPodAutoscalerCheckpointFluent.StatusNested<A> withNewStatusLike(VerticalPodAutoscalerCheckpointStatus item) {
    return new VerticalPodAutoscalerCheckpointFluentImpl.StatusNestedImpl(item);
  }
  public VerticalPodAutoscalerCheckpointFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public VerticalPodAutoscalerCheckpointFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new VerticalPodAutoscalerCheckpointStatusBuilder().build());
  }
  public VerticalPodAutoscalerCheckpointFluent.StatusNested<A> editOrNewStatusLike(VerticalPodAutoscalerCheckpointStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VerticalPodAutoscalerCheckpointFluentImpl that = (VerticalPodAutoscalerCheckpointFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<VerticalPodAutoscalerCheckpointFluent.MetadataNested<N>> implements VerticalPodAutoscalerCheckpointFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) VerticalPodAutoscalerCheckpointFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends VerticalPodAutoscalerCheckpointSpecFluentImpl<VerticalPodAutoscalerCheckpointFluent.SpecNested<N>> implements VerticalPodAutoscalerCheckpointFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(VerticalPodAutoscalerCheckpointSpec item) {
      this.builder = new VerticalPodAutoscalerCheckpointSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new VerticalPodAutoscalerCheckpointSpecBuilder(this);
    }
    VerticalPodAutoscalerCheckpointSpecBuilder builder;
    public N and() {
      return (N) VerticalPodAutoscalerCheckpointFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends VerticalPodAutoscalerCheckpointStatusFluentImpl<VerticalPodAutoscalerCheckpointFluent.StatusNested<N>> implements VerticalPodAutoscalerCheckpointFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(VerticalPodAutoscalerCheckpointStatus item) {
      this.builder = new VerticalPodAutoscalerCheckpointStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new VerticalPodAutoscalerCheckpointStatusBuilder(this);
    }
    VerticalPodAutoscalerCheckpointStatusBuilder builder;
    public N and() {
      return (N) VerticalPodAutoscalerCheckpointFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}