package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VerticalPodAutoscalerCheckpointSpecBuilder extends VerticalPodAutoscalerCheckpointSpecFluentImpl<VerticalPodAutoscalerCheckpointSpecBuilder> implements VisitableBuilder<VerticalPodAutoscalerCheckpointSpec,VerticalPodAutoscalerCheckpointSpecBuilder>{
  public VerticalPodAutoscalerCheckpointSpecBuilder() {
    this(false);
  }
  public VerticalPodAutoscalerCheckpointSpecBuilder(Boolean validationEnabled) {
    this(new VerticalPodAutoscalerCheckpointSpec(), validationEnabled);
  }
  public VerticalPodAutoscalerCheckpointSpecBuilder(VerticalPodAutoscalerCheckpointSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public VerticalPodAutoscalerCheckpointSpecBuilder(VerticalPodAutoscalerCheckpointSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VerticalPodAutoscalerCheckpointSpec(), validationEnabled);
  }
  public VerticalPodAutoscalerCheckpointSpecBuilder(VerticalPodAutoscalerCheckpointSpecFluent<?> fluent,VerticalPodAutoscalerCheckpointSpec instance) {
    this(fluent, instance, false);
  }
  public VerticalPodAutoscalerCheckpointSpecBuilder(VerticalPodAutoscalerCheckpointSpecFluent<?> fluent,VerticalPodAutoscalerCheckpointSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainerName(instance.getContainerName()); 
    fluent.withVpaObjectName(instance.getVpaObjectName()); 
    this.validationEnabled = validationEnabled; 
  }
  public VerticalPodAutoscalerCheckpointSpecBuilder(VerticalPodAutoscalerCheckpointSpec instance) {
    this(instance,false);
  }
  public VerticalPodAutoscalerCheckpointSpecBuilder(VerticalPodAutoscalerCheckpointSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainerName(instance.getContainerName()); 
    this.withVpaObjectName(instance.getVpaObjectName()); 
    this.validationEnabled = validationEnabled; 
  }
  VerticalPodAutoscalerCheckpointSpecFluent<?> fluent;
  Boolean validationEnabled;
  public VerticalPodAutoscalerCheckpointSpec build() {
    VerticalPodAutoscalerCheckpointSpec buildable = new VerticalPodAutoscalerCheckpointSpec(fluent.getContainerName(),fluent.getVpaObjectName());
    return buildable;
  }
  
}