package io.fabric8.verticalpodautoscaler.api.model.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ContainerResourcePolicyFluent<A extends ContainerResourcePolicyFluent<A>> extends Fluent<A>{
  public String getContainerName();
  public A withContainerName(String containerName);
  public Boolean hasContainerName();
  public A addToControlledResources(int index,String item);
  public A setToControlledResources(int index,String item);
  public A addToControlledResources(java.lang.String... items);
  public A addAllToControlledResources(Collection<String> items);
  public A removeFromControlledResources(java.lang.String... items);
  public A removeAllFromControlledResources(Collection<String> items);
  public List<String> getControlledResources();
  public String getControlledResource(int index);
  public String getFirstControlledResource();
  public String getLastControlledResource();
  public String getMatchingControlledResource(Predicate<String> predicate);
  public Boolean hasMatchingControlledResource(Predicate<String> predicate);
  public A withControlledResources(List<String> controlledResources);
  public A withControlledResources(java.lang.String... controlledResources);
  public Boolean hasControlledResources();
  public String getControlledValues();
  public A withControlledValues(String controlledValues);
  public Boolean hasControlledValues();
  public A addToMaxAllowed(String key,Quantity value);
  public A addToMaxAllowed(Map<String,Quantity> map);
  public A removeFromMaxAllowed(String key);
  public A removeFromMaxAllowed(Map<String,Quantity> map);
  public Map<String,Quantity> getMaxAllowed();
  public <K,V>A withMaxAllowed(Map<String,Quantity> maxAllowed);
  public Boolean hasMaxAllowed();
  public A addToMinAllowed(String key,Quantity value);
  public A addToMinAllowed(Map<String,Quantity> map);
  public A removeFromMinAllowed(String key);
  public A removeFromMinAllowed(Map<String,Quantity> map);
  public Map<String,Quantity> getMinAllowed();
  public <K,V>A withMinAllowed(Map<String,Quantity> minAllowed);
  public Boolean hasMinAllowed();
  public String getMode();
  public A withMode(String mode);
  public Boolean hasMode();
  
}