package io.fabric8.verticalpodautoscaler.api.model.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VerticalPodAutoscalerSpecFluentImpl<A extends VerticalPodAutoscalerSpecFluent<A>> extends BaseFluent<A> implements VerticalPodAutoscalerSpecFluent<A>{
  public VerticalPodAutoscalerSpecFluentImpl() {
  }
  public VerticalPodAutoscalerSpecFluentImpl(VerticalPodAutoscalerSpec instance) {
    if (instance != null) {
      this.withResourcePolicy(instance.getResourcePolicy());
      this.withTargetRef(instance.getTargetRef());
      this.withUpdatePolicy(instance.getUpdatePolicy());
    }
  }
  private PodResourcePolicyBuilder resourcePolicy;
  private CrossVersionObjectReference targetRef;
  private PodUpdatePolicyBuilder updatePolicy;
  
  /**
   * This method has been deprecated, please use method buildResourcePolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodResourcePolicy getResourcePolicy() {
    return this.resourcePolicy!=null ?this.resourcePolicy.build():null;
  }
  public PodResourcePolicy buildResourcePolicy() {
    return this.resourcePolicy!=null ?this.resourcePolicy.build():null;
  }
  public A withResourcePolicy(PodResourcePolicy resourcePolicy) {
    _visitables.get("resourcePolicy").remove(this.resourcePolicy);
    if (resourcePolicy!=null){ this.resourcePolicy= new PodResourcePolicyBuilder(resourcePolicy); _visitables.get("resourcePolicy").add(this.resourcePolicy);} else { this.resourcePolicy = null; _visitables.get("resourcePolicy").remove(this.resourcePolicy); } return (A) this;
  }
  public Boolean hasResourcePolicy() {
    return this.resourcePolicy != null;
  }
  public VerticalPodAutoscalerSpecFluentImpl.ResourcePolicyNested<A> withNewResourcePolicy() {
    return new VerticalPodAutoscalerSpecFluentImpl.ResourcePolicyNestedImpl();
  }
  public VerticalPodAutoscalerSpecFluentImpl.ResourcePolicyNested<A> withNewResourcePolicyLike(PodResourcePolicy item) {
    return new VerticalPodAutoscalerSpecFluentImpl.ResourcePolicyNestedImpl(item);
  }
  public VerticalPodAutoscalerSpecFluentImpl.ResourcePolicyNested<A> editResourcePolicy() {
    return withNewResourcePolicyLike(getResourcePolicy());
  }
  public VerticalPodAutoscalerSpecFluentImpl.ResourcePolicyNested<A> editOrNewResourcePolicy() {
    return withNewResourcePolicyLike(getResourcePolicy() != null ? getResourcePolicy(): new PodResourcePolicyBuilder().build());
  }
  public VerticalPodAutoscalerSpecFluentImpl.ResourcePolicyNested<A> editOrNewResourcePolicyLike(PodResourcePolicy item) {
    return withNewResourcePolicyLike(getResourcePolicy() != null ? getResourcePolicy(): item);
  }
  public CrossVersionObjectReference getTargetRef() {
    return this.targetRef;
  }
  public A withTargetRef(CrossVersionObjectReference targetRef) {
    this.targetRef=targetRef; return (A) this;
  }
  public Boolean hasTargetRef() {
    return this.targetRef != null;
  }
  public A withNewTargetRef(String apiVersion,String kind,String name) {
    return (A)withTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  
  /**
   * This method has been deprecated, please use method buildUpdatePolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodUpdatePolicy getUpdatePolicy() {
    return this.updatePolicy!=null ?this.updatePolicy.build():null;
  }
  public PodUpdatePolicy buildUpdatePolicy() {
    return this.updatePolicy!=null ?this.updatePolicy.build():null;
  }
  public A withUpdatePolicy(PodUpdatePolicy updatePolicy) {
    _visitables.get("updatePolicy").remove(this.updatePolicy);
    if (updatePolicy!=null){ this.updatePolicy= new PodUpdatePolicyBuilder(updatePolicy); _visitables.get("updatePolicy").add(this.updatePolicy);} else { this.updatePolicy = null; _visitables.get("updatePolicy").remove(this.updatePolicy); } return (A) this;
  }
  public Boolean hasUpdatePolicy() {
    return this.updatePolicy != null;
  }
  public A withNewUpdatePolicy(String updateMode) {
    return (A)withUpdatePolicy(new PodUpdatePolicy(updateMode));
  }
  public VerticalPodAutoscalerSpecFluentImpl.UpdatePolicyNested<A> withNewUpdatePolicy() {
    return new VerticalPodAutoscalerSpecFluentImpl.UpdatePolicyNestedImpl();
  }
  public VerticalPodAutoscalerSpecFluentImpl.UpdatePolicyNested<A> withNewUpdatePolicyLike(PodUpdatePolicy item) {
    return new VerticalPodAutoscalerSpecFluentImpl.UpdatePolicyNestedImpl(item);
  }
  public VerticalPodAutoscalerSpecFluentImpl.UpdatePolicyNested<A> editUpdatePolicy() {
    return withNewUpdatePolicyLike(getUpdatePolicy());
  }
  public VerticalPodAutoscalerSpecFluentImpl.UpdatePolicyNested<A> editOrNewUpdatePolicy() {
    return withNewUpdatePolicyLike(getUpdatePolicy() != null ? getUpdatePolicy(): new PodUpdatePolicyBuilder().build());
  }
  public VerticalPodAutoscalerSpecFluentImpl.UpdatePolicyNested<A> editOrNewUpdatePolicyLike(PodUpdatePolicy item) {
    return withNewUpdatePolicyLike(getUpdatePolicy() != null ? getUpdatePolicy(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VerticalPodAutoscalerSpecFluentImpl that = (VerticalPodAutoscalerSpecFluentImpl) o;
    if (!java.util.Objects.equals(resourcePolicy, that.resourcePolicy)) return false;

    if (!java.util.Objects.equals(targetRef, that.targetRef)) return false;

    if (!java.util.Objects.equals(updatePolicy, that.updatePolicy)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(resourcePolicy,  targetRef,  updatePolicy,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (resourcePolicy != null) { sb.append("resourcePolicy:"); sb.append(resourcePolicy + ","); }
    if (targetRef != null) { sb.append("targetRef:"); sb.append(targetRef + ","); }
    if (updatePolicy != null) { sb.append("updatePolicy:"); sb.append(updatePolicy); }
    sb.append("}");
    return sb.toString();
  }
  class ResourcePolicyNestedImpl<N> extends PodResourcePolicyFluentImpl<VerticalPodAutoscalerSpecFluentImpl.ResourcePolicyNested<N>> implements VerticalPodAutoscalerSpecFluentImpl.ResourcePolicyNested<N>,Nested<N>{
    ResourcePolicyNestedImpl(PodResourcePolicy item) {
      this.builder = new PodResourcePolicyBuilder(this, item);
    }
    ResourcePolicyNestedImpl() {
      this.builder = new PodResourcePolicyBuilder(this);
    }
    PodResourcePolicyBuilder builder;
    public N and() {
      return (N) VerticalPodAutoscalerSpecFluentImpl.this.withResourcePolicy(builder.build());
    }
    public N endResourcePolicy() {
      return and();
    }
    
  }
  class UpdatePolicyNestedImpl<N> extends PodUpdatePolicyFluentImpl<VerticalPodAutoscalerSpecFluentImpl.UpdatePolicyNested<N>> implements VerticalPodAutoscalerSpecFluentImpl.UpdatePolicyNested<N>,Nested<N>{
    UpdatePolicyNestedImpl(PodUpdatePolicy item) {
      this.builder = new PodUpdatePolicyBuilder(this, item);
    }
    UpdatePolicyNestedImpl() {
      this.builder = new PodUpdatePolicyBuilder(this);
    }
    PodUpdatePolicyBuilder builder;
    public N and() {
      return (N) VerticalPodAutoscalerSpecFluentImpl.this.withUpdatePolicy(builder.build());
    }
    public N endUpdatePolicy() {
      return and();
    }
    
  }
  
}