package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VerticalPodAutoscalerStatusBuilder extends VerticalPodAutoscalerStatusFluentImpl<VerticalPodAutoscalerStatusBuilder> implements VisitableBuilder<VerticalPodAutoscalerStatus,VerticalPodAutoscalerStatusBuilder>{
  public VerticalPodAutoscalerStatusBuilder() {
    this(false);
  }
  public VerticalPodAutoscalerStatusBuilder(Boolean validationEnabled) {
    this(new VerticalPodAutoscalerStatus(), validationEnabled);
  }
  public VerticalPodAutoscalerStatusBuilder(VerticalPodAutoscalerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public VerticalPodAutoscalerStatusBuilder(VerticalPodAutoscalerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VerticalPodAutoscalerStatus(), validationEnabled);
  }
  public VerticalPodAutoscalerStatusBuilder(VerticalPodAutoscalerStatusFluent<?> fluent,VerticalPodAutoscalerStatus instance) {
    this(fluent, instance, false);
  }
  public VerticalPodAutoscalerStatusBuilder(VerticalPodAutoscalerStatusFluent<?> fluent,VerticalPodAutoscalerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withRecommendation(instance.getRecommendation());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VerticalPodAutoscalerStatusBuilder(VerticalPodAutoscalerStatus instance) {
    this(instance,false);
  }
  public VerticalPodAutoscalerStatusBuilder(VerticalPodAutoscalerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withRecommendation(instance.getRecommendation());
    }
    this.validationEnabled = validationEnabled; 
  }
  VerticalPodAutoscalerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public VerticalPodAutoscalerStatus build() {
    VerticalPodAutoscalerStatus buildable = new VerticalPodAutoscalerStatus(fluent.getConditions(),fluent.getRecommendation());
    return buildable;
  }
  
}