/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.verticalpodautoscaler.api.model.v1.HistogramCheckpoint;
import io.fabric8.verticalpodautoscaler.api.model.v1.HistogramCheckpointFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class HistogramCheckpointFluentImpl<A extends HistogramCheckpointFluent<A>>
extends BaseFluent<A>
implements HistogramCheckpointFluent<A> {
    private Map<Integer, Long> bucketWeights;
    private String referenceTimestamp;
    private Double totalWeight;

    public HistogramCheckpointFluentImpl() {
    }

    public HistogramCheckpointFluentImpl(HistogramCheckpoint instance) {
        if (instance != null) {
            this.withBucketWeights(instance.getBucketWeights());
            this.withReferenceTimestamp(instance.getReferenceTimestamp());
            this.withTotalWeight(instance.getTotalWeight());
        }
    }

    @Override
    public A addToBucketWeights(Integer key, Long value) {
        if (this.bucketWeights == null && key != null && value != null) {
            this.bucketWeights = new LinkedHashMap<Integer, Long>();
        }
        if (key != null && value != null) {
            this.bucketWeights.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToBucketWeights(Map<Integer, Long> map) {
        if (this.bucketWeights == null && map != null) {
            this.bucketWeights = new LinkedHashMap<Integer, Long>();
        }
        if (map != null) {
            this.bucketWeights.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromBucketWeights(Integer key) {
        if (this.bucketWeights == null) {
            return (A)this;
        }
        if (key != null && this.bucketWeights != null) {
            this.bucketWeights.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromBucketWeights(Map<Integer, Long> map) {
        if (this.bucketWeights == null) {
            return (A)this;
        }
        if (map != null) {
            for (Integer key : map.keySet()) {
                if (this.bucketWeights == null) continue;
                this.bucketWeights.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<Integer, Long> getBucketWeights() {
        return this.bucketWeights;
    }

    @Override
    public <K, V> A withBucketWeights(Map<Integer, Long> bucketWeights) {
        this.bucketWeights = bucketWeights == null ? null : new LinkedHashMap<Integer, Long>(bucketWeights);
        return (A)this;
    }

    @Override
    public Boolean hasBucketWeights() {
        return this.bucketWeights != null;
    }

    @Override
    public String getReferenceTimestamp() {
        return this.referenceTimestamp;
    }

    @Override
    public A withReferenceTimestamp(String referenceTimestamp) {
        this.referenceTimestamp = referenceTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasReferenceTimestamp() {
        return this.referenceTimestamp != null;
    }

    @Override
    public Double getTotalWeight() {
        return this.totalWeight;
    }

    @Override
    public A withTotalWeight(Double totalWeight) {
        this.totalWeight = totalWeight;
        return (A)this;
    }

    @Override
    public Boolean hasTotalWeight() {
        return this.totalWeight != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HistogramCheckpointFluentImpl that = (HistogramCheckpointFluentImpl)o;
        if (!Objects.equals(this.bucketWeights, that.bucketWeights)) {
            return false;
        }
        if (!Objects.equals(this.referenceTimestamp, that.referenceTimestamp)) {
            return false;
        }
        return Objects.equals(this.totalWeight, that.totalWeight);
    }

    public int hashCode() {
        return Objects.hash(this.bucketWeights, this.referenceTimestamp, this.totalWeight, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucketWeights != null && !this.bucketWeights.isEmpty()) {
            sb.append("bucketWeights:");
            sb.append(this.bucketWeights + ",");
        }
        if (this.referenceTimestamp != null) {
            sb.append("referenceTimestamp:");
            sb.append(this.referenceTimestamp + ",");
        }
        if (this.totalWeight != null) {
            sb.append("totalWeight:");
            sb.append(this.totalWeight);
        }
        sb.append("}");
        return sb.toString();
    }
}

