package io.fabric8.verticalpodautoscaler.api.model.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ContainerResourcePolicyFluent<A extends ContainerResourcePolicyFluent<A>> extends BaseFluent<A>{
  public ContainerResourcePolicyFluent() {
  }
  
  public ContainerResourcePolicyFluent(ContainerResourcePolicy instance) {
    this.copyInstance(instance);
  }
  private String containerName;
  private List<String> controlledResources = new ArrayList<String>();
  private String controlledValues;
  private Map<String,Quantity> maxAllowed;
  private Map<String,Quantity> minAllowed;
  private String mode;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ContainerResourcePolicy instance) {
    instance = (instance != null ? instance : new ContainerResourcePolicy());
    if (instance != null) {
          this.withContainerName(instance.getContainerName());
          this.withControlledResources(instance.getControlledResources());
          this.withControlledValues(instance.getControlledValues());
          this.withMaxAllowed(instance.getMaxAllowed());
          this.withMinAllowed(instance.getMinAllowed());
          this.withMode(instance.getMode());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getContainerName() {
    return this.containerName;
  }
  
  public A withContainerName(String containerName) {
    this.containerName = containerName;
    return (A) this;
  }
  
  public boolean hasContainerName() {
    return this.containerName != null;
  }
  
  public A addToControlledResources(int index,String item) {
    if (this.controlledResources == null) {this.controlledResources = new ArrayList<String>();}
    this.controlledResources.add(index, item);
    return (A)this;
  }
  
  public A setToControlledResources(int index,String item) {
    if (this.controlledResources == null) {this.controlledResources = new ArrayList<String>();}
    this.controlledResources.set(index, item); return (A)this;
  }
  
  public A addToControlledResources(java.lang.String... items) {
    if (this.controlledResources == null) {this.controlledResources = new ArrayList<String>();}
    for (String item : items) {this.controlledResources.add(item);} return (A)this;
  }
  
  public A addAllToControlledResources(Collection<String> items) {
    if (this.controlledResources == null) {this.controlledResources = new ArrayList<String>();}
    for (String item : items) {this.controlledResources.add(item);} return (A)this;
  }
  
  public A removeFromControlledResources(java.lang.String... items) {
    if (this.controlledResources == null) return (A)this;
    for (String item : items) { this.controlledResources.remove(item);} return (A)this;
  }
  
  public A removeAllFromControlledResources(Collection<String> items) {
    if (this.controlledResources == null) return (A)this;
    for (String item : items) { this.controlledResources.remove(item);} return (A)this;
  }
  
  public List<String> getControlledResources() {
    return this.controlledResources;
  }
  
  public String getControlledResource(int index) {
    return this.controlledResources.get(index);
  }
  
  public String getFirstControlledResource() {
    return this.controlledResources.get(0);
  }
  
  public String getLastControlledResource() {
    return this.controlledResources.get(controlledResources.size() - 1);
  }
  
  public String getMatchingControlledResource(Predicate<String> predicate) {
      for (String item : controlledResources) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingControlledResource(Predicate<String> predicate) {
      for (String item : controlledResources) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withControlledResources(List<String> controlledResources) {
    if (controlledResources != null) {
        this.controlledResources = new ArrayList();
        for (String item : controlledResources) {
          this.addToControlledResources(item);
        }
    } else {
      this.controlledResources = null;
    }
    return (A) this;
  }
  
  public A withControlledResources(java.lang.String... controlledResources) {
    if (this.controlledResources != null) {
        this.controlledResources.clear();
        _visitables.remove("controlledResources");
    }
    if (controlledResources != null) {
      for (String item : controlledResources) {
        this.addToControlledResources(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasControlledResources() {
    return this.controlledResources != null && !this.controlledResources.isEmpty();
  }
  
  public String getControlledValues() {
    return this.controlledValues;
  }
  
  public A withControlledValues(String controlledValues) {
    this.controlledValues = controlledValues;
    return (A) this;
  }
  
  public boolean hasControlledValues() {
    return this.controlledValues != null;
  }
  
  public A addToMaxAllowed(String key,Quantity value) {
    if(this.maxAllowed == null && key != null && value != null) { this.maxAllowed = new LinkedHashMap(); }
    if(key != null && value != null) {this.maxAllowed.put(key, value);} return (A)this;
  }
  
  public A addToMaxAllowed(Map<String,Quantity> map) {
    if(this.maxAllowed == null && map != null) { this.maxAllowed = new LinkedHashMap(); }
    if(map != null) { this.maxAllowed.putAll(map);} return (A)this;
  }
  
  public A removeFromMaxAllowed(String key) {
    if(this.maxAllowed == null) { return (A) this; }
    if(key != null && this.maxAllowed != null) {this.maxAllowed.remove(key);} return (A)this;
  }
  
  public A removeFromMaxAllowed(Map<String,Quantity> map) {
    if(this.maxAllowed == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.maxAllowed != null){this.maxAllowed.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getMaxAllowed() {
    return this.maxAllowed;
  }
  
  public <K,V>A withMaxAllowed(Map<String,Quantity> maxAllowed) {
    if (maxAllowed == null) {
      this.maxAllowed = null;
    } else {
      this.maxAllowed = new LinkedHashMap(maxAllowed);
    }
    return (A) this;
  }
  
  public boolean hasMaxAllowed() {
    return this.maxAllowed != null;
  }
  
  public A addToMinAllowed(String key,Quantity value) {
    if(this.minAllowed == null && key != null && value != null) { this.minAllowed = new LinkedHashMap(); }
    if(key != null && value != null) {this.minAllowed.put(key, value);} return (A)this;
  }
  
  public A addToMinAllowed(Map<String,Quantity> map) {
    if(this.minAllowed == null && map != null) { this.minAllowed = new LinkedHashMap(); }
    if(map != null) { this.minAllowed.putAll(map);} return (A)this;
  }
  
  public A removeFromMinAllowed(String key) {
    if(this.minAllowed == null) { return (A) this; }
    if(key != null && this.minAllowed != null) {this.minAllowed.remove(key);} return (A)this;
  }
  
  public A removeFromMinAllowed(Map<String,Quantity> map) {
    if(this.minAllowed == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.minAllowed != null){this.minAllowed.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getMinAllowed() {
    return this.minAllowed;
  }
  
  public <K,V>A withMinAllowed(Map<String,Quantity> minAllowed) {
    if (minAllowed == null) {
      this.minAllowed = null;
    } else {
      this.minAllowed = new LinkedHashMap(minAllowed);
    }
    return (A) this;
  }
  
  public boolean hasMinAllowed() {
    return this.minAllowed != null;
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerResourcePolicyFluent that = (ContainerResourcePolicyFluent) o;
    if (!java.util.Objects.equals(containerName, that.containerName)) return false;
    if (!java.util.Objects.equals(controlledResources, that.controlledResources)) return false;
    if (!java.util.Objects.equals(controlledValues, that.controlledValues)) return false;
    if (!java.util.Objects.equals(maxAllowed, that.maxAllowed)) return false;
    if (!java.util.Objects.equals(minAllowed, that.minAllowed)) return false;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(containerName,  controlledResources,  controlledValues,  maxAllowed,  minAllowed,  mode,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerName != null) { sb.append("containerName:"); sb.append(containerName + ","); }
    if (controlledResources != null && !controlledResources.isEmpty()) { sb.append("controlledResources:"); sb.append(controlledResources + ","); }
    if (controlledValues != null) { sb.append("controlledValues:"); sb.append(controlledValues + ","); }
    if (maxAllowed != null && !maxAllowed.isEmpty()) { sb.append("maxAllowed:"); sb.append(maxAllowed + ","); }
    if (minAllowed != null && !minAllowed.isEmpty()) { sb.append("minAllowed:"); sb.append(minAllowed + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}