/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.autoscaling.api.model.v1;

import io.fabric8.autoscaling.api.model.v1.EvictionRequirement;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EvictionRequirementFluent<A extends EvictionRequirementFluent<A>>
extends BaseFluent<A> {
    private String changeRequirement;
    private List<String> resources = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public EvictionRequirementFluent() {
    }

    public EvictionRequirementFluent(EvictionRequirement instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EvictionRequirement instance) {
        EvictionRequirement evictionRequirement = instance = instance != null ? instance : new EvictionRequirement();
        if (instance != null) {
            this.withChangeRequirement(instance.getChangeRequirement());
            this.withResources(instance.getResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getChangeRequirement() {
        return this.changeRequirement;
    }

    public A withChangeRequirement(String changeRequirement) {
        this.changeRequirement = changeRequirement;
        return (A)((Object)this);
    }

    public boolean hasChangeRequirement() {
        return this.changeRequirement != null;
    }

    public A addToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(index, item);
        return (A)((Object)this);
    }

    public A setToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.set(index, item);
        return (A)((Object)this);
    }

    public A addToResources(String ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToResources(Collection<String> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromResources(String ... items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resources.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResources(Collection<String> items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resources.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getResources() {
        return this.resources;
    }

    public String getResource(int index) {
        return this.resources.get(index);
    }

    public String getFirstResource() {
        return this.resources.get(0);
    }

    public String getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    public String getMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResources(List<String> resources) {
        if (resources != null) {
            this.resources = new ArrayList<String>();
            for (String item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)((Object)this);
    }

    public A withResources(String ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove((Object)"resources");
        }
        if (resources != null) {
            for (String item : resources) {
                this.addToResources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EvictionRequirementFluent that = (EvictionRequirementFluent)((Object)o);
        if (!Objects.equals(this.changeRequirement, that.changeRequirement)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.changeRequirement, this.resources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.changeRequirement != null) {
            sb.append("changeRequirement:");
            sb.append(this.changeRequirement + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

