/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.autoscaling.api.model.v1;

import io.fabric8.autoscaling.api.model.v1.PodResourcePolicy;
import io.fabric8.autoscaling.api.model.v1.PodResourcePolicyBuilder;
import io.fabric8.autoscaling.api.model.v1.PodResourcePolicyFluent;
import io.fabric8.autoscaling.api.model.v1.PodUpdatePolicy;
import io.fabric8.autoscaling.api.model.v1.PodUpdatePolicyBuilder;
import io.fabric8.autoscaling.api.model.v1.PodUpdatePolicyFluent;
import io.fabric8.autoscaling.api.model.v1.VerticalPodAutoscalerRecommenderSelector;
import io.fabric8.autoscaling.api.model.v1.VerticalPodAutoscalerRecommenderSelectorBuilder;
import io.fabric8.autoscaling.api.model.v1.VerticalPodAutoscalerRecommenderSelectorFluent;
import io.fabric8.autoscaling.api.model.v1.VerticalPodAutoscalerSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class VerticalPodAutoscalerSpecFluent<A extends VerticalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<VerticalPodAutoscalerRecommenderSelectorBuilder> recommenders = new ArrayList();
    private PodResourcePolicyBuilder resourcePolicy;
    private CrossVersionObjectReference targetRef;
    private PodUpdatePolicyBuilder updatePolicy;
    private Map<String, Object> additionalProperties;

    public VerticalPodAutoscalerSpecFluent() {
    }

    public VerticalPodAutoscalerSpecFluent(VerticalPodAutoscalerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VerticalPodAutoscalerSpec instance) {
        VerticalPodAutoscalerSpec verticalPodAutoscalerSpec = instance = instance != null ? instance : new VerticalPodAutoscalerSpec();
        if (instance != null) {
            this.withRecommenders(instance.getRecommenders());
            this.withResourcePolicy(instance.getResourcePolicy());
            this.withTargetRef(instance.getTargetRef());
            this.withUpdatePolicy(instance.getUpdatePolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToRecommenders(int index, VerticalPodAutoscalerRecommenderSelector item) {
        if (this.recommenders == null) {
            this.recommenders = new ArrayList();
        }
        VerticalPodAutoscalerRecommenderSelectorBuilder builder = new VerticalPodAutoscalerRecommenderSelectorBuilder(item);
        if (index < 0 || index >= this.recommenders.size()) {
            this._visitables.get((Object)"recommenders").add(builder);
            this.recommenders.add(builder);
        } else {
            this._visitables.get((Object)"recommenders").add(index, builder);
            this.recommenders.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRecommenders(int index, VerticalPodAutoscalerRecommenderSelector item) {
        if (this.recommenders == null) {
            this.recommenders = new ArrayList();
        }
        VerticalPodAutoscalerRecommenderSelectorBuilder builder = new VerticalPodAutoscalerRecommenderSelectorBuilder(item);
        if (index < 0 || index >= this.recommenders.size()) {
            this._visitables.get((Object)"recommenders").add(builder);
            this.recommenders.add(builder);
        } else {
            this._visitables.get((Object)"recommenders").set(index, builder);
            this.recommenders.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRecommenders(VerticalPodAutoscalerRecommenderSelector ... items) {
        if (this.recommenders == null) {
            this.recommenders = new ArrayList();
        }
        for (VerticalPodAutoscalerRecommenderSelector item : items) {
            VerticalPodAutoscalerRecommenderSelectorBuilder builder = new VerticalPodAutoscalerRecommenderSelectorBuilder(item);
            this._visitables.get((Object)"recommenders").add(builder);
            this.recommenders.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRecommenders(Collection<VerticalPodAutoscalerRecommenderSelector> items) {
        if (this.recommenders == null) {
            this.recommenders = new ArrayList();
        }
        for (VerticalPodAutoscalerRecommenderSelector item : items) {
            VerticalPodAutoscalerRecommenderSelectorBuilder builder = new VerticalPodAutoscalerRecommenderSelectorBuilder(item);
            this._visitables.get((Object)"recommenders").add(builder);
            this.recommenders.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRecommenders(VerticalPodAutoscalerRecommenderSelector ... items) {
        if (this.recommenders == null) {
            return (A)((Object)this);
        }
        for (VerticalPodAutoscalerRecommenderSelector item : items) {
            VerticalPodAutoscalerRecommenderSelectorBuilder builder = new VerticalPodAutoscalerRecommenderSelectorBuilder(item);
            this._visitables.get((Object)"recommenders").remove((Object)builder);
            this.recommenders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRecommenders(Collection<VerticalPodAutoscalerRecommenderSelector> items) {
        if (this.recommenders == null) {
            return (A)((Object)this);
        }
        for (VerticalPodAutoscalerRecommenderSelector item : items) {
            VerticalPodAutoscalerRecommenderSelectorBuilder builder = new VerticalPodAutoscalerRecommenderSelectorBuilder(item);
            this._visitables.get((Object)"recommenders").remove((Object)builder);
            this.recommenders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRecommenders(Predicate<VerticalPodAutoscalerRecommenderSelectorBuilder> predicate) {
        if (this.recommenders == null) {
            return (A)((Object)this);
        }
        Iterator<VerticalPodAutoscalerRecommenderSelectorBuilder> each = this.recommenders.iterator();
        List visitables = this._visitables.get((Object)"recommenders");
        while (each.hasNext()) {
            VerticalPodAutoscalerRecommenderSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<VerticalPodAutoscalerRecommenderSelector> buildRecommenders() {
        return this.recommenders != null ? VerticalPodAutoscalerSpecFluent.build(this.recommenders) : null;
    }

    public VerticalPodAutoscalerRecommenderSelector buildRecommender(int index) {
        return this.recommenders.get(index).build();
    }

    public VerticalPodAutoscalerRecommenderSelector buildFirstRecommender() {
        return this.recommenders.get(0).build();
    }

    public VerticalPodAutoscalerRecommenderSelector buildLastRecommender() {
        return this.recommenders.get(this.recommenders.size() - 1).build();
    }

    public VerticalPodAutoscalerRecommenderSelector buildMatchingRecommender(Predicate<VerticalPodAutoscalerRecommenderSelectorBuilder> predicate) {
        for (VerticalPodAutoscalerRecommenderSelectorBuilder item : this.recommenders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRecommender(Predicate<VerticalPodAutoscalerRecommenderSelectorBuilder> predicate) {
        for (VerticalPodAutoscalerRecommenderSelectorBuilder item : this.recommenders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRecommenders(List<VerticalPodAutoscalerRecommenderSelector> recommenders) {
        if (this.recommenders != null) {
            this._visitables.get((Object)"recommenders").clear();
        }
        if (recommenders != null) {
            this.recommenders = new ArrayList();
            for (VerticalPodAutoscalerRecommenderSelector item : recommenders) {
                this.addToRecommenders(item);
            }
        } else {
            this.recommenders = null;
        }
        return (A)((Object)this);
    }

    public A withRecommenders(VerticalPodAutoscalerRecommenderSelector ... recommenders) {
        if (this.recommenders != null) {
            this.recommenders.clear();
            this._visitables.remove((Object)"recommenders");
        }
        if (recommenders != null) {
            for (VerticalPodAutoscalerRecommenderSelector item : recommenders) {
                this.addToRecommenders(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRecommenders() {
        return this.recommenders != null && !this.recommenders.isEmpty();
    }

    public A addNewRecommender(String name) {
        return this.addToRecommenders(new VerticalPodAutoscalerRecommenderSelector(name));
    }

    public RecommendersNested<A> addNewRecommender() {
        return new RecommendersNested(-1, null);
    }

    public RecommendersNested<A> addNewRecommenderLike(VerticalPodAutoscalerRecommenderSelector item) {
        return new RecommendersNested(-1, item);
    }

    public RecommendersNested<A> setNewRecommenderLike(int index, VerticalPodAutoscalerRecommenderSelector item) {
        return new RecommendersNested(index, item);
    }

    public RecommendersNested<A> editRecommender(int index) {
        if (this.recommenders.size() <= index) {
            throw new RuntimeException("Can't edit recommenders. Index exceeds size.");
        }
        return this.setNewRecommenderLike(index, this.buildRecommender(index));
    }

    public RecommendersNested<A> editFirstRecommender() {
        if (this.recommenders.size() == 0) {
            throw new RuntimeException("Can't edit first recommenders. The list is empty.");
        }
        return this.setNewRecommenderLike(0, this.buildRecommender(0));
    }

    public RecommendersNested<A> editLastRecommender() {
        int index = this.recommenders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last recommenders. The list is empty.");
        }
        return this.setNewRecommenderLike(index, this.buildRecommender(index));
    }

    public RecommendersNested<A> editMatchingRecommender(Predicate<VerticalPodAutoscalerRecommenderSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.recommenders.size(); ++i) {
            if (!predicate.test(this.recommenders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching recommenders. No match found.");
        }
        return this.setNewRecommenderLike(index, this.buildRecommender(index));
    }

    public PodResourcePolicy buildResourcePolicy() {
        return this.resourcePolicy != null ? this.resourcePolicy.build() : null;
    }

    public A withResourcePolicy(PodResourcePolicy resourcePolicy) {
        this._visitables.remove((Object)"resourcePolicy");
        if (resourcePolicy != null) {
            this.resourcePolicy = new PodResourcePolicyBuilder(resourcePolicy);
            this._visitables.get((Object)"resourcePolicy").add(this.resourcePolicy);
        } else {
            this.resourcePolicy = null;
            this._visitables.get((Object)"resourcePolicy").remove((Object)this.resourcePolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasResourcePolicy() {
        return this.resourcePolicy != null;
    }

    public ResourcePolicyNested<A> withNewResourcePolicy() {
        return new ResourcePolicyNested(null);
    }

    public ResourcePolicyNested<A> withNewResourcePolicyLike(PodResourcePolicy item) {
        return new ResourcePolicyNested(item);
    }

    public ResourcePolicyNested<A> editResourcePolicy() {
        return this.withNewResourcePolicyLike(Optional.ofNullable(this.buildResourcePolicy()).orElse(null));
    }

    public ResourcePolicyNested<A> editOrNewResourcePolicy() {
        return this.withNewResourcePolicyLike(Optional.ofNullable(this.buildResourcePolicy()).orElse(new PodResourcePolicyBuilder().build()));
    }

    public ResourcePolicyNested<A> editOrNewResourcePolicyLike(PodResourcePolicy item) {
        return this.withNewResourcePolicyLike(Optional.ofNullable(this.buildResourcePolicy()).orElse(item));
    }

    public CrossVersionObjectReference getTargetRef() {
        return this.targetRef;
    }

    public A withTargetRef(CrossVersionObjectReference targetRef) {
        this.targetRef = targetRef;
        return (A)((Object)this);
    }

    public boolean hasTargetRef() {
        return this.targetRef != null;
    }

    public A withNewTargetRef(String apiVersion, String kind, String name) {
        return this.withTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public PodUpdatePolicy buildUpdatePolicy() {
        return this.updatePolicy != null ? this.updatePolicy.build() : null;
    }

    public A withUpdatePolicy(PodUpdatePolicy updatePolicy) {
        this._visitables.remove((Object)"updatePolicy");
        if (updatePolicy != null) {
            this.updatePolicy = new PodUpdatePolicyBuilder(updatePolicy);
            this._visitables.get((Object)"updatePolicy").add(this.updatePolicy);
        } else {
            this.updatePolicy = null;
            this._visitables.get((Object)"updatePolicy").remove((Object)this.updatePolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasUpdatePolicy() {
        return this.updatePolicy != null;
    }

    public UpdatePolicyNested<A> withNewUpdatePolicy() {
        return new UpdatePolicyNested(null);
    }

    public UpdatePolicyNested<A> withNewUpdatePolicyLike(PodUpdatePolicy item) {
        return new UpdatePolicyNested(item);
    }

    public UpdatePolicyNested<A> editUpdatePolicy() {
        return this.withNewUpdatePolicyLike(Optional.ofNullable(this.buildUpdatePolicy()).orElse(null));
    }

    public UpdatePolicyNested<A> editOrNewUpdatePolicy() {
        return this.withNewUpdatePolicyLike(Optional.ofNullable(this.buildUpdatePolicy()).orElse(new PodUpdatePolicyBuilder().build()));
    }

    public UpdatePolicyNested<A> editOrNewUpdatePolicyLike(PodUpdatePolicy item) {
        return this.withNewUpdatePolicyLike(Optional.ofNullable(this.buildUpdatePolicy()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VerticalPodAutoscalerSpecFluent that = (VerticalPodAutoscalerSpecFluent)((Object)o);
        if (!Objects.equals(this.recommenders, that.recommenders)) {
            return false;
        }
        if (!Objects.equals((Object)this.resourcePolicy, (Object)that.resourcePolicy)) {
            return false;
        }
        if (!Objects.equals(this.targetRef, that.targetRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.updatePolicy, (Object)that.updatePolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.recommenders, this.resourcePolicy, this.targetRef, this.updatePolicy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.recommenders != null && !this.recommenders.isEmpty()) {
            sb.append("recommenders:");
            sb.append(this.recommenders + ",");
        }
        if (this.resourcePolicy != null) {
            sb.append("resourcePolicy:");
            sb.append(this.resourcePolicy + ",");
        }
        if (this.targetRef != null) {
            sb.append("targetRef:");
            sb.append(this.targetRef + ",");
        }
        if (this.updatePolicy != null) {
            sb.append("updatePolicy:");
            sb.append(this.updatePolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UpdatePolicyNested<N>
    extends PodUpdatePolicyFluent<UpdatePolicyNested<N>>
    implements Nested<N> {
        PodUpdatePolicyBuilder builder;

        UpdatePolicyNested(PodUpdatePolicy item) {
            this.builder = new PodUpdatePolicyBuilder(this, item);
        }

        public N and() {
            return (N)VerticalPodAutoscalerSpecFluent.this.withUpdatePolicy(this.builder.build());
        }

        public N endUpdatePolicy() {
            return this.and();
        }
    }

    public class ResourcePolicyNested<N>
    extends PodResourcePolicyFluent<ResourcePolicyNested<N>>
    implements Nested<N> {
        PodResourcePolicyBuilder builder;

        ResourcePolicyNested(PodResourcePolicy item) {
            this.builder = new PodResourcePolicyBuilder(this, item);
        }

        public N and() {
            return (N)VerticalPodAutoscalerSpecFluent.this.withResourcePolicy(this.builder.build());
        }

        public N endResourcePolicy() {
            return this.and();
        }
    }

    public class RecommendersNested<N>
    extends VerticalPodAutoscalerRecommenderSelectorFluent<RecommendersNested<N>>
    implements Nested<N> {
        VerticalPodAutoscalerRecommenderSelectorBuilder builder;
        int index;

        RecommendersNested(int index, VerticalPodAutoscalerRecommenderSelector item) {
            this.index = index;
            this.builder = new VerticalPodAutoscalerRecommenderSelectorBuilder(this, item);
        }

        public N and() {
            return (N)VerticalPodAutoscalerSpecFluent.this.setToRecommenders(this.index, this.builder.build());
        }

        public N endRecommender() {
            return this.and();
        }
    }
}

