/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.autoscaling.api.model.v1;

import io.fabric8.autoscaling.api.model.v1.HistogramCheckpoint;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class HistogramCheckpointFluent<A extends HistogramCheckpointFluent<A>>
extends BaseFluent<A> {
    private Map<String, Long> bucketWeights;
    private String referenceTimestamp;
    private Double totalWeight;
    private Map<String, Object> additionalProperties;

    public HistogramCheckpointFluent() {
    }

    public HistogramCheckpointFluent(HistogramCheckpoint instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HistogramCheckpoint instance) {
        HistogramCheckpoint histogramCheckpoint = instance = instance != null ? instance : new HistogramCheckpoint();
        if (instance != null) {
            this.withBucketWeights(instance.getBucketWeights());
            this.withReferenceTimestamp(instance.getReferenceTimestamp());
            this.withTotalWeight(instance.getTotalWeight());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBucketWeights(String key, Long value) {
        if (this.bucketWeights == null && key != null && value != null) {
            this.bucketWeights = new LinkedHashMap<String, Long>();
        }
        if (key != null && value != null) {
            this.bucketWeights.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToBucketWeights(Map<String, Long> map) {
        if (this.bucketWeights == null && map != null) {
            this.bucketWeights = new LinkedHashMap<String, Long>();
        }
        if (map != null) {
            this.bucketWeights.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromBucketWeights(String key) {
        if (this.bucketWeights == null) {
            return (A)((Object)this);
        }
        if (key != null && this.bucketWeights != null) {
            this.bucketWeights.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromBucketWeights(Map<String, Long> map) {
        if (this.bucketWeights == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.bucketWeights == null) continue;
                this.bucketWeights.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Long> getBucketWeights() {
        return this.bucketWeights;
    }

    public <K, V> A withBucketWeights(Map<String, Long> bucketWeights) {
        this.bucketWeights = bucketWeights == null ? null : new LinkedHashMap<String, Long>(bucketWeights);
        return (A)((Object)this);
    }

    public boolean hasBucketWeights() {
        return this.bucketWeights != null;
    }

    public String getReferenceTimestamp() {
        return this.referenceTimestamp;
    }

    public A withReferenceTimestamp(String referenceTimestamp) {
        this.referenceTimestamp = referenceTimestamp;
        return (A)((Object)this);
    }

    public boolean hasReferenceTimestamp() {
        return this.referenceTimestamp != null;
    }

    public Double getTotalWeight() {
        return this.totalWeight;
    }

    public A withTotalWeight(Double totalWeight) {
        this.totalWeight = totalWeight;
        return (A)((Object)this);
    }

    public boolean hasTotalWeight() {
        return this.totalWeight != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HistogramCheckpointFluent that = (HistogramCheckpointFluent)((Object)o);
        if (!Objects.equals(this.bucketWeights, that.bucketWeights)) {
            return false;
        }
        if (!Objects.equals(this.referenceTimestamp, that.referenceTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.totalWeight, that.totalWeight)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.bucketWeights, this.referenceTimestamp, this.totalWeight, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucketWeights != null && !this.bucketWeights.isEmpty()) {
            sb.append("bucketWeights:");
            sb.append(String.valueOf(this.bucketWeights) + ",");
        }
        if (this.referenceTimestamp != null) {
            sb.append("referenceTimestamp:");
            sb.append(this.referenceTimestamp + ",");
        }
        if (this.totalWeight != null) {
            sb.append("totalWeight:");
            sb.append(this.totalWeight + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

