/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.autoscaling.api.model.v1;

import io.fabric8.autoscaling.api.model.v1.EvictionRequirement;
import io.fabric8.autoscaling.api.model.v1.EvictionRequirementBuilder;
import io.fabric8.autoscaling.api.model.v1.EvictionRequirementFluent;
import io.fabric8.autoscaling.api.model.v1.PodUpdatePolicy;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodUpdatePolicyFluent<A extends PodUpdatePolicyFluent<A>>
extends BaseFluent<A> {
    private ArrayList<EvictionRequirementBuilder> evictionRequirements = new ArrayList();
    private Integer minReplicas;
    private String updateMode;
    private Map<String, Object> additionalProperties;

    public PodUpdatePolicyFluent() {
    }

    public PodUpdatePolicyFluent(PodUpdatePolicy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodUpdatePolicy instance) {
        PodUpdatePolicy podUpdatePolicy = instance = instance != null ? instance : new PodUpdatePolicy();
        if (instance != null) {
            this.withEvictionRequirements(instance.getEvictionRequirements());
            this.withMinReplicas(instance.getMinReplicas());
            this.withUpdateMode(instance.getUpdateMode());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToEvictionRequirements(int index, EvictionRequirement item) {
        if (this.evictionRequirements == null) {
            this.evictionRequirements = new ArrayList();
        }
        EvictionRequirementBuilder builder = new EvictionRequirementBuilder(item);
        if (index < 0 || index >= this.evictionRequirements.size()) {
            this._visitables.get((Object)"evictionRequirements").add(builder);
            this.evictionRequirements.add(builder);
        } else {
            this._visitables.get((Object)"evictionRequirements").add(builder);
            this.evictionRequirements.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEvictionRequirements(int index, EvictionRequirement item) {
        if (this.evictionRequirements == null) {
            this.evictionRequirements = new ArrayList();
        }
        EvictionRequirementBuilder builder = new EvictionRequirementBuilder(item);
        if (index < 0 || index >= this.evictionRequirements.size()) {
            this._visitables.get((Object)"evictionRequirements").add(builder);
            this.evictionRequirements.add(builder);
        } else {
            this._visitables.get((Object)"evictionRequirements").add(builder);
            this.evictionRequirements.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEvictionRequirements(EvictionRequirement ... items) {
        if (this.evictionRequirements == null) {
            this.evictionRequirements = new ArrayList();
        }
        for (EvictionRequirement item : items) {
            EvictionRequirementBuilder builder = new EvictionRequirementBuilder(item);
            this._visitables.get((Object)"evictionRequirements").add(builder);
            this.evictionRequirements.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEvictionRequirements(Collection<EvictionRequirement> items) {
        if (this.evictionRequirements == null) {
            this.evictionRequirements = new ArrayList();
        }
        for (EvictionRequirement item : items) {
            EvictionRequirementBuilder builder = new EvictionRequirementBuilder(item);
            this._visitables.get((Object)"evictionRequirements").add(builder);
            this.evictionRequirements.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEvictionRequirements(EvictionRequirement ... items) {
        if (this.evictionRequirements == null) {
            return (A)((Object)this);
        }
        for (EvictionRequirement item : items) {
            EvictionRequirementBuilder builder = new EvictionRequirementBuilder(item);
            this._visitables.get((Object)"evictionRequirements").remove((Object)builder);
            this.evictionRequirements.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEvictionRequirements(Collection<EvictionRequirement> items) {
        if (this.evictionRequirements == null) {
            return (A)((Object)this);
        }
        for (EvictionRequirement item : items) {
            EvictionRequirementBuilder builder = new EvictionRequirementBuilder(item);
            this._visitables.get((Object)"evictionRequirements").remove((Object)builder);
            this.evictionRequirements.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEvictionRequirements(Predicate<EvictionRequirementBuilder> predicate) {
        if (this.evictionRequirements == null) {
            return (A)((Object)this);
        }
        Iterator<EvictionRequirementBuilder> each = this.evictionRequirements.iterator();
        List visitables = this._visitables.get((Object)"evictionRequirements");
        while (each.hasNext()) {
            EvictionRequirementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EvictionRequirement> buildEvictionRequirements() {
        return this.evictionRequirements != null ? PodUpdatePolicyFluent.build(this.evictionRequirements) : null;
    }

    public EvictionRequirement buildEvictionRequirement(int index) {
        return this.evictionRequirements.get(index).build();
    }

    public EvictionRequirement buildFirstEvictionRequirement() {
        return this.evictionRequirements.get(0).build();
    }

    public EvictionRequirement buildLastEvictionRequirement() {
        return this.evictionRequirements.get(this.evictionRequirements.size() - 1).build();
    }

    public EvictionRequirement buildMatchingEvictionRequirement(Predicate<EvictionRequirementBuilder> predicate) {
        for (EvictionRequirementBuilder item : this.evictionRequirements) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEvictionRequirement(Predicate<EvictionRequirementBuilder> predicate) {
        for (EvictionRequirementBuilder item : this.evictionRequirements) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEvictionRequirements(List<EvictionRequirement> evictionRequirements) {
        if (this.evictionRequirements != null) {
            this._visitables.get((Object)"evictionRequirements").clear();
        }
        if (evictionRequirements != null) {
            this.evictionRequirements = new ArrayList();
            for (EvictionRequirement item : evictionRequirements) {
                this.addToEvictionRequirements(item);
            }
        } else {
            this.evictionRequirements = null;
        }
        return (A)((Object)this);
    }

    public A withEvictionRequirements(EvictionRequirement ... evictionRequirements) {
        if (this.evictionRequirements != null) {
            this.evictionRequirements.clear();
            this._visitables.remove((Object)"evictionRequirements");
        }
        if (evictionRequirements != null) {
            for (EvictionRequirement item : evictionRequirements) {
                this.addToEvictionRequirements(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEvictionRequirements() {
        return this.evictionRequirements != null && !this.evictionRequirements.isEmpty();
    }

    public EvictionRequirementsNested<A> addNewEvictionRequirement() {
        return new EvictionRequirementsNested(-1, null);
    }

    public EvictionRequirementsNested<A> addNewEvictionRequirementLike(EvictionRequirement item) {
        return new EvictionRequirementsNested(-1, item);
    }

    public EvictionRequirementsNested<A> setNewEvictionRequirementLike(int index, EvictionRequirement item) {
        return new EvictionRequirementsNested(index, item);
    }

    public EvictionRequirementsNested<A> editEvictionRequirement(int index) {
        if (this.evictionRequirements.size() <= index) {
            throw new RuntimeException("Can't edit evictionRequirements. Index exceeds size.");
        }
        return this.setNewEvictionRequirementLike(index, this.buildEvictionRequirement(index));
    }

    public EvictionRequirementsNested<A> editFirstEvictionRequirement() {
        if (this.evictionRequirements.size() == 0) {
            throw new RuntimeException("Can't edit first evictionRequirements. The list is empty.");
        }
        return this.setNewEvictionRequirementLike(0, this.buildEvictionRequirement(0));
    }

    public EvictionRequirementsNested<A> editLastEvictionRequirement() {
        int index = this.evictionRequirements.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last evictionRequirements. The list is empty.");
        }
        return this.setNewEvictionRequirementLike(index, this.buildEvictionRequirement(index));
    }

    public EvictionRequirementsNested<A> editMatchingEvictionRequirement(Predicate<EvictionRequirementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.evictionRequirements.size(); ++i) {
            if (!predicate.test(this.evictionRequirements.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching evictionRequirements. No match found.");
        }
        return this.setNewEvictionRequirementLike(index, this.buildEvictionRequirement(index));
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)((Object)this);
    }

    public boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    public String getUpdateMode() {
        return this.updateMode;
    }

    public A withUpdateMode(String updateMode) {
        this.updateMode = updateMode;
        return (A)((Object)this);
    }

    public boolean hasUpdateMode() {
        return this.updateMode != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodUpdatePolicyFluent that = (PodUpdatePolicyFluent)((Object)o);
        if (!Objects.equals(this.evictionRequirements, that.evictionRequirements)) {
            return false;
        }
        if (!Objects.equals(this.minReplicas, that.minReplicas)) {
            return false;
        }
        if (!Objects.equals(this.updateMode, that.updateMode)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.evictionRequirements, this.minReplicas, this.updateMode, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.evictionRequirements != null && !this.evictionRequirements.isEmpty()) {
            sb.append("evictionRequirements:");
            sb.append(String.valueOf(this.evictionRequirements) + ",");
        }
        if (this.minReplicas != null) {
            sb.append("minReplicas:");
            sb.append(this.minReplicas + ",");
        }
        if (this.updateMode != null) {
            sb.append("updateMode:");
            sb.append(this.updateMode + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EvictionRequirementsNested<N>
    extends EvictionRequirementFluent<EvictionRequirementsNested<N>>
    implements Nested<N> {
        EvictionRequirementBuilder builder;
        int index;

        EvictionRequirementsNested(int index, EvictionRequirement item) {
            this.index = index;
            this.builder = new EvictionRequirementBuilder(this, item);
        }

        public N and() {
            return (N)PodUpdatePolicyFluent.this.setToEvictionRequirements(this.index, this.builder.build());
        }

        public N endEvictionRequirement() {
            return this.and();
        }
    }
}

