/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.components.impl;

import io.fabric8.vertx.maven.plugin.components.ManifestCustomizerService;
import io.fabric8.vertx.maven.plugin.model.ExtraManifestKeys;
import io.fabric8.vertx.maven.plugin.mojos.PackageMojo;
import io.fabric8.vertx.maven.plugin.utils.ScmSpy;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ManifestCustomizerService.class, hint="scm")
public class SCMManifestCustomizer
implements ManifestCustomizerService {
    @Override
    public Map<String, String> getEntries(PackageMojo mojo, MavenProject project) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (mojo.isSkipScmMetadata()) {
            return attributes;
        }
        if (project.getScm() != null) {
            String connectionUrl;
            Scm scm = project.getScm();
            String string = connectionUrl = scm.getConnection() == null ? scm.getDeveloperConnection() : scm.getConnection();
            if (scm.getUrl() != null) {
                attributes.put("Scm-Url", scm.getUrl());
            }
            if (scm.getTag() != null) {
                attributes.put("Scm-Tag", scm.getTag());
            }
            if (mojo.getScmManager() != null && connectionUrl != null) {
                try {
                    File baseDir = project.getBasedir();
                    ScmSpy scmSpy = new ScmSpy(mojo.getScmManager());
                    Map<String, String> scmChangeLogMap = scmSpy.getChangeLog(connectionUrl, baseDir);
                    if (!scmChangeLogMap.isEmpty()) {
                        attributes.put("Scm-Type", scmChangeLogMap.get(ExtraManifestKeys.scmType.name()));
                        attributes.put("Scm-Revision", scmChangeLogMap.get(ExtraManifestKeys.scmRevision.name()));
                        attributes.put("Last-Commit-Timestamp", scmChangeLogMap.get(ExtraManifestKeys.lastCommitTimestamp.name()));
                        attributes.put("Author", scmChangeLogMap.get(ExtraManifestKeys.author.name()));
                    }
                }
                catch (Exception e) {
                    mojo.getLog().warn((CharSequence)("Error while getting SCM Metadata `" + e.getMessage() + "`"));
                    mojo.getLog().warn((CharSequence)"SCM metadata ignored");
                    mojo.getLog().debug((Throwable)e);
                }
            }
        }
        return attributes;
    }
}

