/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.components.impl;

import com.google.common.io.Closeables;
import io.fabric8.vertx.maven.plugin.components.ServiceFileCombinationConfig;
import io.fabric8.vertx.maven.plugin.components.ServiceFileCombiner;
import io.fabric8.vertx.maven.plugin.components.ServiceUtils;
import io.fabric8.vertx.maven.plugin.components.impl.GroovyExtensionCombiner;
import io.fabric8.vertx.maven.plugin.model.CombinationStrategy;
import io.fabric8.vertx.maven.plugin.mojos.DependencySet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.ArtifactIncludeFilterTransformer;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.SelectorUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

@Component(role=ServiceFileCombiner.class)
public class ServiceFileCombinationImpl
implements ServiceFileCombiner {
    @Override
    public void doCombine(ServiceFileCombinationConfig config) {
        if (config.getStrategy() == CombinationStrategy.none) {
            return;
        }
        List<String> patterns = config.getArchive().getDescriptorCombinationPatterns();
        if (patterns.isEmpty()) {
            return;
        }
        Log logger = Objects.requireNonNull(config.getMojo().getLog());
        DependencySet set = new DependencySet();
        set.addInclude("*");
        ScopeFilter scopeFilter = ServiceUtils.newScopeFilter("runtime");
        ArtifactFilter filter = new ArtifactIncludeFilterTransformer().transform(scopeFilter);
        try {
            Set<Artifact> artifacts = ServiceUtils.filterArtifacts(config.getArtifacts(), set.getIncludes(), Collections.emptyList(), true, logger, filter);
            List<File> files = artifacts.stream().map(Artifact::getFile).filter(File::isFile).filter(f -> f.getName().endsWith(".jar")).collect(Collectors.toList());
            this.combine(config.getProject(), patterns, logger, files);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to combine SPI files for " + config.getProject().getArtifactId(), e);
        }
    }

    private void combine(MavenProject project, List<String> patterns, Log logger, List<File> dependencies) {
        Map<String, List<String>> locals = this.findLocalDescriptors(project, patterns);
        Map<String, List<List<String>>> deps = this.findDescriptorsFromDependencies(dependencies, patterns);
        if (logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Descriptors declared in the project: " + locals.keySet()));
            logger.debug((CharSequence)("Descriptors declared in dependencies: " + deps.keySet()));
        }
        LinkedHashSet<String> descriptorsToMerge = new LinkedHashSet<String>(locals.keySet());
        descriptorsToMerge.addAll(deps.keySet());
        HashMap<String, List> descriptors = new HashMap<String, List>();
        for (String spi : descriptorsToMerge) {
            descriptors.put(spi, this.merge(project, spi, locals.get(spi), deps.get(spi)));
        }
        File out = new File(project.getBuild().getOutputDirectory());
        descriptors.forEach((name, content) -> {
            File merged = new File(out, (String)name);
            try {
                FileUtils.writeLines((File)merged, (Collection)content);
                logger.debug((CharSequence)("Descriptor combined into " + merged.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot write combined Descriptor files", e);
            }
        });
    }

    private List<String> merge(MavenProject project, String name, List<String> local, List<List<String>> deps) {
        if (name.equals("org.codehaus.groovy.runtime.ExtensionModule")) {
            return GroovyExtensionCombiner.merge(project.getArtifactId(), project.getVersion(), local, deps);
        }
        LinkedHashSet fromDeps = new LinkedHashSet();
        if (deps != null) {
            deps.forEach(fromDeps::addAll);
        }
        LinkedHashSet lines = new LinkedHashSet();
        if (local != null) {
            if (local.isEmpty()) {
                return Collections.emptyList();
            }
            for (String line : local) {
                if (line.trim().equalsIgnoreCase("${combine}")) {
                    lines.addAll(fromDeps);
                    continue;
                }
                lines.add(line);
            }
            return new ArrayList<String>(lines);
        }
        return new ArrayList<String>(fromDeps);
    }

    private Map<String, List<String>> findLocalDescriptors(MavenProject project, List<String> patterns) {
        String[] paths;
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        File classes = new File(project.getBuild().getOutputDirectory());
        if (!classes.isDirectory()) {
            return map;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(classes);
        scanner.setIncludes(patterns.toArray(new String[0]));
        scanner.scan();
        for (String p : paths = scanner.getIncludedFiles()) {
            File file = new File(classes, p);
            if (!file.isFile()) continue;
            try {
                String relative = classes.toURI().relativize(file.toURI()).getPath().replace("\\", "/");
                map.put("/" + relative, FileUtils.readLines((File)file, (String)"UTF-8"));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read " + file.getAbsolutePath(), e);
            }
        }
        return map;
    }

    private Map<String, List<List<String>>> findDescriptorsFromDependencies(List<File> deps, List<String> patterns) {
        LinkedHashMap<String, List<List<String>>> map = new LinkedHashMap<String, List<List<String>>>();
        for (File file : deps) {
            JavaArchive archive = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)file);
            Map content = archive.getContent(path -> {
                for (String pattern : patterns) {
                    if (!SelectorUtils.match((String)pattern, (String)path.get())) continue;
                    return true;
                }
                return false;
            });
            for (Map.Entry entry : content.entrySet()) {
                List lines;
                Asset asset = ((Node)entry.getValue()).getAsset();
                if (asset == null) continue;
                InputStream input = null;
                String path2 = ((ArchivePath)entry.getKey()).get();
                try {
                    input = asset.openStream();
                    lines = IOUtils.readLines((InputStream)input, (String)"UTF-8");
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot read " + path2, e);
                }
                finally {
                    Closeables.closeQuietly((InputStream)input);
                }
                ArrayList<List> items = (ArrayList<List>)map.get(path2);
                if (items == null) {
                    items = new ArrayList<List>();
                }
                items.add(lines);
                map.put(path2, items);
            }
        }
        return map;
    }
}

