/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.mojos;

import io.fabric8.vertx.maven.plugin.components.ManifestCustomizerService;
import io.fabric8.vertx.maven.plugin.components.PackageConfig;
import io.fabric8.vertx.maven.plugin.components.PackageService;
import io.fabric8.vertx.maven.plugin.components.PackagingException;
import io.fabric8.vertx.maven.plugin.components.ServiceFileCombinationConfig;
import io.fabric8.vertx.maven.plugin.components.ServiceFileCombiner;
import io.fabric8.vertx.maven.plugin.components.ServiceUtils;
import io.fabric8.vertx.maven.plugin.model.CombinationStrategy;
import io.fabric8.vertx.maven.plugin.mojos.AbstractVertxMojo;
import io.fabric8.vertx.maven.plugin.mojos.Archive;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageMojo
extends AbstractVertxMojo {
    @Parameter(name="serviceProviderCombination", defaultValue="combine")
    protected CombinationStrategy serviceProviderCombination;
    @Parameter(name="classifier")
    protected String classifier;
    @Parameter(name="attach", defaultValue="true")
    protected boolean attach;
    @Component
    protected PackageService packageService;
    @Component
    protected ServiceFileCombiner combiner;
    @Parameter(alias="skipScmMetadata", property="vertx.skipScmMetadata", defaultValue="false")
    protected boolean skipScmMetadata;

    public static String computeOutputName(MavenProject project, String classifier) {
        String finalName = project.getBuild().getFinalName();
        if (finalName != null) {
            if (finalName.endsWith(".jar")) {
                finalName = finalName.substring(0, finalName.length() - 4);
            }
            if (classifier != null && !classifier.isEmpty()) {
                finalName = finalName + "-" + classifier;
            }
            finalName = finalName + ".jar";
            return finalName;
        }
        finalName = project.getArtifactId() + "-" + project.getVersion();
        if (classifier != null && !classifier.isEmpty()) {
            finalName = finalName + "-" + classifier;
        }
        finalName = finalName + ".jar";
        return finalName;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File jar;
        if (this.skip) {
            this.getLog().info((CharSequence)"vertx:package skipped by configuration");
            return;
        }
        if (this.classifier != null && this.classifier.trim().isEmpty()) {
            this.getLog().debug((CharSequence)"The classifier is empty, it won't be used");
            this.classifier = null;
        }
        if (this.classifier == null && !this.attach) {
            throw new MojoExecutionException("Cannot disable attachment of the created archive when it's the main artifact");
        }
        Archive archive = ServiceUtils.getDefaultFatJar();
        if (this.launcher != null && !this.launcher.trim().isEmpty()) {
            archive.getManifest().putIfAbsent("Main-Class", this.launcher);
        }
        if (this.verticle != null && !this.verticle.trim().isEmpty()) {
            archive.getManifest().putIfAbsent("Main-Verticle", this.verticle);
        }
        List<ManifestCustomizerService> customizers = this.getManifestCustomizers();
        customizers.forEach(customizer -> archive.getManifest().putAll(customizer.getEntries(this, this.project)));
        this.combiner.doCombine((ServiceFileCombinationConfig)new ServiceFileCombinationConfig().setStrategy(this.serviceProviderCombination).setProject(this.project).setArchive(archive).setMojo(this).setArtifacts(this.project.getArtifacts()));
        try {
            jar = this.packageService.doPackage(((PackageConfig)new PackageConfig().setArtifacts(this.project.getArtifacts())).setMojo(this).setOutput(new File(this.projectBuildDir, PackageMojo.computeOutputName(this.project, this.classifier))).setProject(this.project).setArchive(archive));
        }
        catch (PackagingException e) {
            throw new MojoExecutionException("Unable to build the fat jar", (Exception)e);
        }
        if (jar.isFile() && this.classifier != null && this.attach) {
            DefaultArtifactHandler handler = new DefaultArtifactHandler("jar");
            DefaultArtifact vertxJarArtifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "jar", this.classifier, (ArtifactHandler)handler);
            vertxJarArtifact.setFile(jar);
            this.project.addAttachedArtifact((Artifact)vertxJarArtifact);
        }
    }

    private List<ManifestCustomizerService> getManifestCustomizers() throws MojoExecutionException {
        List customizers;
        try {
            customizers = this.container.lookupList(ManifestCustomizerService.class);
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to retrieve the " + ManifestCustomizerService.class.getName() + " components");
        }
        return customizers;
    }

    public boolean isSkipScmMetadata() {
        return this.skipScmMetadata;
    }
}

