/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.utils;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.maven.plugin.logging.Log;

public class IncrementalBuilder
extends FileAlterationListenerAdaptor
implements Runnable,
Closeable {
    private final Log logger;
    private final List<Callable<Void>> chain;
    private FileAlterationMonitor monitor;
    private Hashtable<Path, FileAlterationObserver> observers = new Hashtable();

    public IncrementalBuilder(Set<Path> inclDirs, List<Callable<Void>> chain, Log logger, long watchTimeInterval) {
        this.chain = chain;
        this.logger = logger;
        this.monitor = new FileAlterationMonitor(watchTimeInterval);
        inclDirs.forEach(this::buildObserver);
    }

    @Override
    public void run() {
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            this.logger.error((CharSequence)"Unable to start Incremental Builder", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.monitor != null) {
            try {
                this.monitor.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected synchronized void buildObserver(Path path) {
        this.logger.info((CharSequence)("Observing path:" + path.toString()));
        FileAlterationObserver observer = new FileAlterationObserver(path.toFile());
        observer.addListener((FileAlterationListener)this);
        this.observers.put(path, observer);
        this.monitor.addObserver(observer);
    }

    protected synchronized void syncMonitor() {
        this.observers.forEach((path, observer) -> this.monitor.getObservers().forEach(observer2 -> {
            Path path1 = Paths.get(observer2.getDirectory().toString(), new String[0]);
            if (!this.observers.containsKey(path1)) {
                this.monitor.removeObserver(observer2);
            }
        }));
    }

    public void onDirectoryCreate(File directory) {
        this.buildObserver(Paths.get(directory.toString(), new String[0]));
        this.syncMonitor();
    }

    public void onDirectoryDelete(File directory) {
        this.observers.remove(Paths.get(directory.toString(), new String[0]));
        this.syncMonitor();
    }

    public void onFileCreate(File file) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("File Created: " + file));
        }
        this.triggerBuild(file);
    }

    public void onFileChange(File file) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("File Changed: " + file));
        }
        this.triggerBuild(file);
    }

    public void onFileDelete(File file) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("File Deleted: " + file));
        }
        this.triggerBuild(file);
    }

    private void triggerBuild(File file) {
        try {
            for (Callable<Void> task : this.chain) {
                task.call();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

