/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.utils;

import io.fabric8.vertx.maven.plugin.functions.Executor;
import java.io.File;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class JavaExecutor
implements Executor<Optional<Process>> {
    Collection<URL> classPathUrls = Collections.emptyList();
    Path javaPath = this.findJava();

    protected void addClasspath(List<String> argsList) throws MojoExecutionException {
        try {
            StringBuilder classpath = new StringBuilder();
            for (URL ele : this.classPathUrls) {
                classpath = classpath.append(classpath.length() > 0 ? File.pathSeparator : "").append(new File(ele.toURI()));
            }
            String oldClasspath = System.getProperty("java.class.path");
            if (oldClasspath != null) {
                classpath.append(File.pathSeparator);
                classpath.append(oldClasspath);
            }
            argsList.add(0, "-cp");
            argsList.add(1, classpath.toString());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not build classpath", ex);
        }
    }

    private Path findJava() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            throw new RuntimeException("unable to locate java binary");
        }
        Path binDir = FileSystems.getDefault().getPath(javaHome, "bin");
        Path java = binDir.resolve("java.exe");
        if (java.toFile().exists()) {
            return java;
        }
        java = binDir.resolve("java");
        if (java.toFile().exists()) {
            return java;
        }
        throw new RuntimeException("unable to locate java binary");
    }
}

