/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.utils;

import io.fabric8.vertx.maven.plugin.utils.JavaExecutor;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.Commandline;

public class JavaProcessExecutor
extends JavaExecutor {
    protected List<String> argsList = new ArrayList<String>();
    protected Log logger;
    protected boolean waitFor = true;
    protected File workingDirectory;
    protected Thread watchdog;
    protected List<String> jvmArgs;

    @Override
    public Optional<Process> execute() throws Exception {
        Commandline commandLine = this.buildCommandLine();
        Process process = null;
        try {
            this.logger.debug((CharSequence)("Executing command :" + commandLine));
            Process reference = process = commandLine.execute();
            this.watchdog = new Thread(() -> {
                if (reference != null && reference.isAlive()) {
                    reference.destroy();
                }
            });
            Runtime.getRuntime().addShutdownHook(this.watchdog);
            if (this.waitFor) {
                this.redirectOutput(process, this.logger);
                process.waitFor();
                if (!process.isAlive()) {
                    Runtime.getRuntime().removeShutdownHook(this.watchdog);
                }
            }
            return Optional.of(process);
        }
        catch (InterruptedException e) {
            if (process.isAlive()) {
                process.destroy();
            }
            return Optional.empty();
        }
        catch (Exception e) {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            throw new Exception("Error running java command : " + e.getMessage(), e);
        }
    }

    @Override
    public Commandline buildCommandLine() throws Exception {
        Commandline cli = new Commandline();
        cli.getShell().setQuotedArgumentsEnabled(false);
        cli.setExecutable(this.javaPath.toString());
        cli.setWorkingDirectory(this.workingDirectory);
        this.addClasspath(this.argsList);
        this.argsLine(cli);
        return cli;
    }

    @Override
    public void argsLine(Commandline commandline) {
        ArrayList<String> full = new ArrayList<String>(this.jvmArgs);
        full.addAll(this.argsList);
        full.forEach(arg -> {
            Arg cliArg = commandline.createArg();
            cliArg.setValue(arg);
        });
    }

    public JavaProcessExecutor withArgs(List<String> argsList) {
        this.argsList = argsList;
        return this;
    }

    public JavaProcessExecutor withLogger(Log logger) {
        this.logger = logger;
        return this;
    }

    public JavaProcessExecutor withClassPath(Collection<URL> classPathUrls) {
        this.classPathUrls = classPathUrls;
        return this;
    }

    public JavaProcessExecutor withWaitFor(boolean waitFor) {
        this.waitFor = waitFor;
        return this;
    }

    public JavaProcessExecutor withJvmOpts(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs == null ? Collections.emptyList() : jvmArgs;
        return this;
    }
}

